package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;

import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinErrorCodes;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1ads.plugin.applovin.AdConfigApplovin;
import com.yodo1ads.plugin.applovin.AdvertCoreApplovin;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapterapplovin extends AdVideoAdapterBase {

    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调
    private AppLovinIncentivizedInterstitial myIncent ;

    // Reward Listener
    AppLovinAdRewardListener adRewardListener = new AppLovinAdRewardListener() {
        @Override
        public void userRewardVerified(AppLovinAd appLovinAd, Map map) {
            // AppLovin servers validated the reward. Refresh user balance from your server.  We will also pass the number of coins
            // awarded and the name of the currency.  However, ideally, you should verify this with your server before granting it.

            // i.e. - "Coins", "Gold", whatever you set in the dashboard.
            String currencyName = (String) map.get("currency");

            // For example, "5" or "5.00" if you've specified an amount in the UI.
            String amountGivenString = (String) map.get("amount");

            YLog.d("Rewarded " + amountGivenString + " " + currencyName);
            // By default we'll show a alert informing your user of the currency & amount earned.
            // If you don't want this, you can turn it off in the Manage Apps UI.
        }

        @Override
        public void userOverQuota(AppLovinAd appLovinAd, Map map) {
            // Your user has already earned the max amount you allowed for the day at this point, so
            // don't give them any more money. By default we'll show them a alert explaining this,
            // though you can change that from the AppLovin dashboard.
        }

        @Override
        public void userRewardRejected(AppLovinAd appLovinAd, Map map) {
            // Your user couldn't be granted a reward for this view. This could happen if you've blacklisted
            // them, for example. Don't grant them any currency. By default we'll show them an alert explaining this,
            // though you can change that from the AppLovin dashboard.
        }

        @Override
        public void validationRequestFailed(AppLovinAd appLovinAd, int responseCode) {
            if (responseCode == AppLovinErrorCodes.INCENTIVIZED_USER_CLOSED_VIDEO) {
                // Your user exited the video prematurely. It's up to you if you'd still like to grant
                // a reward in this case. Most developers choose not to. Note that this case can occur
                // after a reward was initially granted (since reward validation happens as soon as a
                // video is launched).
            } else if (responseCode == AppLovinErrorCodes.INCENTIVIZED_SERVER_TIMEOUT || responseCode == AppLovinErrorCodes.INCENTIVIZED_UNKNOWN_SERVER_ERROR) {
                // Some server issue happened here. Don't grant a reward. By default we'll show the user
                // a alert telling them to try again later, but you can change this in the
                // AppLovin dashboard.
            } else if (responseCode == AppLovinErrorCodes.INCENTIVIZED_NO_AD_PRELOADED) {
                // Indicates that the developer called for a rewarded video before one was available.
                // Note: This code is only possible when working with rewarded videos.
            }
        }

        @Override
        public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
            // This method will be invoked if the user selected "no" when asked if they want to view an ad.
            // If you've disabled the pre-video prompt in the "Manage Apps" UI on our website, then this method won't be called.
        }
    };

    // Video Playback Listener
    AppLovinAdVideoPlaybackListener adVideoPlaybackListener = new AppLovinAdVideoPlaybackListener() {
        @Override
        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    // Ad Dispaly Listener
    AppLovinAdDisplayListener adDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {

        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };

    // Ad Click Listener
    AppLovinAdClickListener adClickListener = new AppLovinAdClickListener() {
        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };
    private AppLovinAdLoadListener adLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_LOADED, getAdvertCode());
            }
            if (reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH,getAdvertCode());
            }
        }

        @Override
        public void failedToReceiveAd(int errorCode) {
//        adErrorCode==204    Indicates that no ads are currently eligible for your device & location
            YLog.w("Advert, Applovin Video onAdError, adError code = " + errorCode);
            if(errorCode == AppLovinErrorCodes.NO_FILL){
                // Indicates that no ads are currently eligible for your device & location.
                YLog.w("Advert, Applovin Video onAdError, NO_FILL " );
            }
            else{
                // Unable to reach AppLovin; the user's device is likely experiencing poor connectivity.
            }
        }
    };
    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        if (myIncent.isAdReadyToDisplay()){
            myIncent.show(activity, adRewardListener, adVideoPlaybackListener, adDisplayListener, adClickListener);
        }else {
            videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        myIncent = AppLovinIncentivizedInterstitial.create(activity);
        myIncent.preload(adLoadListener);
        reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD, getAdvertCode());
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return myIncent.isAdReadyToDisplay();
    }

    @Override
    public String getAdvertCode() {
        return AdConfigApplovin.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AppLovinSdk.initializeSdk(activity);

//        AdvertCoreApplovin.getInstance().init(activity);

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        myIncent.dismiss();
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
