package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;


import com.adcolony.sdk.AdColony;
import com.adcolony.sdk.AdColonyAdOptions;
import com.adcolony.sdk.AdColonyAppOptions;
import com.adcolony.sdk.AdColonyInterstitial;
import com.adcolony.sdk.AdColonyInterstitialListener;
import com.adcolony.sdk.AdColonyReward;
import com.adcolony.sdk.AdColonyRewardListener;
import com.adcolony.sdk.AdColonyUserMetadata;
import com.adcolony.sdk.AdColonyZone;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.adcolony.AdConfigAdcolony;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapteradcolony extends AdVideoAdapterBase {

    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调
    private boolean available = false;
    private AdColonyInterstitial ad;
    private AdColonyAdOptions ad_options;

    /**
     * Set up listener for interstitial ad callbacks. You only need to implement the callbacks
     * that you care about. The only required callback is onRequestFilled, as this is the only
     * way to get an ad object.
     */
    private AdColonyInterstitialListener listener = new AdColonyInterstitialListener()
    {
        /** Ad passed back in request filled callback, ad can now be shown */
        @Override
        public void onRequestFilled( AdColonyInterstitial adcolonyAd )
        {
            AdvertAdapteradcolony.this.ad = adcolonyAd;
            available = true;
            YLog.i(  "Advert Adcolony onRequestFilled" );
        }

        /** Ad request was not filled */
        @Override
        public void onRequestNotFilled( AdColonyZone zone )
        {
            YLog.i(  "Advert Adcolony onRequestNotFilled");
        }

        /** Ad opened, reset UI to reflect state change */
        @Override
        public void onOpened( AdColonyInterstitial ad )
        {

            if (videoCallback!=null){

                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        /** Request a new ad if ad is expiring */
        @Override
        public void onExpiring( AdColonyInterstitial ad )
        {

        }
    };



    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        YLog.d("Advert Adcolony   showVideoAdvert ");
        if (available ){

            ad.show();
        }else {
            videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        available = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        YLog.d("Advert Adcolony   reloadVideoAdvert ");
        if (TextUtils.isEmpty( AdConfigAdcolony.APP_ID) && TextUtils.isEmpty( AdConfigAdcolony.ZONE_ID)){
            YLog.d("Advert Adcolony   APP_ID和ZONE_ID  为null");
            return;
        }
        if (ad == null || ad.isExpired()){
            /**
             * Optionally update location info in the ad options for each request:
             * LocationManager location_manager = (LocationManager) getSystemService( Context.LOCATION_SERVICE );
             * Location location = location_manager.getLastKnownLocation( LocationManager.GPS_PROVIDER );
             * ad_options.setUserMetadata( ad_options.getUserMetadata().setUserLocation( location ) );
             */
            AdColony.requestInterstitial( AdConfigAdcolony.ZONE_ID, listener, ad_options );
        }


    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return available;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigAdcolony.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {
        //Configure AdColony in your launching Activity's onCreate() method
        //so that ads can be available as soon as possible.

        AdConfigAdcolony.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigAdcolony.CHANNEL_CODE, AdConfigAdcolony.KEY_ADCOLONY_APP_ID);
        AdConfigAdcolony.ZONE_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigAdcolony.CHANNEL_CODE, AdConfigAdcolony.KEY_ADCOLONY_ZONE_ID);


        if (TextUtils.isEmpty( AdConfigAdcolony.APP_ID) && TextUtils.isEmpty( AdConfigAdcolony.ZONE_ID)){
            YLog.d("Advert Adcolony   APP_ID和ZONE_ID  为null");
            return;
        }

        /** Construct optional app options object to be sent with configure */
        AdColonyAppOptions app_options = new AdColonyAppOptions()
                .setUserID( "unique_user_id" );

        AdColony.configure(activity, app_options, AdConfigAdcolony.APP_ID, AdConfigAdcolony.ZONE_ID);
        //Register an AdColonyAdAvailabilityListener to be notified of changes in a zone's
        //ad availability.

        /** Optional user metadata sent with the ad options in each request */
        AdColonyUserMetadata metadata = new AdColonyUserMetadata()
                .setUserAge( 26 )
                .setUserEducation( AdColonyUserMetadata.USER_EDUCATION_BACHELORS_DEGREE )
                .setUserGender( AdColonyUserMetadata.USER_MALE );

        /** Ad specific options to be sent with request */
        ad_options = new AdColonyAdOptions()
                .enableConfirmationDialog( true )
                .enableResultsDialog( true )
                .setUserMetadata( metadata );

        /** Create and set a reward listener */
        AdColony.setRewardListener( new AdColonyRewardListener()
        {
            @Override
            public void onReward( AdColonyReward reward )
            {
                /** Query reward object for info here */
                if (videoCallback!=null){
                    if (reward.success()){
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                    } else {
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }

                }
            }
        } );




    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }

}
