package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Handler;

import com.qq.e.ads.interstitial.AbstractInterstitialADListener;
import com.qq.e.ads.interstitial.InterstitialAD;
import com.qq.e.comm.util.AdError;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.gdt.AdConfigGdt;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1PropertiesUtils;

/**
 * Created by yodo1 on 2016/3/23.
 */
public class AdvertAdaptergdt extends AdInterstitialAdapterBase {
    private boolean isLoaded = false; //是否成功加载
    private InterstitialAD iad;
    private Yodo1InterstitialCallback intersititalCallback; //插屏回调

    private AbstractInterstitialADListener adListener = new AbstractInterstitialADListener() {
        @Override
        public void onADReceive() {
            isLoaded = true;
            YLog.i("Advert, Gdt Interstitial onADReceive ... ");
        }

        @Override
        public void onNoAD(AdError adError) {
            isLoaded = false;
            YLog.e("Advert, Gdt Interstitial onNoAD ... ");
        }

        @Override
        public void onADClosed() {
            YLog.i("Advert Gdt onAdClose ...");
            isLoaded = false;
            new Handler().postDelayed(new Runnable() {
                public void run() {
                    //execute the task
                    if(intersititalCallback != null){
                        intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }
                }

            }, 1000);



        }

        @Override
        public void onADClicked() {


            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onADOpened() {
            YLog.i("Advert Gdt onADOpened ...");
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onADExposure() {

        }

        @Override
        public void onADLeftApplication() {

        }
    };

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        YLog.i("Advert, showIntersititalAdvert , Gdt");
        this.intersititalCallback = callback;

        if (iad !=null && isLoaded){
            iad.show();
        }else {
            if(intersititalCallback != null){
                intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            }
        }

        isLoaded = false;
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        isLoaded = false;

        if (iad == null) {
            iad = new InterstitialAD(activity, AdConfigGdt.APP_ID, AdConfigGdt.INTERSTITIAL_ID);
        }

        iad.setADListener(adListener);
        iad.loadAD();
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigGdt.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }


    @Override
    public void onCreate(Activity activity) {
        AdConfigGdt.INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_INTERSTITIAL_ID);
        AdConfigGdt.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_APP_ID);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
