package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.baidu.mobads.AdView;
import com.baidu.mobads.InterstitialAd;
import com.baidu.mobads.InterstitialAdListener;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.baidu.AdConfigBaidu;
import com.yodo1ads.plugin.baidu.AdvertCoreBaidu;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/23.
 */
public class AdvertAdapterbaidu extends AdInterstitialAdapterBase {
    private boolean isLoaded = false; //是否成功加载
    private InterstitialAd interAd;
    private Yodo1InterstitialCallback intersititalCallback; //插屏回调
    private InterstitialAdListener adListener = new InterstitialAdListener(){

        @Override
        public void onAdReady() {
            isLoaded = true;
        }

        @Override
        public void onAdPresent() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClick(InterstitialAd interstitialAd) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDismissed() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onAdFailed(String s) {

        }
    };

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        YLog.i("Advert, showIntersititalAdvert , Baidu     ");
        this.intersititalCallback = callback;

        if (isLoaded && interAd.isAdReady()) {
            interAd.showAd(activity);
        } else {
            intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        isLoaded = false;
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        isLoaded = false;

        if (TextUtils.isEmpty(AdConfigBaidu.INTERSTITIAL_ID)){
            YLog.e("Baidu key is null");
            return;
        }


        if (interAd == null){
//            String adPlaceId = "2403633"; // 重要：请填上您的广告位ID，代码位错误会导致无法请求到广告
            interAd = new InterstitialAd(activity, AdConfigBaidu.INTERSTITIAL_ID);

        }
        interAd.setListener(adListener);
        interAd.loadAd();

    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigBaidu.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreBaidu.getInstance().validateAdsAdapter(activity);
    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigBaidu.INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigBaidu.CHANNEL_CODE
                , AdConfigBaidu.KEY_Baidu_INTERSTITIAL_ID);
        AdConfigBaidu.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigBaidu.CHANNEL_CODE
                , AdConfigBaidu.KEY_Baidu_APP_ID);

        if (TextUtils.isEmpty(AdConfigBaidu.APP_ID)){
            YLog.e("Baidu key is null");
            return;
        }
        InterstitialAd.setAppSid(activity, AdConfigBaidu.APP_ID);

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
