package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;

import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1ads.plugin.applovin.AdConfigApplovin;


public class AdvertAdapterapplovin extends AdInterstitialAdapterBase implements AppLovinAdLoadListener,
        AppLovinAdDisplayListener, AppLovinAdClickListener, AppLovinAdVideoPlaybackListener {

    private Yodo1InterstitialCallback intersititalCallback; //插屏回调
    private Yodo1InterstitialReloadCallback callback;
    private AppLovinAd   currentAd;
    @Override
    public String getAdvertCode() {
        return AdConfigApplovin.CHANNEL_CODE;
    }

    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        this.callback = callback;
        AppLovinSdk.getInstance( activity.getApplicationContext() ).getAdService().loadNextAd( AppLovinAdSize.INTERSTITIAL, this );
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return currentAd == null? false: true ;
    }

    @Override
    public void showIntersititalAdvert(Activity activity,final Yodo1InterstitialCallback callback) {
        this.intersititalCallback = callback;
        if ( currentAd != null ){
                    /*
                     NOTE: We recommend the use of placements (AFTER creating them in your dashboard):

                     interstitialAd.show( "SINGLE_INSTANCE_SCREEN" );

                     To learn more about placements, check out https://applovin.com/integration#androidPlacementsIntegration
                    */
            final AppLovinSdk sdk = AppLovinSdk.getInstance( activity );

            final AppLovinInterstitialAdDialog interstitialAd = AppLovinInterstitialAd.create(sdk,  activity);
            interstitialAd.setAdDisplayListener( this );
            interstitialAd.setAdClickListener( this );
            interstitialAd.setAdVideoPlaybackListener( this );
            interstitialAd.showAndRender( currentAd );
        } else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }


    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        if(intersititalCallback != null){
            intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
        }
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        if(intersititalCallback != null){
            intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        if(intersititalCallback != null){
            intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
        }
    }

    @Override
    public void adReceived(AppLovinAd appLovinAd) {
        currentAd = appLovinAd;
        if(callback != null){
            callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
        }
    }

    @Override
    public void failedToReceiveAd(int i) {
        if(callback != null){
            callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED, getAdvertCode());
        }
    }

    @Override
    public void videoPlaybackBegan(AppLovinAd appLovinAd) {

    }

    @Override
    public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {

    }
}
