package com.yodo1ads.adapter.banner;


import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;

import com.baidu.mobads.AdView;
import com.baidu.mobads.AdViewListener;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.banner.Yodo1BannerCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.baidu.AdConfigBaidu;
import com.yodo1ads.plugin.baidu.AdvertCoreBaidu;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONObject;


/**
 * Created by yodo1 on 2016/4/7.
 */
public class AdvertAdapterbaidu extends AdBannerAdapterBase {
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private boolean showTag = false;
    private Yodo1BannerCallback callback;
    private int refreshTime = 15;
    private boolean isLoaded = false;
    private AdView adView;
    private AdViewListener adViewListener = new AdViewListener() {
        public void onAdSwitch() {
            YLog.i("Baidu     onAdSwitch");
        }

        public void onAdShow(JSONObject info) {
            // 广告已经渲染出来
            YLog.i("Baidu     onAdShow " + info.toString());
            if (callback != null){
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
            isLoaded = true;
        }

        public void onAdReady(AdView adView) {
            // 资源已经缓存完毕，还没有渲染出来
            YLog.i("Baidu     onAdReady " + adView);

        }

        public void onAdFailed(String reason) {
            YLog.i("Baidu     onAdFailed " + reason);
        }

        public void onAdClick(JSONObject info) {
            // YLog.i("Baidu     onAdClick " + info.toString());
            if (callback != null){
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(JSONObject arg0) {
            YLog.i("Baidu     onAdClose");
            if (callback != null){
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };
    @Override
    public String getAdvertCode() {
        return AdConfigBaidu.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreBaidu.getInstance().validateAdsAdapter(activity);
    }


    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigBaidu.BANNERL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigBaidu.CHANNEL_CODE
                , AdConfigBaidu.KEY_Baidu_BANNER_ID);
        AdConfigBaidu.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigBaidu.CHANNEL_CODE
                , AdConfigBaidu.KEY_Baidu_APP_ID);

        if (TextUtils.isEmpty(AdConfigBaidu.APP_ID) && TextUtils.isEmpty(AdConfigBaidu.BANNERL_ID)){
            YLog.e("Baidu  SDKKey  is null");
            return;
        }
        AdView.setAppSid(activity, AdConfigBaidu.APP_ID);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (adView != null) {
            adView.destroy();
        }
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }



    @Override
    public void showBanner(Activity activity,final Yodo1BannerCallback callback) {
        this.callback = callback;
        showTag = true;

        if (TextUtils.isEmpty(AdConfigBaidu.APP_ID) && TextUtils.isEmpty(AdConfigBaidu.BANNERL_ID)){
            YLog.e("Baidu       SDKKey  is null");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "SDK_KEY null",getAdvertCode());
            return;
        }
        if (adView == null) {
            showTag = true;
            YLog.d("Baidu   showBanner");
            adView = new AdView(activity, AdConfigBaidu.BANNERL_ID);
            // 设置监听器
            adView.setListener(adViewListener);
            Yodo1BannerAlign.setYodo1BannerLayout(activity,adView,align);
        } else {
            if (isLoaded ){
                YLog.d("Baidu   showBanner VISIBLE");
                adView.setVisibility(View.VISIBLE);
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            } else {
                callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "showBannerFailed",getAdvertCode());
            }

        }

    }

    @Override
    public void removeBanner(Activity activity) {
        showTag = false;
        isLoaded = false;

        if (adView != null) {
            adView.setVisibility(View.GONE);
            Yodo1BannerAlign.removeYodo1BannerLayout(activity,adView);
            adView.destroy();
            adView = null;
        }

    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d("Baidu      hideBanner ");
        showTag = false;

        if (adView != null) {
            adView.setVisibility(View.GONE);
        }
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
    }

    @Override
    public boolean hasLoadBanner() {
        return adView == null ? true : isLoaded;
    }


}
