package com.yodo1.plugin.dmp.yodo1.utils;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;

import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Created by yodo1 on 2016/5/25.
 */
public class Yodo1DeviceUtils {
    private static final String TAG = "Yodo1DeviceUtils";


    /**
     * 获取手机品牌
     *
     * @return  手机品牌
     */
    public static String getPhoneBrand (){
        String handSetInfo=android.os.Build.BRAND ;
        return handSetInfo;

    }

    /**
     * 获取手机型号
     *
     * @return  手机型号
     */
    public static String getPhoneVersion(){
        String handSetInfo=android.os.Build.MODEL ;
        return handSetInfo;

    }

    /**
     * 获取手机版本
     *
     * @return  系统版本
     */
    public static String getOsVersion(){
        String handSetInfo=android.os.Build.VERSION.RELEASE;
        return handSetInfo;

    }


    /**
     * 使用WIFI时，获取本机IP地址
     * @param mContext
     * @return
     */
    public static String getWIFILocalIpAdress(Context mContext) {

        //获取wifi服务
        WifiManager wifiManager = (WifiManager)mContext.getSystemService(Context.WIFI_SERVICE);
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        // 获取32位整型IP地址
        int ipAddress = wifiInfo.getIpAddress();

        //返回整型地址转换成“*.*.*.*”地址
        return String.format("%d.%d.%d.%d",
                (ipAddress & 0xff), (ipAddress >> 8 & 0xff),
                (ipAddress >> 16 & 0xff), (ipAddress >> 24 & 0xff));
    }


    /**
     * 获取MAC地址
     * @param context
     * @return
     */
    public static String getMacAddress(Context context){
        String macStr = "";
        WifiManager wifi = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        if(wifi != null){
            WifiInfo info = wifi.getConnectionInfo();
            if(info != null){
                macStr = info.getMacAddress();
                if(TextUtils.isEmpty(macStr)){
                    macStr = "";
                }
            }
        }
        return macStr;
    }


    private final static String getSerial(){
        String serialnum = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class );
            serialnum = (String)(   get.invoke(c, "ro.serialno", "unknown" )  );
        }catch (Exception e){
            e.printStackTrace();
        }
        return serialnum;
    }

    public static String getDeviceId(Context context){
        String deviceId = getAdvertiserId(context);//读取Google服务广告ID
        if (TextUtils.isEmpty(deviceId)){
             deviceId = Yodo1FileUtils.readFilesFromSDCard(Yodo1FileUtils.YODO1FILE);

            if (TextUtils.isEmpty(deviceId)){
                deviceId = Yodo1SharedPreferences.getString(context,"deviceId");;//读取设备ID
            }

            if (TextUtils.isEmpty(deviceId)) {
                deviceId = java.util.UUID.randomUUID().toString();
                Yodo1SharedPreferences.put(context,"deviceId",deviceId);
                Yodo1FileUtils.writeFilesToSDCard(deviceId, Yodo1FileUtils.YODO1FILE);
            }
        }


        return deviceId;
    }

    public static String getAdvertiserId(Context context) {
        try {
            String[] e = getAdvertisingIdInfo(context);
            return e.length > 0 && e[0] != null?e[0]:"";
        } catch (Exception var3) {
            return "";
        }
    }

    public static String[] getAdvertisingIdInfo(Context c) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class mAdvertisingIdClientClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
        Method getAdvertisingIdInfoMethod = mAdvertisingIdClientClass.getMethod("getAdvertisingIdInfo", new Class[]{Context.class});
        Object mInfoClass = getAdvertisingIdInfoMethod.invoke(mAdvertisingIdClientClass, new Object[]{c});
        Method getIdMethod = mInfoClass.getClass().getMethod("getId", new Class[0]);
        Method isLimitAdTrackingEnabledMethod = mInfoClass.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
        String advertisingId = getIdMethod.invoke(mInfoClass, new Object[0]).toString();
        boolean isLimitedTrackingEnabled = ((Boolean)isLimitAdTrackingEnabledMethod.invoke(mInfoClass, new Object[0])).booleanValue();
        return new String[]{advertisingId, "" + isLimitedTrackingEnabled};
    }

    public static String getPackagename(Context context) {
        try {
            String pkName = context.getPackageName();
            return pkName;
        } catch (Exception e) {
        }
        return null;
    }


}
