package com.yodo1.plugin.dmp.yodo1.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Base64;
import android.widget.Toast;

import com.yodo1.sdk.kit.YLog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

//import org.apache.commons.codec.binary.Base64;

public class Yodo1CommonUtil {
	private static final String TAG = "Yodo1CommonUtil";

	/**
	 * 判定网络状态
	 * 
	 * @param context
	 * @return
	 */
	public static boolean hasNetwork(Context context) {
		if (context !=null){
			// 检查网络状态
			ConnectivityManager con = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo workinfo = con.getActiveNetworkInfo();
			if (workinfo == null || !workinfo.isAvailable()) {
				Toast.makeText(context, "网络异常，请检查网络！", Toast.LENGTH_SHORT).show();
				return false;
			}
		}
		return true;
	}



	/**
	 * 获取现在时间
	 * 
	 * @return 返回短时间字符串格式yyyy-MM-dd HH:mm:ss
	 */

	public static String getStringDate() {
		Date currentTime = new Date();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String dateString = formatter.format(currentTime);
		return dateString;
	}

	/**
	 * 获取UTC时间戳
	 * */
	public static long getUTCTime(){
		String format = "yyyy-MM-dd HH:mm:ss";
		try {
			DateFormat dateFormatter = new SimpleDateFormat(format);
			TimeZone pst = TimeZone.getTimeZone("Etc/GMT+0");

			dateFormatter.setTimeZone(pst);
			String timeStr = dateFormatter.format(new Date());
//			YLog.i("timeStr==" + timeStr);

			Date date = new SimpleDateFormat(format).parse(timeStr);
			long unixTimestamp = date.getTime();
//			YLog.i("unixTimestamp==" + unixTimestamp);
			return unixTimestamp;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return System.currentTimeMillis();
	}




	/**
	 *获取当前应用程序信息  包名
	 */
	public static String getPageInfo(Context context){
		PackageInfo info;
		String packageNames = null;
		try {
			info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
//			// 当前应用的版本名称
//			String versionName = info.versionName;
//			// 当前版本的版本号
//			int versionCode = info.versionCode;
			// 当前版本的包名
			packageNames = info.packageName;
		} catch (PackageManager.NameNotFoundException e) {
			e.printStackTrace();
		}

		return  packageNames;
	}

	 /**
	 2  * 获取版本号
	 3  * @return 当前应用的版本号
	 4  */
	 public static String getVersion(Context context) {
		 PackageInfo info;
		 String versionName = null;
		 try {
			 info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
//			// 当前应用的版本名称
			 versionName = info.versionName;
//			// 当前版本的版本号
//			int versionCode = info.versionCode;
			 // 当前版本的包名
//			 packageNames = info.packageName;
		 } catch (PackageManager.NameNotFoundException e) {
			 e.printStackTrace();
		 }

		 return  versionName;
	 }
	/**
	 * 字符串  转 数组
	 * @param str
	 * @return
	 */
	public static String[] strToArray(String str){

		String[] arrayStr = new String[] {};// 字符数组


		if (!TextUtils.isEmpty(str)){

			String s = str.substring(2,str.length()-2);
			arrayStr = s.split("\",\"");// 字符串按都好切割 转字符串数组

		}

		return arrayStr;
	}

	public static String hmacWithKey(String key, byte[] data)
	{
		String result = "";
		try
		{
			Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
			SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
			sha256_HMAC.init(secret_key);

			result = Base64.encodeToString(sha256_HMAC.doFinal(data), 0);
			YLog.d("hmacWithKey result==" + result);
		}
		catch (NoSuchAlgorithmException e)
		{
			e.printStackTrace();
		}
		catch (InvalidKeyException e)
		{
			e.printStackTrace();
		}
		catch (UnsupportedEncodingException e)
		{
			e.printStackTrace();
		}

		return result;
	}

	public static byte[] gzipCompress(String data) throws IOException {
		if ((data == null) || (data.length() == 0))
		{
			return new byte[0];
		}

		ByteArrayOutputStream baostream = null;
		GZIPOutputStream outStream = null;
		try
		{
			baostream = new ByteArrayOutputStream();
			outStream = new GZIPOutputStream(baostream)
			{
			};
			outStream.write(data.getBytes("UTF-8"));
			outStream.close();

			return baostream.toByteArray();
		}
		finally
		{
			try
			{
				if (baostream != null)
				{
					baostream.close();
				}
				if (outStream != null)
				{
					outStream.close();
				}
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
	}

}
