package com.yodo1.plugin.dmp.yodo1.helper;

/**
 * Created by yodo1 on 17/12/1.
 */

public class GAHTTPApi
{
    private String protocol;
    private String hostName;
    private String version;
    private String baseUrl;
    private String initializeUrlPath;
    private String eventsUrlPath;
    private String gamekey = "";
    private String gameSecret = "";
    private String initsubmitStr = "";

    public String getInitsubmitStr() {
        return initsubmitStr;
    }

    private GAHTTPApi(String key, String secret, boolean isTest)
    {
        gamekey = key;
        gameSecret = secret;
        this.protocol = "http";
        if(isTest) {
            this.hostName = "sandbox-api.gameanalytics.com";
        } else {
            this.hostName = "api.sdkdev.io";
        }
        this.version = "v2";

        this.baseUrl = (this.protocol + "://" + this.hostName + "/" + this.version);

        this.initsubmitStr = "{\"platform\": \"android\", \"sdk_version\": \"rest api v2\", \"os_version\": \"android " + android.os.Build.VERSION.SDK_INT + "\"}";

        this.initializeUrlPath = "init";
        this.eventsUrlPath = "events";
    }

    public static GAHTTPApi getInstance(String key, String secret, boolean isTest)
    {
        GAHTTPApi INSTANCE = new GAHTTPApi(key, secret, isTest);
        return INSTANCE;
    }

    public String URL_init(){
        String url = this.baseUrl + "/" + gamekey + "/" + this.initializeUrlPath;
        return url;
    }

    public String URL_events(){
        String url = this.baseUrl + "/" + gamekey + "/" + this.eventsUrlPath;
        return url;
    }
}
