package com.yodo1.advert.utils;

import android.text.TextUtils;

import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;

import java.util.Locale;

/**
 * 在线参数获取工具
 * <p>
 * Created by yodo1 on 2016/3/18.
 */
public class YOnlineConfigUtils {

    /**
     * 获取插屏广告的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);

        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 获取游戏视频广告的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertVideo() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * 获取Baner的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertBanner() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }



    /**
     * 获取插屏广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getIntervalAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getIntervalConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e("YOnlineConfigUtils, 获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 0;
    }


    /**
     * 获取插屏广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getSwitchingCycle() {
        String value = Yodo1OnlineConfigAgent.getSwitchingCycleConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e("YOnlineConfigUtils, 获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 30 * 1000;
    }

    /**
     * 获得插屏,视频广告的权重  无渠道，无版本号
     *
     * @return
     */
    public static String[] getWeightAdvert(Yodo1AdvertAdapterFactory.AdvertType advertType) {
        String value = null;
        if (advertType == Yodo1AdvertAdapterFactory.AdvertType.Interstitial) {
            value = Yodo1OnlineConfigAgent.getWeightConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd).toLowerCase(Locale.getDefault());
        } else if (advertType == Yodo1AdvertAdapterFactory.AdvertType.Video) {
            value = Yodo1OnlineConfigAgent.getWeightConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd).toLowerCase(Locale.getDefault());
        } else if (advertType == Yodo1AdvertAdapterFactory.AdvertType.Banner) {
            value = Yodo1OnlineConfigAgent.getWeightConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd).toLowerCase(Locale.getDefault());
        }
        if (!TextUtils.isEmpty(value)) {
            value = value.replaceAll("，", ",");
            value = value.replaceAll(" ", "");
            String[] weight = value.split(",");
            return weight;
        }
        return new String[0];
    }


    /**
     * 获得插屏，视频广告的播放量占比  无渠道，无版本号
     *
     * @return
     */
    public static float[] getPercentageAdvert(Yodo1AdvertAdapterFactory.AdvertType advertType) {
        String value = null;
        if (advertType == Yodo1AdvertAdapterFactory.AdvertType.Interstitial) {
            value = Yodo1OnlineConfigAgent.getPercentageConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);
        } else if (advertType == Yodo1AdvertAdapterFactory.AdvertType.Video) {
            value = Yodo1OnlineConfigAgent.getPercentageConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        } else if (advertType == Yodo1AdvertAdapterFactory.AdvertType.Banner) {
            value = Yodo1OnlineConfigAgent.getPercentageConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        }
        if (!TextUtils.isEmpty(value) && !"null".equals(value.toLowerCase(Locale.getDefault()))) {
            value = value.replaceAll("，", ",");
            value = value.replaceAll(" ", "");
            String[] weightStr = value.split(",");
            if (weightStr != null && weightStr.length > 0) {
                float[] result = new float[weightStr.length];
                for (int i = 0; i < weightStr.length; i++) {
                    try {
                        result[i] = Float.parseFloat(weightStr[i]);
                    } catch (NumberFormatException e) {
                        YLog.d("YOnlineConfigUtils, 获取广告的播放量未获取到，默认为0");
                        result[i] = 0;
                    }
                }
                return result;
            }
        }
        return new float[0];
    }


}
