package com.yodo1.advert.onlineconfig;

import android.text.TextUtils;

import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Created by zhuxiaochen on 2017/8/30.
 */

public class Yodo1OnlineConfigAgent {
    private static Map map = new HashMap();
    /**
     * 广告类型
     */
    public enum AdvertType{
        /**
         * 插屏
         */
        Platform_InterstitialAd,
        /**
         * 视频
         */
        Platform_VideoAd,
        /*
         * Banner
         */
        Platform_BannerAd,

    }

    /**
     * 广告
     */
    public enum AdvertConfig{
        /**
         * 百分比
         */
        percentage,
        /*
         * 广告key
         */
        key,

    }

    /**
     * 广告类型
     */
    public enum AdvertPlatformConfig{
        /**
         * 开关
         */
        active,
        /**
         * 配置
         */
        config,
        /**
         * 权重
         */
        weight,
        /**
         * 时间间隔
         */
        interval,
        /**
         * 循环时间间隔
         */
        switchingCycle,
    }


    /**
     * 获取在线参数 时间间隔
     * @return
     */
    public static String getIntervalConfigParam(AdvertType advertType){

        String result = "0";//默认时间间隔为0s
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (obj !=null && !obj.isNull(advertType.toString())&& !TextUtils.isEmpty(obj.optString(advertType.toString()))){
                JSONObject  obj_local = new JSONObject(obj.optString(advertType.toString()));
                JSONObject  obj_advertType = new JSONObject(obj_local.optString(getLocal()));
                result = obj_advertType.optString(AdvertPlatformConfig.interval.toString());//开关
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("getIntervalConfigParam key = " + advertType + "  开关 ： " + result );
        return result;
    }


    /**
     * 获取在线参数 轮询时间
     * @return
     */
    public static String getSwitchingCycleConfigParam(AdvertType advertType){

        String result = "30";//默认的时间间隔
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (obj !=null && !obj.isNull(advertType.toString())&& !TextUtils.isEmpty(obj.optString(advertType.toString()))){
//            if (!TextUtils.isEmpty(obj.optString(advertType.toString()))){
                JSONObject  obj_local = new JSONObject(obj.optString(advertType.toString()));
                JSONObject  obj_advertType = new JSONObject(obj_local.optString(getLocal()));
                result = obj_advertType.optString(AdvertPlatformConfig.switchingCycle.toString());//switchingCycle
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("getIntervalConfigParam key = " + advertType + "  循环时间 ： " + result );
        return result;
    }



    /**
     * 获取在线参数 开关
     * @return
     */
    public static String getActiveConfigParam(AdvertType advertType){

        String result = "";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (obj !=null && !obj.isNull(advertType.toString())&& !TextUtils.isEmpty(obj.optString(advertType.toString()))){
//            if (!TextUtils.isEmpty(obj.optString(advertType.toString()))){
                JSONObject  obj_local = new JSONObject(obj.optString(advertType.toString()));
                JSONObject  obj_advertType = new JSONObject(obj_local.optString(getLocal()));
                result = obj_advertType.optString(AdvertPlatformConfig.active.toString());//开关
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("getActiveConfigParam key = " + advertType + "  开关 ： " + result );
        return result;
    }


    /**
     * 获取在线参数  广告key
     * @return
     */
    public static String getKeyConfigParam(AdvertType advertType,String advertCode,String key){
        String result = "";
        YLog.d("getKeyConfigParam: " + key);
        try {
            JSONObject  obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (obj !=null && !obj.isNull(advertType.toString())&& !TextUtils.isEmpty(obj.optString(advertType.toString()))){
//            if (!TextUtils.isEmpty(obj.optString(advertType.toString()))){
                JSONObject  obj_local = new JSONObject(obj.optString(advertType.toString()));
                JSONObject  obj_advertType = new JSONObject(obj_local.optString(getLocal()));
                JSONObject obj_adverts = obj_advertType.optJSONObject(AdvertPlatformConfig.config.toString());

                JSONObject obj_advertCode = null;
                if (obj_adverts !=null && !obj_adverts.isNull(advertCode)&& !TextUtils.isEmpty(obj_adverts.optString(advertCode))){
                    obj_advertCode = obj_adverts.optJSONObject(advertCode);
                } else {
                    obj_advertCode = obj_adverts.optJSONObject(advertCode.toLowerCase());
                }

                YLog.d("obj_advertCode :" + obj_advertCode);
                if (obj_advertCode != null){
                    JSONObject obj_key = obj_advertCode.optJSONObject(AdvertConfig.key.name());
                    YLog.d("obj_key :" + obj_key);
                    if (obj_key != null){
                        result = obj_key.optString(key);
                        YLog.d("obj_key :" + result);
                    }
                }

            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 获取在线参数  比例
     * @return
     */
    public static String getPercentageConfigParam(AdvertType advertType){

        String result = "";
        String result2 = "";

        try {
            JSONObject  obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (obj !=null && !obj.isNull(advertType.toString())&& !TextUtils.isEmpty(obj.optString(advertType.toString()))){
//            if (!TextUtils.isEmpty(obj.optString(advertType.toString()))){
                JSONObject  obj_local = new JSONObject(obj.optString(advertType.toString()));
                JSONObject  obj_advertType = new JSONObject(obj_local.optString(getLocal()));

                JSONObject obj_adverts = obj_advertType.optJSONObject(AdvertPlatformConfig.config.toString());

                if (obj_adverts != null){
                    YLog.d("obj_adverts : " + obj_adverts.toString());
                    Iterator<String> advertCodes = obj_adverts.keys();  // 应用迭代器Iterator 获取所有的key值

                    while(advertCodes.hasNext()) {   // 遍历每个key

                        String advertCode = advertCodes.next().toString();
                        YLog.d("advertCode : " + advertCode);

                        String str = map.get(advertType.toString()).toString();
                        if (!TextUtils.isEmpty(str) ){

                            String[] sArray=str.split(",") ;
                            for (int i = 0 ;i < sArray.length ; i++){
                                String adCode = sArray[i];
                                if (!TextUtils.isEmpty(adCode) && adCode.equals(advertCode)){
                                    JSONObject obj_advertCode = null;
                                    if (obj_adverts !=null && !obj_adverts.isNull(advertCode)&& !TextUtils.isEmpty(obj_adverts.optString(advertCode))){
                                        obj_advertCode = obj_adverts.optJSONObject(advertCode);
                                    } else {
                                        obj_advertCode = obj_adverts.optJSONObject(advertCode.toLowerCase());
                                    }

                                    YLog.d("obj_advertCode : " + obj_advertCode.toString());

                                    String value = obj_advertCode.optString(AdvertConfig.percentage.name());//该广告的相关配置 比如权重，比例，key
                                    YLog.d("value : " + value);
                                    result = result+ "," +value;
                                }
                            }

                        }

                    }
                }


            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (!TextUtils.isEmpty(result) && result.startsWith(",")){
            result2 = result.substring(1,result.length());
        }
        YLog.d("getPercentageConfigParam percentage  key = " + advertType + "   " +result2);
        return result2;
    }


    /**
     * 获取在线参数  比例或者权重
     * @return
     */
    public static String getWeightConfigParam(AdvertType advertType){
        YLog.d("getWeightConfigParam advertType = " + advertType.toString() );
        JSONArray array = new JSONArray();
        StringBuilder result = new StringBuilder();
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (obj !=null && !obj.isNull(advertType.toString())&& !TextUtils.isEmpty(obj.optString(advertType.toString()))){
//            if (!TextUtils.isEmpty(obj.optString(advertType.toString()))){
                JSONObject  obj_local = new JSONObject(obj.optString(advertType.toString()));
                JSONObject  obj_advertType = new JSONObject(obj_local.optString(getLocal()));
                array = obj_advertType.optJSONArray(AdvertPlatformConfig.weight.name());//开关
                if (array != null){
                    for (int i=0 ; i< array.length() ; i++){
                        if (i == array.length()-1){
                            result.append(array.optString(i));
                        }else {
                            result.append(array.optString(i)+",");
                        }
                    }

                    map.put(advertType.name().toString(),result);
                }
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        YLog.d("getWeightConfigParam key = " + advertType + "   " +result);
        return result.toString();
    }


    /**
     * 获取当前地区  根据地区解析数据
     * @return
     */
    private static String  getLocal(){
        String country = Locale.getDefault().getCountry();
        return country.toLowerCase().equals("cn") ? "cn" : "other";
    }
}
