package com.yodo1.sdk.kit;

import android.content.Context;
import android.text.TextUtils;

public class Yodo1SdkUtils {

    private static volatile String SdkVersion = "", PublishCode = "", ChannelCode = "", SdkType = "", masVersion = "";
    private static volatile String ProjectOri = "", SdkMode = "", mainClassName = "";

    /**
     * sdk版本。
     */
    public static String getSdkVersion(Context context) {
        if (TextUtils.isEmpty(SdkVersion)) {
            SdkVersion = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKVersion");
        }
        return SdkVersion;
    }

    /**
     * 获取发行渠道名称。manifest中或properties中。
     */
    public static String getPublishCode(Context context) {
        if (TextUtils.isEmpty(PublishCode)) {
            //properties文件
            PublishCode = Yodo1PropertiesUtils.getInstance().getBasicConfigValue("CHANNEL_CODE_PUBLISH");
        }
        if (TextUtils.isEmpty(PublishCode)) {
            //manifest文件
            PublishCode = Yodo1CommonUtils.getMetedataStr(context, "Yodo1ChannelCode");
        }
        return PublishCode;
    }


    /**
     * 获取渠道号。properties中。
     */
    public static String getChannelCode(Context context) {
        if (TextUtils.isEmpty(ChannelCode)) {
            //properties文件
            ChannelCode = Yodo1PropertiesUtils.getInstance().getBasicConfigValue("CHANNEL_CODE");
        }
        return ChannelCode;
    }

    /**
     * 获取项目是横屏竖屏，properties中。
     */
    public static String getProjectOrient(Context context) {
        if (TextUtils.isEmpty(ProjectOri)) {
            ProjectOri = Yodo1PropertiesUtils.getInstance().getBasicConfigValue("thisProjectOrient");
        }
        return ProjectOri;
    }

    /**
     * sdk类型，global等。
     */
    public static String getSdkType(Context context) {
        if (TextUtils.isEmpty(SdkType)) {
            SdkType = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKType");
        }
        return SdkType;
    }

    public static String getSdkMode() {
        if (TextUtils.isEmpty(SdkMode)) {
            SdkMode = Yodo1PropertiesUtils.getInstance().getBasicConfigValue("yodo1_sdk_mode");
        }
        return SdkMode;
    }

    // TODO 拆分sdk后重新修改方法取值
    public static String getMasSdkVersion(Context context) {
        if (TextUtils.isEmpty(masVersion)) {
            masVersion = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKVersion");
        }
        return masVersion;
    }

    /**
     * 获取mainClass，主home入口
     */
    public static String getMainClassName(Context context) {
        if (TextUtils.isEmpty(mainClassName)) {
            //meta-data
            mainClassName = Yodo1CommonUtils.getMetedataStr(context, "YODO1_MAIN_CLASS");
            //properties文件
            if (TextUtils.isEmpty(mainClassName)) {
                Yodo1PropertiesUtils.getInstance().initProperties(context);
                mainClassName = Yodo1PropertiesUtils.getInstance().getBasicConfigValue("mainClassName");
            }
            //MAS need.
            if (TextUtils.isEmpty(mainClassName)) {
                mainClassName = Yodo1SharedPreferences.getString(context, "YODO1_MAIN_CLASS");
            }
        }
        return mainClassName;
    }

}
