package com.yodo1.sdk.kit;

import android.util.Log;

/**
 * Yodo1的Log输出。2020年06月01日09:53:04.
 * sdk开发层会暴露 d,i,v,w,e。sdk开发层会暴露 v,w,e。。sdk开发层隐藏请用d,i.
 *
 * @author yodo1
 */
public class YLog {

    private final static String TAG = "yodo1-games-sdk";
    /**
     * sdk接入者，log开关
     */
    private static boolean onLog = false;
    /**
     * sdk开发者，log开关。
     */
    private static boolean onDebug = false;


    public static void setOnLog(boolean isLog) {
        YLog.onLog = isLog;
    }

    public static void setDebugMode(boolean isDebug) {
        onDebug = isDebug;
    }

    //******************************v

    public final static void v(String content) {
        print(TAG, Log.VERBOSE, content, null);
    }

    public final static void v(String content, Exception e) {
        print(TAG, Log.VERBOSE, content, e);
    }

    public final static void v(String tag, String content) {
        print(TAG + " " + tag, Log.VERBOSE, content, null);
    }

    public final static void v(String tag, String content, Exception e) {
        print(TAG + " " + tag, Log.VERBOSE, content, e);
    }

    public final static void v(String tag, int level, String content, Exception e) {
        print(TAG + " " + tag, level, content, e);
    }

    //******************************d

    public final static void d(String content) {
        print(TAG, Log.DEBUG, content, null);
    }

    public final static void d(String content, Exception e) {
        print(TAG, Log.DEBUG, content, e);
    }

    public final static void d(String tag, String content) {
        print(TAG + " " + tag, Log.DEBUG, content, null);
    }

    public final static void d(String tag, String content, Exception e) {
        print(TAG + " " + tag, Log.DEBUG, content, e);
    }

    public final static void d(String tag, int level, String content, Exception e) {
        print(TAG + " " + tag, level, content, e);
    }

    //******************************i

    public final static void i(String content) {
        print(TAG, Log.INFO, content, null);
    }


    public final static void i(String content, Exception e) {
        print(TAG, Log.INFO, content, e);
    }

    public final static void i(String tag, String content) {
        print(TAG + " " + tag, Log.INFO, content, null);
    }

    public final static void i(String tag, String content, Exception e) {
        print(TAG + " " + tag, Log.INFO, content, e);
    }

    public final static void i(String tag, int level, String content, Exception e) {
        print(TAG + " " + tag, level, content, e);
    }

    //******************************w

    public final static void w(String content) {
        print(TAG, Log.WARN, content, null);
    }

    public final static void w(String content, Exception e) {
        print(TAG, Log.WARN, content, e);
    }

    public final static void w(String tag, String content) {
        print(TAG + " " + tag, Log.WARN, content, null);
    }

    public final static void w(String tag, String content, Exception e) {
        print(TAG + " " + tag, Log.WARN, content, e);
    }

    public final static void w(String tag, int level, String content, Exception e) {
        print(TAG + " " + tag, level, content, e);
    }

    //******************************e

    public final static void e(String content) {
        print(TAG, Log.ERROR, content, null);
    }

    public final static void e(String content, Exception e) {
        print(TAG, Log.ERROR, content, e);
    }

    public final static void e(String tag, String content) {
        print(TAG + " " + tag, Log.ERROR, content, null);
    }

    public final static void e(String tag, String content, Exception e) {
        print(TAG + " " + tag, Log.ERROR, content, e);
    }

    public final static void e(String tag, int level, String content, Exception e) {
        print(TAG + " " + tag, level, content, e);
    }

    //*********

    private final static void print(String tag, int level, String content, Exception e) {
        switch (level) {
            case Log.VERBOSE:
                if (onDebug) {
                    Log.v(tag, content, e);
                }
                break;
            case Log.DEBUG:
                if (onDebug) {
                    Log.d(tag, content, e);
                }
                break;
            case Log.INFO:
                if (onDebug) {
                    Log.i(tag, content, e);
                }
                break;
            case Log.WARN:
                if (onDebug || onLog) {
                    Log.w(tag, content, e);
                }
                break;
            case Log.ERROR:
                if (onDebug || onLog) {
                    Log.e(tag, content, e);
                }
                break;
            default:
                break;
        }
    }
}
