package com.yodo1.sdk.kit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;

import java.lang.reflect.Field;

/**
 * 指定包名读取resoucreId
 * <p>
 * 引用库中务必使用该类获取资源id，从而避免因为包名问题读不到或读错资源
 *
 * @author yodo1
 */
public final class RR {
    private static String _packageName = null;
    private static Resources _resources = null;

    private static final String packageName(Context context) {
        if (_packageName == null) {
            _packageName = context.getPackageName();
        }
        return _packageName;
    }

    private static final int identifier(Context context, String name, String type) {
        if (_resources == null) {
            _resources = context.getResources();
        }
        return _resources.getIdentifier(name, type, packageName(context));
    }

    public static final String stringTo(Context context, String name) {
        return context.getResources().getString(string(context, name));
    }

    public static final int string(Context context, String name) {
        return identifier(context, name, "string");
    }

    public final static int raw(Context context, String name) {
        return identifier(context, name, "raw");
    }

    public static final Drawable drawableTo(Context context, String name) {
        return context.getResources().getDrawable(drawable(context, name));
    }

    public static final int drawable(Context context, String name) {
        return identifier(context, name, "drawable");
    }

    public static final int mipmap(Context context, String name) {
        return identifier(context, name, "mipmap");
    }

    public static final int id(Context context, String name) {
        return identifier(context, name, "id");
    }

    public static final int layout(Context context, String name) {
        return identifier(context, name, "layout");
    }

    public static final int menu(Context context, String name) {
        return identifier(context, name, "menu");
    }

    public static final int style(Context context, String name) {
        return identifier(context, name, "style");
    }

    public static final int dimen(Context context, String name) {
        return identifier(context, name, "dimen");
    }

    public static final int colorTo(Context context, String name) {
        return context.getResources().getColor(color(context, name));
    }

    public static final int color(Context context, String name) {
        return identifier(context, name, "color");
    }

    public static final int anim(Context context, String name) {
        return identifier(context, name, "anim");
    }

    public static final int attr(Context context, String name) {
        return identifier(context, name, "attr");
    }


    /**
     * declare-styleable
     *
     * @param cls  R.styleable.class
     * @param name name
     * @return int[]
     */
    public static final int[] styleable(Class cls, String name) {
        Field[] allFields = cls.getFields();
        for (Field field : allFields) {
            if (name.equals(field.getName())) {
                try {
                    return (int[]) field.get(cls);
                } catch (IllegalAccessException ignore) {
                }
            }
        }

        return null;
    }

    /**
     * declare-styleable   attr
     *
     * @param cls  R.styleable.class
     * @param name name
     * @return index
     */
    public static final int styleableAttr(Class cls, String name) {
        Field[] allFields = cls.getFields();
        for (Field field : allFields) {
            if (name.equals(field.getName())) {
                try {
                    int ret = (Integer) field.get(cls);

                    return ret;
                } catch (IllegalAccessException ignore) {
                }
            }
        }

        return 0;
    }
}
