package com.yodo1.android.ops.net;

import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONObject;

/**
 * 2020年06月04日21:36:09。zjq
 *
 * @author yodo1
 */
public abstract class HttpStringListener implements OnResponseListener<String> {

    protected String requestUrl;

    public HttpStringListener(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public HttpStringListener() {
    }

    /**
     * 开始请求, 这里显示一个dialog.
     */
    @Override
    public void onStart(int what) {
    }

    /**
     * 结束请求, 这里关闭dialog.
     */
    @Override
    public void onFinish(int what) {
    }

    /**
     * 成功回调.
     */
    @Override
    public void onSucceed(int what, Response<String> response) {
        Yodo1SDKResponse responseObject = Yodo1HttpManage.getInstance().getResponseObject(what, response);
        if (responseObject.isSuccess()) {
            onSuccess(responseObject.getErrorCode(), responseObject.getMessage(), responseObject.getResponse());
        } else {
            onFailure(responseObject.getErrorCode(), responseObject.getMessage());
        }
    }

    /**
     * 失败回调.
     */
    @Override
    public void onFailed(int what, Response<String> response) {
        if (response != null && response.getException() != null) {
            YLog.i("HttpResponse", response.getException());
        }
        Yodo1SDKResponse responseObject = Yodo1HttpManage.getInstance().getResponseObject(what, response);
        onFailure(responseObject.getErrorCode(), responseObject.getMessage());
    }

    public abstract void onSuccess(int code, String msg, JSONObject responseString);

    public abstract void onFailure(int errorCode, String msg);
}
