package com.yodo1.android.ops.net;

import android.content.Context;

import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.YLog;

/**
 * Created in Nov 4, 2015 12:02:55 PM.
 *
 * @author Yan Zhenjie.
 */
public class HttpResponseListener<T> implements OnResponseListener<T> {

    /**
     * Request.
     */
    private Request<?> mRequest;
    /**
     * 结果回调.
     */
    private HttpListener<T> callback;

    /**
     * @param activity     context用来实例化dialog.
     * @param request      请求对象.
     * @param httpCallback 回调对象.
     */
    public HttpResponseListener(Context activity, Request<?> request, HttpListener<T> httpCallback) {
        this.mRequest = request;
        this.callback = httpCallback;
    }

    /**
     * 开始请求, 这里显示一个dialog.
     */
    @Override
    public void onStart(int what) {
    }

    /**
     * 结束请求, 这里关闭dialog.
     */
    @Override
    public void onFinish(int what) {
    }

    /**
     * 成功回调.
     */
    @Override
    public void onSucceed(int what, Response<T> response) {
        if (callback != null) {
            callback.onSucceed(what, response);
        }
    }

    /**
     * 失败回调.
     */
    @Override
    public void onFailed(int what, Response<T> response) {
        if (response != null && response.getException() != null) {
            YLog.i("HttpResponse", response.getException());
        }
        if (callback != null)
            callback.onFailed(what, response);
    }

}
