package com.yodo1.advert.open;

import android.app.Activity;

import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Advert Open Interface
 *
 * @author zhuxiaochen
 */
public class Yodo1Advert {
    private static final String TAG = "[Yodo1Advert] ";

    public static boolean loadAdForTypeMobile = true;
    private static Yodo1Privacy privacy = new Yodo1Privacy();
    private static Yodo1AdvertHelper helper = Yodo1AdvertHelper.getInstance();

    public static Yodo1Privacy getPrivacy() {
        return privacy;
    }

    /**
     * Initialize SDK, make sure call the method in your activity’s “onCreate” method.
     *
     * @param activity Activity
     * @param appKey   The app key obtained from MAS Developer Platform
     */
    public static void initSDK(Activity activity, String appKey) {
        helper.init(activity, appKey);
    }

    public static void setOnLog(boolean onLog) {
        if (onLog) {
            YLog.d(TAG + "The Log has been enabled.");
            YLog.setOnLog(true);
        }
    }

    /**
     * SDK requires that publishers set a flag indicating whether a user located in the European Economic Area (i.e., EEA/GDPR data subject) has provided opt-in consent for the collection and use of personal data.
     *
     * @param consent true, If the user has consented, false otherwise.
     */
    public static void setUserConsent(boolean consent) {
        YLog.i(TAG + "The user has consented: " + consent);
        privacy.setHasUserConsent(consent);
        helper.setPrivacy(privacy);
    }

    /**
     * To ensure COPPA, GDPR, and Google Play policy compliance, you should indicate whether a user is a child.
     *
     * @param underAgeOfConsent true, If the user is known to be in an age-restricted category (i.e., under the age of 16), false otherwise.
     */
    public static void setTagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        YLog.i(TAG + "The user is a child: " + underAgeOfConsent);
        privacy.setAgeRestrictedUser(underAgeOfConsent);
        helper.setPrivacy(privacy);
    }

    /**
     * Publishers may choose to display a "Do Not Sell My Personal Information" link. Such publishers may choose to set a flag indicating whether a user located in California, USA has opted to not have their personal data sold.
     *
     * @param doNotSell true, If the user has opted out of the sale of their personal information, false otherwise.
     */
    public static void setDoNotSell(boolean doNotSell) {
        YLog.i(TAG + "The user has opted out of the sale of their personal information: " + doNotSell);
        privacy.setDoNotSell(doNotSell);
        helper.setPrivacy(privacy);
    }

    /**
     * 设置是否在4G时加载广告
     *
     * @deprecated The method setLoadAdForMobile has been deprecated
     */
    @Deprecated
    public static void setLoadAdForMobile(boolean enable) {
        loadAdForTypeMobile = enable;
        YLog.i(TAG + "The ad is loaded in the non-wifi state: " + loadAdForTypeMobile);
    }

    /**
     * Show interstitial Ad.
     *
     * @param activity Activity
     * @param callback The callback method of show interstitial ad
     * @return true, if the interstitial ad has been shown, false otherwise.
     */
    public static boolean showInterstitial(final Activity activity, final InterstitialCallback callback) {
        YLog.d(TAG + "The showInterstitialAd method is called ...");
        return helper.showInterstitialAd(activity, "default", callback);
    }

    /**
     * Show interstitial Ad.
     *
     * @param activity    Activity
     * @param placementId Placement Id
     * @param callback    The callback method of show interstitial ad
     * @return true, if the interstitial ad has been shown, false otherwise.
     */
    public static boolean showInterstitial(final Activity activity, final String placementId, final InterstitialCallback callback) {
        YLog.d(TAG + "The interstitialIsReady method is called ... placementId: " + placementId);
        return helper.showInterstitialAd(activity, placementId, callback);
    }

    /**
     * Whether the interstitial ads have been cached.
     *
     * @param activity Activity
     * @return true, if the interstitial ads have been cached, false otherwise.
     */
    public static boolean interstitialIsReady(Activity activity) {
        YLog.d(TAG + "The interstitialIsReady method is called ...");
        return helper.interstitialAdIsLoaded(activity);
    }

    /**
     * Show reward video Ad.
     *
     * @param activity Activity
     * @param callback The callback method of show reward video ad
     * @return true, if the reward video ad has been shown, false otherwise.
     */
    public static boolean showVideo(final Activity activity, final VideoCallback callback) {
        YLog.d(TAG + "The showVideo method is called ...");
        return helper.showVideoAd(activity, "default", callback);
    }

    /**
     * Show reward video Ad.
     *
     * @param activity    Activity
     * @param placementId Placement Id
     * @param callback    The callback method of show reward video ad
     * @return true, if the reward video ad has been shown, false otherwise.
     */
    public static boolean showVideo(final Activity activity, final String placementId, final VideoCallback callback) {
        YLog.d(TAG + "The showVideo method is called ... placementId: " + placementId);
        return helper.showVideoAd(activity, placementId, callback);
    }

    /**
     * Whether reward video ads have been cached.
     *
     * @param activity Activity
     * @return true, if the reward video ads have been cached, false otherwise.
     */
    public static boolean videoIsReady(Activity activity) {
        YLog.d(TAG + "The videoIsReady method is called ...");
        return helper.videoAdIsLoaded(activity);
    }

    /**
     * Show the native Ad, the MAS games ignore this method.
     *
     * @param activity Activity
     * @param px       The X coordinates for native ads
     * @param py       The Y coordinates for native ads
     * @param pw       The Width of native ads
     * @param ph       The height of native ads
     * @param callback The callback method of show native ad
     * @return true, if the native ad has been shown, false otherwise.
     */
    public static boolean showNative(final Activity activity, float px, float py, float pw, float ph, final NativeCallback callback) {
        YLog.d(TAG + "The showNative method is called ...");
        return helper.showNativeAd(activity, "default", px, py, pw, ph, callback);
    }

    /**
     * Show the native Ad, the MAS games ignore this method.
     *
     * @param activity    Activity
     * @param placementId Placement Id
     * @param px          The X coordinates for native ads
     * @param py          The Y coordinates for native ads
     * @param pw          The Width of native ads
     * @param ph          The height of native ads
     * @param callback    The callback method of show native ad
     * @return true, if the native ad has been shown, false otherwise.
     */
    public static boolean showNative(final Activity activity, final String placementId, float px, float py, float pw, float ph, final NativeCallback callback) {
        return helper.showNativeAd(activity, placementId, px, py, pw, ph, callback);
    }

    /**
     * Whether the native ads have been cached, the MAS games ignore this method.
     *
     * @param activity Activity
     * @return true, if the native ads have been cached, false otherwise.
     */
    public static boolean nativeIsReady(Activity activity) {
        return helper.nativeAdIsLoaded(activity);
    }

    /**
     * Remove the native ad, the MAS games ignore this method.
     *
     * @param activity Activity
     */
    public static void removeNative(Activity activity) {
        helper.removeNativeAd(activity);
    }

    /**
     * Show the splash ad, the MAS games ignore this method.
     *
     * @param activity Activity
     * @param callback callback
     * @return true, if the splash ads have been shown, false otherwise.
     */
    public static boolean showSplash(final Activity activity, final SplashCallback callback) {
        YLog.d(TAG + "The showSplash method is called ...");
        return helper.showSplashAd(activity, callback);
    }

    /**
     * Set the alignment of banner ad.
     *
     * @param activity Activity
     * @param align    The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     * @deprecated The method SetBannerAlign has been deprecated, please use the method {@link #setBannerAlign} instead
     */
    @Deprecated
    public static void SetBannerAlign(Activity activity, int align) {
        YLog.d(TAG + "The SetBannerAlign method is called ...");
        helper.SetBannerAlign(activity, align);
    }

    /**
     * Set the alignment of banner ad.
     *
     * @param activity Activity
     * @param align    The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     */
    public static void setBannerAlign(Activity activity, int align) {
        YLog.d(TAG + "The setBannerAlign method is called ...");
        helper.setBannerAlign(activity, align);
    }

    /**
     * Show the banner ad.
     *
     * @param activity Activity
     * @param callback The callback method of banner ad
     * @deprecated The method ShowBanner has been deprecated, please use the method {@link #showBanner} instead
     */
    @Deprecated
    public static void ShowBanner(Activity activity, BannerCallback callback) {
        YLog.d(TAG + "The ShowBanner method is called ...");
        helper.ShowBanner(activity, callback);
    }

    /**
     * Show the banner ad.
     *
     * @param activity Activity
     * @param callback The callback method of banner ad
     */
    public static void showBanner(Activity activity, BannerCallback callback) {
        YLog.d(TAG + "The showBanner method is called ...");
        helper.showBanner(activity, "default", callback);
    }

    public static void showBanner(Activity activity, final String placementId, BannerCallback callback) {
        YLog.d(TAG + "The showBanner method is called ...");
        helper.showBanner(activity, placementId, callback);
    }

    /**
     * Hide the banner ad.
     *
     * @param activity Activity
     * @deprecated The method HideBanner has been deprecated, please use the method {@link #hideBanner} instead
     */
    @Deprecated
    public static void HideBanner(Activity activity) {
        YLog.d(TAG + "The HideBanner method is called ...");
        helper.HideBanner1(activity);
    }

    /**
     * Hide the banner ad.
     *
     * @param activity Activity
     */
    public static void hideBanner(Activity activity) {
        YLog.d(TAG + "The hideBanner method is called ...");
        helper.hideBanner1(activity);
    }

    /**
     * Remove the banner ad.
     *
     * @param activity Activity
     * @deprecated The method RemoveBanner has been deprecated, please use the method {@link #removeBanner} instead
     */
    public static void RemoveBanner(Activity activity) {
        YLog.d(TAG + "The RemoveBanner method is called ...");
        helper.RemoveBanner1(activity);
    }

    /**
     * Remove the banner ad.
     *
     * @param activity Activity
     */
    public static void removeBanner(Activity activity) {
        YLog.d(TAG + "The removeBanner method is called ...");
        helper.removeBanner1(activity);
    }
}
