package com.yodo1.advert.helper;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;

import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1NetWorkUtils;
import com.yodo1.sdk.kit.Yodo1SdkUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import static com.yodo1.advert.entity.AdvertType.Banner;
import static com.yodo1.advert.entity.AdvertType.Interstitial;
import static com.yodo1.advert.entity.AdvertType.Native;
import static com.yodo1.advert.entity.AdvertType.Splash;
import static com.yodo1.advert.entity.AdvertType.Video;


/**
 * 广告异常上报。使用子线程线程池处理提交。2020年04月16日15:55:28。avoid ANR.
 *
 * @author sunmeng
 */
public class Yodo1ErrorUpdataHelper {

    private static final String TAG = "[Yodo1ErrorUpdataHelper] ";

    private static final String URL_ERROR_REPORT = "https://hades.yodo1api.com/hades/feedback";
    private static final String KEY_ERROR_UPDATE_MESSAGE = "Yodo1ErrorUpdataMsg";
    private static JSONArray errorsJsonArray = new JSONArray();
    private List<String> list;
    private Executor executor;


    private Yodo1ErrorUpdataHelper() {
        list = new ArrayList<String>();
        executor = Executors.newCachedThreadPool();
    }

    static Yodo1ErrorUpdataHelper getInstance() {
        return Yodo1ErrorUpdataHelperInstance.INSTANCE;
    }

    public void errorCollection(final Context context, final String advertCode, final int errorCode, final int adErrorCode, final String adErrorMsg, final AdvertType advertType) {
        YLog.d(TAG + "AdvertCode:" + advertCode + ", advertType: " + advertType + ", adErrorCode: " + adErrorCode + ", adErrorMessage: " + adErrorMsg);
        Runnable errorCacheRunnable = new Runnable() {
            @Override
            public void run() {
                String tag = advertCode + "&" + advertType.name();
                if (list.contains(tag)) {
                    YLog.d(TAG + "当前上报信息中已经包含此异常信息，重复信息将不再保存");
                    return;
                }
                list.add(tag);
                JSONObject object = new JSONObject();
                try {
                    object.put("target", advertCode);
                    object.put("time", System.currentTimeMillis());

                    if (advertType == Interstitial) {
                        object.put("step_id", "requestInterstitialAD");
                        object.put("step_des", "请求插屏广告");
                    } else if (advertType == Video) {
                        object.put("step_id", "requestVideoAD");
                        object.put("step_des", "请求视频广告");
                    } else if (advertType == Banner) {
                        object.put("step_id", "requestBannerAD");
                        object.put("step_des", "展示Banner广告");
                    } else if (advertType == Splash) {
                        object.put("step_id", "requestSplashAD");
                        object.put("step_des", "展示开屏广告");
                    } else if (advertType == Native) {
                        object.put("step_id", "requestNativeAD");
                        object.put("step_des", "请求原生广告");
                    }

                    if (errorCode == Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION) {
                        if (adErrorCode == 0 & !TextUtils.isEmpty(adErrorMsg)) {
                            //Ad Network 没有Error Code
                            object.put("type_id", "1003");
                            object.put("type_des", adErrorMsg);
                        } else if (adErrorCode != 0 & TextUtils.isEmpty(adErrorMsg)) {
                            //Ad Network 没有Error Message
                            object.put("type_id", adErrorCode);
                            object.put("type_des", "广告请求失败");
                        } else {
                            object.put("type_id", adErrorCode);
                            object.put("type_des", adErrorMsg);
                        }

                        object.put("advice_solver", "it");
                    } else if (errorCode == Yodo1AdConst.ADVERT_ERROR_ID_NULL) {
                        object.put("type_id", "1000");
                        object.put("type_des", "缺少参数");
                        object.put("advice_solver", "ops");
                    }
                    errorsJsonArray.put(object);
                    Yodo1SharedPreferences.put(context, KEY_ERROR_UPDATE_MESSAGE, errorsJsonArray.toString());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        executor.execute(errorCacheRunnable);
    }

    /**
     * 信息上报
     *
     * @param context Context
     * @param appKey  AppKey
     */
    public void reportErrors(final Context context, final String appKey) {
        if (context == null || TextUtils.isEmpty(appKey)) {
            return;
        }
        boolean isReportData = Yodo1Advert.getPrivacy().isReportData();
        if (!isReportData) {
            YLog.d(TAG + "Stop report ad errors, privacy isReportData: " + isReportData);
            return;
        }
        boolean adSwitch = YOnlineConfigUtils.isTrunOnErrorUpdataSwitch();
        if (!adSwitch) {
            YLog.d(TAG + "Stop report ad errors, the report switch is off");
            return;
        }
        Runnable reportErrorRunnable = new Runnable() {
            @Override
            public void run() {
                //首先获取设备ID
                Looper.prepare();

                String errorMsg = Yodo1SharedPreferences.getString(context, KEY_ERROR_UPDATE_MESSAGE);
                if (TextUtils.isEmpty(errorMsg)) {
                    YLog.d(TAG + "Stop report ad errors, no cached ad errors.");
                    return;
                }

                int net = Yodo1NetWorkUtils.getAPNType(context);
                String netType;
                if (net == 1) {
                    netType = "wifi";
                } else if (net == 2) {
                    netType = "4g";
                } else if (net == 3) {
                    netType = "2g";
                } else {
                    netType = "net_error";
                }

                String gaid = "";
                try {
                    gaid = Yodo1DeviceUtils.getGoogleAdId(context);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                JSONObject submitJson = new JSONObject();
                JSONObject dataJson = new JSONObject();
                try {
                    JSONArray errJson = new JSONArray(errorMsg);
                    dataJson.put("game_appkey", appKey);
                    dataJson.put("game_version", SysUtils.getVersionName(context));
                    dataJson.put("channel", Yodo1SdkUtils.getPublishCode(context));
                    dataJson.put("sdk_type", Yodo1SdkUtils.getSdkType(context));
                    dataJson.put("sdk_version", Yodo1SdkUtils.getSdkVersion(context));
                    dataJson.put("os", "android");
                    dataJson.put("os_version", Yodo1DeviceUtils.getOsVersion());
                    dataJson.put("device_id", Yodo1DeviceUtils.getDeviceId(context));
                    dataJson.put("device_name", Yodo1DeviceUtils.getPhoneVersion());
                    dataJson.put("device_country_code", Yodo1DeviceUtils.getCountryCode(context));
                    dataJson.put("device_language_code", Yodo1DeviceUtils.getLanguageCode(context));
                    dataJson.put("android_gaid", gaid);
                    dataJson.put("android_id", Yodo1DeviceUtils.getAndroidID(context));
                    dataJson.put("android_imei", Yodo1DeviceUtils.getIMEI(context));
                    dataJson.put("network", netType);
                    dataJson.put("error", errJson);

                    long timestamp = System.currentTimeMillis();
                    submitJson.put("record", "client_ad");
                    submitJson.put("sign", MD5EncodeUtil.MD5Encode("client_ad" + timestamp + "yodo1"));
                    submitJson.put("timestamp", timestamp);
                    submitJson.put("data", dataJson);

                    reportErrorsToServer(context, submitJson);
                } catch (JSONException e) {
                    YLog.d(TAG + "Report ad errors exception...");
                    e.printStackTrace();
                }

                Looper.loop();
            }
        };
        executor.execute(reportErrorRunnable);
    }

    private void reportErrorsToServer(final Context context, JSONObject jsonObject) {
        if (context == null || jsonObject == null || TextUtils.isEmpty(jsonObject.toString())) {
            return;
        }

        Request<String> request = NoHttp.createStringRequest(URL_ERROR_REPORT, RequestMethod.POST);
        request.setDefineRequestBody(jsonObject.toString(), "text/plain;charset=UTF-8");
        YLog.d(TAG + "Request body: " + jsonObject.toString());
        YLog.d(TAG + "Sending POST request to " + request.url());
        Yodo1HttpManage.getInstance().connect(100, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d(TAG + "Connect onSucceed, what: " + what + ", the response: " + (response == null ? "null" : response.get()));
                Yodo1SharedPreferences.put(context, KEY_ERROR_UPDATE_MESSAGE, "");
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                YLog.d(TAG + "Connect onFailed, what: " + what + ", the response: " + (response == null ? "null" : response.get()));
            }
        }, false);
    }

    private static class Yodo1ErrorUpdataHelperInstance {
        private static final Yodo1ErrorUpdataHelper INSTANCE = new Yodo1ErrorUpdataHelper();
    }
}
