package com.yodo1.advert.factory;

import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.sdk.kit.YLog;


/**
 * @author yodo1
 */
public class Yodo1SplashAdActivity extends Activity {
    private static final String TAG = "[Yodo1SplashAdActivity] ";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getWindow().getDecorView().setSystemUiVisibility(
                View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                        | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION // hide nav
                        // bar
                        | View.SYSTEM_UI_FLAG_FULLSCREEN // hide status bar
                        | View.SYSTEM_UI_FLAG_IMMERSIVE);

        goShowSplashAd();

    }

    /**
     * 展示广告
     */
    private void goShowSplashAd() {

        Yodo1Advert.showSplash(Yodo1SplashAdActivity.this, new SplashCallback() {
            @Override
            public void onSplashClosed() {
                YLog.i(TAG + "splash广告关闭");

                finish();
            }

            @Override
            public void onSplashShow() {
                YLog.i(TAG + "splash广告展示成功");
            }

            @Override
            public void onSplashShowFailed(AdErrorCode errorCode) {
                YLog.i(TAG + "splash广告展示失败 ： " + errorCode);

                finish();
            }

            @Override
            public void onSplashClicked() {
                YLog.i(TAG + "splash广告点击");
            }
        });
    }


    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK || keyCode == KeyEvent.KEYCODE_HOME) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}
