package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.vungle.warren.BuildConfig;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author yodo1
 */
public class AdvertAdaptervungle extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptervungle] ";
    private static final String CHANNEL_CODE = "Vungle";

    private static final String KEY_APP_ID = "ad_vungle_app_id";
    private static final String KEY_PLACEMENT_ID_REWARDED_VIDEO = "ad_vungle_video_placementid";
    private static final String KEY_PLACEMENT_ID_INTERSTITIAL = "ad_vungle_inter_placementid";

    private static String appId, interstitialPlacementId, rewardedVideoPlacementId;

    private final PlayAdCallback playAdCallback = new PlayAdCallback() {

        @Override
        public void onAdStart(String placementId) {
            YLog.d(TAG + "PlayAdCallback onAdStart, placementId: " + placementId);

            if (placementId.equals(interstitialPlacementId)) {
                if (getInterstitialCallback() != null) {
                    getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }

            if (placementId.equals(rewardedVideoPlacementId)) {
                if (getVideoCallback() != null) {
                    getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }
        }

        @Override
        public void onAdEnd(String id, boolean completed, boolean isCTAClicked) {

        }

        @Override
        public void onAdEnd(String placementId) {
            YLog.d(TAG + "PlayAdCallback onAdEnd, placementId: " + placementId);
            if (placementId.equals(interstitialPlacementId) && getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (placementId.equals(rewardedVideoPlacementId) && getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onAdClick(String placementId) {
            YLog.d(TAG + "PlayAdCallback onAdClick, placementId: " + placementId);
            if (placementId.equals(interstitialPlacementId) && getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }

            if (placementId.equals(rewardedVideoPlacementId) && getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdRewarded(String placementId) {
            YLog.d(TAG + "PlayAdCallback onAdRewarded, placementId: " + placementId);
            if (placementId.equals(rewardedVideoPlacementId) && getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onAdLeftApplication(String placementId) {
            YLog.d(TAG + "PlayAdCallback onAdLeftApplication, placementId: " + placementId);
        }

        @Override
        public void onError(String placementId, VungleException exception) {
            YLog.d(TAG + "PlayAdCallback onError, placementId: " + placementId + ", " + exception.getLocalizedMessage());
        }
    };

    private final LoadAdCallback loadAdCallback = new LoadAdCallback() {

        @Override
        public void onAdLoad(String placementId) {
            YLog.d(TAG + "LoadAdCallback onAdLoad, placementId: " + placementId);
            if (getReloadInterCallback() != null && placementId.equals(interstitialPlacementId)) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }

            if (getReloadVideoCallback() != null && placementId.equals(rewardedVideoPlacementId)) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onError(String placementId, VungleException exception) {
            YLog.d(TAG + "LoadAdCallback onError placementId: " + placementId + ", " + exception.getLocalizedMessage());

            if (getReloadInterCallback() != null && placementId.equals(interstitialPlacementId)) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, exception.getLocalizedMessage() + "", getAdvertCode());
            }
            if (getReloadVideoCallback() != null && placementId.equals(rewardedVideoPlacementId)) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, exception.getLocalizedMessage() + "", getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return BuildConfig.VERSION_NAME;
    }

    @Override
    public String getSdkVersion() {
        return BuildConfig.VERSION_NAME;
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {
    }


    @Override
    public void initSdk(final Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null || this.isInitialized()) {
            return;
        }

        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_ID);
        }
        if (TextUtils.isEmpty(appId)) {
            YLog.d(TAG + "Initialize sdk failure, appId: " + appId);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                updatePrivacyConsent();

                Vungle.init(appId, activity.getApplicationContext(), new InitCallback() {
                    @Override
                    public void onSuccess() {
                        setInitialized(true);
                        YLog.d(TAG + "Initialize sdk successful, onSuccess");
                        initializeCallback.onInitializeSuccess(getAdvertCode());
                    }

                    @Override
                    public void onError(VungleException exception) {
                        YLog.d(TAG + "init onError, " + exception.getLocalizedMessage());
                        initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "init error: " + exception.getLocalizedMessage(), getAdvertCode());
                    }

                    @Override
                    public void onAutoCacheAdAvailable(String s) {
                        YLog.d(TAG + "init onAutoCacheAdAvailable, s: " + s);
                    }
                });
            }
        });
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialPlacementId is null", getAdvertCode());
            return;
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interstitialPlacementId: " + interstitialPlacementId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);

        boolean isReady = interstitialAdvertIsLoaded(activity);
        YLog.d(TAG + "Showing interstitial ad...");

        if (isReady) {
            Vungle.playAd(interstitialPlacementId, null, playAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, final Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);

        YLog.d(TAG + "Loading interstitial ad...");
        this.updatePrivacyConsent();
        if (Vungle.isInitialized()) {
            Vungle.loadAd(interstitialPlacementId, loadAdCallback);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(interstitialPlacementId);
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        rewardedVideoPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(rewardedVideoPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, rewardedVideoPlacementId is null");

            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "rewardedVideoPlacementId is null", getAdvertCode());
            return;
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, rewardedVideoPlacementId: " + rewardedVideoPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setVideoCallback(callback);

        boolean isReady = videoAdvertIsLoaded(activity);
        YLog.d(TAG + "Showing rewarded video ad...");

        if (isReady) {
            Vungle.playAd(rewardedVideoPlacementId, null, playAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);

        YLog.d(TAG + "Loading rewarded video ad...");
        this.updatePrivacyConsent();
        if (Vungle.isInitialized()) {
            Vungle.loadAd(rewardedVideoPlacementId, loadAdCallback);
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(rewardedVideoPlacementId);
    }

    private void updatePrivacyConsent() {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            Vungle.Consent consentStatus = privacy.isHasUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
            Vungle.updateConsentStatus(consentStatus, "");
            if (privacy.isHasUserConsent()) {
                YLog.d(TAG + "(GDPR) The user has consented");
            } else {
                YLog.d(TAG + "(GDPR) The user has not consented");
            }

            final Vungle.Consent ccpaStatus = privacy.isDoNotSell() ? Vungle.Consent.OPTED_OUT : Vungle.Consent.OPTED_IN;
            Vungle.updateCCPAStatus(ccpaStatus);
            if (privacy.isDoNotSell()) {
                YLog.d(TAG + "(CCPA) The user has opted out of the sale of their personal information");
            } else {
                YLog.d(TAG + "(CCPA) The user has not opted out of the sale of their personal information");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
