package com.yodo1.advert.adapter;


import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdConfig;
import com.bytedance.sdk.openadsdk.TTAdConstant;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFullScreenVideoAd;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;


/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptertoutiao_gp extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptertoutiao_gp] ";
    private static final String CHANNEL_CODE = "toutiao_gp";

    private static final String KEY_APP_ID = "ad_toutiao_appid";
    private static final String KEY_PLACEMENT_ID_INTERSTITIAL = "ad_toutiao_fullscreenvideo_id";
    private static final String KEY_PLACEMENT_ID_REWARDED_VIDEO = "ad_toutiao_video_id";

    private static String appId, interstitialPlacementId, rewardedVideoPlacementId;

    private static boolean sInit;
    private TTAdNative mTTAdNative;
    private TTFullScreenVideoAd mttFullVideoAd;
    private int orientation;
    private TTRewardVideoAd mttRewardVideoAd;
    private boolean isCached = false;
    private boolean isLoading = false;

    private TTAdNative.FullScreenVideoAdListener adLister = new TTAdNative.FullScreenVideoAdListener() {

        @Override
        public void onError(int code, String message) {
            YLog.d(TAG + "FullScreenVideoAd onError code: " + code + ", message: " + message);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, code, message, getAdvertCode());
            }
        }

        @Override
        public void onFullScreenVideoAdLoad(TTFullScreenVideoAd ttFullScreenVideoAd) {
            YLog.d(TAG + "FullScreenVideoAd onFullScreenVideoAdLoad");
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
            mttFullVideoAd = ttFullScreenVideoAd;
            mttFullVideoAd.setFullScreenVideoAdInteractionListener(new TTFullScreenVideoAd.FullScreenVideoAdInteractionListener() {

                @Override
                public void onAdShow() {
                    YLog.d(TAG + "FullScreenVideoAd onAdShow - 头条插屏广告");
                    if (getInterstitialCallback() != null) {
                        getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }
                }

                @Override
                public void onAdVideoBarClick() {
                    YLog.d(TAG + "FullScreenVideoAd onAdVideoBarClick - 头条插屏广告被点击");
                    if (getInterstitialCallback() != null) {
                        getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                    }
                }

                @Override
                public void onAdClose() {
                    YLog.d(TAG + "FullScreenVideoAd onAdClose - 头条插屏广告广告关闭");
                    if (getInterstitialCallback() != null) {
                        getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }
                }

                @Override
                public void onVideoComplete() {
                    YLog.d(TAG + "FullScreenVideoAd onVideoComplete - 头条插屏广告广告播放完成");
                }

                @Override
                public void onSkippedVideo() {
                    YLog.d(TAG + "FullScreenVideoAd onSkippedVideo - 头条插屏广告广告跳过");
                }
            });
        }

        @Override
        public void onFullScreenVideoCached() {
            YLog.d(TAG + "FullScreenVideoAd onFullScreenVideoCached");
        }
    };

    private TTAdNative.RewardVideoAdListener rewardAdLister = new TTAdNative.RewardVideoAdListener() {

        @Override
        public void onError(int code, String message) {
            YLog.d(TAG + "RewardVideoAd onError code: " + code + ", message: " + message);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, code, message, getAdvertCode());
            }
        }

        @Override
        public void onRewardVideoAdLoad(TTRewardVideoAd ttRewardVideoAd) {
            YLog.d(TAG + "RewardVideoAd onRewardVideoAdLoad");
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
            mttRewardVideoAd = ttRewardVideoAd;
            mttRewardVideoAd.setRewardAdInteractionListener(new TTRewardVideoAd.RewardAdInteractionListener() {

                @Override
                public void onAdShow() {
                    YLog.d(TAG + "RewardVideoAd onAdShow");
                    if (getVideoCallback() != null) {
                        getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }

                }

                @Override
                public void onAdVideoBarClick() {
                    YLog.d(TAG + "RewardVideoAd onAdVideoBarClick");
                    if (getVideoCallback() != null) {
                        getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                    }
                }

                @Override
                public void onAdClose() {
                    YLog.d(TAG + "RewardVideoAd onAdClose");
                    if (getVideoCallback() != null) {
                        getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }
                }

                @Override
                public void onVideoComplete() {
                    YLog.d(TAG + "RewardVideoAd onVideoComplete");
                    if (getVideoCallback() != null) {
                        getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
                    }
                }

                @Override
                public void onVideoError() {
                    YLog.d(TAG + "RewardVideoAd onVideoError");
                }

                @Override
                public void onRewardVerify(boolean rewardVerify, int rewardAmount, String rewardName) {
                    YLog.d(TAG + "RewardVideoAd onRewardVerify, rewardVerify:" + rewardVerify + ", rewardAmount:" + rewardAmount + ", rewardName:" + rewardName);
                }

                @Override
                public void onSkippedVideo() {
                    YLog.d(TAG + "RewardVideoAd onSkippedVideo");

                }
            });
        }

        @Override
        public void onRewardVideoCached() {
            isCached = true;
            YLog.d(TAG + "RewardVideoAd onRewardVideoCached");
        }
    };

    /**
     * Get TTAdConfig
     * useTextureView: 使用TextureView控件播放视频,默认为SurfaceView,当有SurfaceView冲突的场景，可以使用TextureView
     * allowShowPageWhenScreenLock: 是否在锁屏场景支持展示广告落地页
     * debug: 测试阶段打开，可以通过日志排查问题，上线时去除该调用
     * coppa: Fields to indicate whether you are a child or an adult ，0:adult ，1:child
     * setGDPR: Fields to indicate whether you are protected by GDPR,  the value of GDPR : 0 close GDRP Privacy protection ，1: open GDRP Privacy protection
     *
     * @param context Context
     * @param appId   App Id
     * @return TTAdConfig
     */
    private static TTAdConfig buildConfig(Context context, String appId, Yodo1Privacy privacy) {
        return new TTAdConfig.Builder()
                .appId(appId)
                .useTextureView(true)
                .appName(SysUtils.getAppName(context))
                .titleBarTheme(TTAdConstant.TITLE_BAR_THEME_DARK)
                .allowShowPageWhenScreenLock(true)
                .debug(false)
                .coppa(privacy.isAgeRestrictedUser() ? 1 : 0)
                .setGDPR(privacy.isHasUserConsent() ? 1 : 0)
                .supportMultiProcess(false)
                .build();
    }

    private static TTAdManager get() {
        if (!sInit) {
            throw new RuntimeException("TTAdSdk is not init, please check.");
        }
        return TTAdSdk.getAdManager();
    }

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }


    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (this.isInitialized() || initializeCallback == null) {
            return;
        }

        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_ID);
        }
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd, CHANNEL_CODE, KEY_APP_ID);
        }
        if (TextUtils.isEmpty(appId)) {
            YLog.d(TAG + "Initialize sdk failure, appId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }

        TTAdSdk.init(activity, buildConfig(activity, appId, getPrivacy()));

        sInit = true;

        //创建TTAdNative对象,用于调用广告请求接口
        mTTAdNative = get().createAdNative(activity);

        YLog.d(TAG + "Initialize sdk successful, " + "appId: " + appId);

        this.setInitialized(true);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (!this.isInitialized() || initializeCallback == null) {
            return;
        }

        if (this.isInterInitialized()) {
            return;
        }

        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialPlacementId is null", getAdvertCode());
            return;
        }

        YLog.d(TAG + "Initialize interstitial ad successful, interstitialPlacementId: " + interstitialPlacementId);

        // 判断Android当前的屏幕是横屏还是竖屏。横竖屏判断
        if (activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
            //竖屏
            orientation = TTAdConstant.VERTICAL;
        } else {
            //横屏
            orientation = TTAdConstant.HORIZONTAL;
        }

        this.setInterInitialized(true);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");

        if (mttFullVideoAd != null) {
            mttFullVideoAd.showFullScreenVideoAd(activity);
            mttFullVideoAd = null;
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Loading interstitial ad... fullVideo appId:" + appId + " interstitialPlacementId:" + interstitialPlacementId);

        //Orientation必填参数，期望视频的播放方向：TTAdConstant.HORIZONTAL 或 TTAdConstant.VERTICAL
        AdSlot adSlot = new AdSlot.Builder()
                .setCodeId(interstitialPlacementId)
                .setSupportDeepLink(true)
                .setImageAcceptedSize(1080, 1920)
                .setOrientation(orientation)
                .build();
        //调用插屏广告异步请求接口
        mTTAdNative.loadFullScreenVideoAd(adSlot, adLister);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return mttFullVideoAd != null;
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        rewardedVideoPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(rewardedVideoPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, rewardedVideoPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "rewardedVideoPlacementId is null", getAdvertCode());
            return;
        }

        YLog.d(TAG + "Initialize rewarded video ad successful, rewardedVideoPlacementId: " + rewardedVideoPlacementId);

        this.setVideoInitialized(true);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");

        if (mttRewardVideoAd != null && isCached) {
            mttRewardVideoAd.showRewardVideoAd(activity);
            mttRewardVideoAd = null;
        } else {
            YLog.d(TAG + "rewardVideoAd has not been cached");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }

        isCached = false;
        isLoading = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad... appId: " + appId + " rewardedVideoPlacementId:" + rewardedVideoPlacementId);

        if (mttRewardVideoAd == null && !isLoading) {
            AdSlot adSlot = new AdSlot.Builder()
                    .setCodeId(rewardedVideoPlacementId)
                    .setSupportDeepLink(true)
                    .setImageAcceptedSize(1080, 1920)
                    .build();

            mTTAdNative.loadRewardVideoAd(adSlot, rewardAdLister);
            isLoading = true;
        } else {
            YLog.d(TAG + "The ad is loading...");
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return mttRewardVideoAd != null && isCached;
    }

    @Override
    public String getSDKVesion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }

    @Override
    public String getSdkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }
}
