package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.mintegral.msdk.MIntegralConstans;
import com.mintegral.msdk.MIntegralSDK;
import com.mintegral.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mintegral.msdk.interstitialvideo.out.MTGInterstitialVideoHandler;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Map;


/**
 * @author yodo1
 */
public class AdvertAdaptermintegral_gp extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptermintegral_gp] ";
    private static final String CHANNEL_CODE = "mintegral_gp";

    private static final String KEY_APP_ID = "ad_mintegral_gp_appid";
    private static final String KEY_APP_KEY = "ad_mintegral_gp_appkey";

    private static final String KEY_UNIT_ID_REWARDED_VIDEO = "ad_mintegral_gp_rewardUnitId";
    private static final String KEY_PLACEMENT_ID_REWARDED_VIDEO = "ad_mintegral_gp_rewardPlacementId";

    private static final String KEY_UNIT_ID_INTERSTITIAL = "ad_mintegral_gp_interstitialUnitId";
    private static final String KEY_PLACEMENT_ID_INTERSTITIAL = "ad_mintegral_gp_interstitialPlacementId";

    private MTGRewardVideoHandler rewardVideoHandler;
    private MTGInterstitialVideoHandler interstitialVideoHandler;

    final private InterstitialVideoListener interstitialVideoListener = new InterstitialVideoListener() {

        @Override
        public void onLoadSuccess(String placementId, String unitId) {
//            YLog.d(TAG + "InterstitialVideo onLoadSuccess");
        }

        @Override
        public void onVideoLoadSuccess(String placementId, String unitId) {
            YLog.d(TAG + "InterstitialVideo onVideoLoadSuccess, " + "placementId: " + placementId + ", unitId" + unitId);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onVideoLoadFail(String errorMsg) {
            YLog.d(TAG + "InterstitialVideo onInterstitialVideoLoadFail, message: " + errorMsg);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onShowFail(String errorMsg) {
            YLog.d(TAG + "InterstitialVideo onShowFail, message: " + errorMsg);
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onAdShow() {
            YLog.d(TAG + "InterstitialVideo onAdShow");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(boolean isCompleteView) {
            YLog.d(TAG + "InterstitialVideo onAdClose, isCompleteView: " + isCompleteView);
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdClicked(String placementId, String unitId) {
            YLog.d(TAG + "InterstitialVideo onVideoAdClicked, " + "placementId: " + placementId + ", unitId" + unitId);
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onVideoComplete(String placementId, String unitId) {
            YLog.d(TAG + "InterstitialVideo onVideoComplete, " + "placementId: " + placementId + ", unitId" + unitId);
        }

        @Override
        public void onAdCloseWithIVReward(boolean isComplete, int rewardAlertStatus) {
            YLog.d(TAG + "InterstitialVideo onAdCloseWithIVReward");
        }

        @Override
        public void onEndcardShow(String placementId, String unitId) {
            YLog.d(TAG + "InterstitialVideo onEndcardShow, " + "placementId: " + placementId + ", unitId" + unitId);
        }

    };

    final private RewardVideoListener rewardVideoListener = new RewardVideoListener() {

        @Override
        public void onVideoLoadSuccess(String placementId, String unitId) {
            YLog.d(TAG + "RewardVideo onVideoLoadSuccess, " + "placementId: " + placementId + ", unitId" + unitId);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onLoadSuccess(String placementId, String unitId) {
//            YLog.d(TAG + "RewardVideo onLoadSuccess");
        }

        @Override
        public void onVideoLoadFail(String errorMsg) {
            YLog.d(TAG + "RewardVideo onVideoLoadFail, message: " + errorMsg);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onShowFail(String errorMsg) {
            YLog.d(TAG + "RewardVideo onShowFail, message: " + errorMsg);
            if (getVideoCallback() != null) {
                getVideoCallback().onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onAdShow() {
            YLog.d(TAG + "RewardVideo onAdShow");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(boolean isCompleteView, String rewardName, float rewardAmount) {
            YLog.d(TAG + "RewardVideo onAdClose, isCompleteView:" + isCompleteView + ", rewardName: " + rewardName + ", rewardAmount: " + rewardAmount);

            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdClicked(String placementId, String unitId) {
            YLog.d(TAG + "RewardVideo onVideoAdClicked, " + "placementId: " + placementId + ", unitId" + unitId);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onVideoComplete(String placementId, String unitId) {
            YLog.d(TAG + "RewardVideo onVideoComplete, " + "placementId: " + placementId + ", unitId" + unitId);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onEndcardShow(String placementId, String unitId) {
            YLog.d(TAG + "RewardVideo onEndcardShow, " + "placementId: " + placementId + ", unitId" + unitId);
        }

    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return "14.2.21";
    }

    @Override
    public String getSdkVersion() {
        return "14.2.21";
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_ID);
        String appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_KEY);

        if (TextUtils.isEmpty(appId) && TextUtils.isEmpty(appKey)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_ID);
            appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_KEY);
        }

        if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(appKey)) {
            YLog.d(TAG + "Initialize sdk failure, AppID or AppKey is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

//        MIntegralConstans.DEBUG = true;
        MIntegralSDK sdk = MIntegralSDKFactory.getMIntegralSDK();
        // test appId and appKey

        this.updatePrivacyConsent(activity);

        Map<String, String> map = sdk.getMTGConfigurationMap(appId, appKey);

        // if you modify applicationId, please add the following attributes,
        // otherwise it will crash
        // map.put(MobVistaConstans.PACKAGE_NAME_MANIFEST, "your AndroidManifest
        // package value");
        sdk.init(map, activity.getApplication());

        this.setInitialized(true);
        YLog.d(TAG + "Initialize sdk successful, " + "AppID: " + appId + ", AppKey: " + appKey);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isInterInitialized()) {
            return;
        }

        String interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNIT_ID_INTERSTITIAL);
        String interPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interUnitId is null", getAdvertCode());
            return;
        }
        if (TextUtils.isEmpty(interPlacementId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interPlacementId is null", getAdvertCode());
            return;
        }

        interstitialVideoHandler = new MTGInterstitialVideoHandler(activity, interPlacementId, interUnitId);
        interstitialVideoHandler.setInterstitialVideoListener(interstitialVideoListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, " + "interPlacementId: " + interPlacementId + " interUnitId: " + interUnitId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");
        if (interstitialAdvertIsLoaded(activity)) {
            interstitialVideoHandler.show();
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        YLog.d(TAG + "Loading interstitial ad...");
        this.setReloadInterCallback(callback);

        this.updatePrivacyConsent(activity);

        if (!interstitialAdvertIsLoaded(activity)) {
            interstitialVideoHandler.load();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialVideoHandler != null && interstitialVideoHandler.isReady();
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isVideoInitialized()) {
            return;
        }

        String videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNIT_ID_REWARDED_VIDEO);
        String videoPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoUnitId is null", getAdvertCode());
            return;
        }
        if (TextUtils.isEmpty(videoPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoPlacementId is null", getAdvertCode());
            return;
        }

        rewardVideoHandler = new MTGRewardVideoHandler(activity, videoPlacementId, videoUnitId);
        rewardVideoHandler.setRewardVideoListener(rewardVideoListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, " + "videoPlacementId: " + videoPlacementId + " videoUnitId: " + videoUnitId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");
        if (videoAdvertIsLoaded(activity)) {
            rewardVideoHandler.show("1");
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");
        this.updatePrivacyConsent(activity);
        if (!videoAdvertIsLoaded(activity)) {
            rewardVideoHandler.load();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardVideoHandler != null && rewardVideoHandler.isReady();
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        super.setPrivacy(privacy, context);
    }

    private void updatePrivacyConsent(Activity activity) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            MIntegralSDK mIntegralSdk = MIntegralSDKFactory.getMIntegralSDK();
            // Communicated over email, GDPR status can only be set before SDK initialization
            final int consent = privacy.isHasUserConsent() ? MIntegralConstans.IS_SWITCH_ON : MIntegralConstans.IS_SWITCH_OFF;
            mIntegralSdk.setUserPrivateInfoType(activity, MIntegralConstans.AUTHORITY_ALL_INFO, consent);
            mIntegralSdk.setConsentStatus(activity, consent);
            if (privacy.isHasUserConsent()) {
                YLog.d(TAG + "(GDPR) The user has consented");
            } else {
                YLog.d(TAG + "(GDPR) The user has not consented");
            }
            // Has to be _before_ their SDK init as well
            if (privacy.isDoNotSell()) {
                mIntegralSdk.setDoNotTrackStatus(privacy.isDoNotSell());
                YLog.d(TAG + "(CCPA) The user has opted out of the sale of their personal information");
            } else {
                YLog.d(TAG + "(CCPA) The user has not opted out of the sale of their personal information");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
