package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author sunmeng
 */
public class AdvertAdapterapplovinmax extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterapplovinmax] ";
    private static final String CHANNEL_CODE_MAX = "ApplovinMax";

    private static final String KEY_UNIT_ID_INTERSTITIAL = "ad_applovin_interstitial_id";
    private static final String KEY_UNIT_ID_REWARDED_VIDEO = "ad_applovin_video_id";
    private static final String KEY_UNIT_ID_BANNER = "ad_applovin_banner_id";

    private MaxInterstitialAd interstitialAd;
    private MaxRewardedAd rewardedAd;
    private MaxAdView bannerAdView;

    private AppLovinSdkConfiguration.ConsentDialogState consentDialogState;

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;

    final private MaxAdListener interstitialAdListener = new MaxAdListener() {
        @Override
        public void onAdLoaded(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdLoaded, " + getMaxAdString(maxAd));
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d(TAG + "InterstitialAd onAdLoadFailed, s: " + s + ", i: " + i);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            // Interstitial ad failed to load. We recommend re-trying in 3 seconds.
            final Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (interstitialAd != null) {
                        interstitialAd.loadAd();
                    }
                }
            }, 3000);
        }

        @Override
        public void onAdDisplayed(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdDisplayed, " + getMaxAdString(maxAd));
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdHidden(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdHidden, " + getMaxAdString(maxAd));
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (interstitialAd != null) {
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdClicked, " + getMaxAdString(maxAd));
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(@NonNull MaxAd maxAd, int i) {
            YLog.d(TAG + "InterstitialAd onAdDisplayFailed, i: " + i + getMaxAdString(maxAd));
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "", getAdvertCode());
            }
            if (interstitialAd != null) {
                interstitialAd.loadAd();
            }
        }
    };

    final private MaxRewardedAdListener videoAdListener = new MaxRewardedAdListener() {
        @Override
        public void onAdLoaded(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdLoaded, " + getMaxAdString(maxAd));
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d(TAG + "RewardedAd onAdLoadFailed, s: " + s + ", i: " + i);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            // Rewarded ad failed to load. We recommend re-trying in 3 seconds.
            final Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (rewardedAd != null) {
                        rewardedAd.loadAd();
                    }
                }
            }, 3000);
        }

        @Override
        public void onAdDisplayed(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdDisplayed, " + getMaxAdString(maxAd));
        }

        @Override
        public void onAdHidden(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdHidden, " + getMaxAdString(maxAd));
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdClicked, " + getMaxAdString(maxAd));
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(@NonNull MaxAd maxAd, int i) {
            YLog.d(TAG + "RewardedAd onAdDisplayFailed, i: " + i + ", " + getMaxAdString(maxAd));
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "", getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onRewardedVideoStarted(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onRewardedVideoStarted, " + getMaxAdString(maxAd));
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted(@NonNull MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onRewardedVideoCompleted, " + getMaxAdString(maxAd));
        }

        @Override
        public void onUserRewarded(@NonNull MaxAd maxAd, MaxReward maxReward) {
            // Rewarded ad was displayed and user should receive the reward
            YLog.d(TAG + "RewardedAd onUserRewarded, user should receive the reward, " + getMaxAdString(maxAd));
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    final private MaxAdViewAdListener bannerAdListener = new MaxAdViewAdListener() {

        @Override
        public void onAdLoaded(@NonNull MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdLoaded, " + getMaxAdString(ad));
            setBannerLoaded(true);
        }

        @Override
        public void onAdLoadFailed(String adUnitId, int errorCode) {
            YLog.d(TAG + "BannerAd onAdLoadFailed, adUnitId: " + adUnitId + ", errorCode: " + errorCode);
            setBannerLoaded(false);
        }

        @Override
        public void onAdDisplayed(@NonNull MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdDisplayed, " + getMaxAdString(ad));

        }

        @Override
        public void onAdHidden(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdHidden, " + getMaxAdString(ad));
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdClicked, " + getMaxAdString(ad));
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(@NonNull MaxAd ad, int errorCode) {
            YLog.d(TAG + "BannerAd onAdDisplayFailed, errorCode: " + errorCode + ", " + getMaxAdString(ad));
            if (getBannerCallback() != null) {
                getBannerCallback().onAdError(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode + "", getAdvertCode());
            }
        }

        @Override
        public void onAdExpanded(@NonNull MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdExpanded, " + getMaxAdString(ad));

        }

        @Override
        public void onAdCollapsed(@NonNull MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdCollapsed, " + getMaxAdString(ad));

        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE_MAX;
    }

    @Override
    public String getSDKVesion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getSdkVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }


    @Override
    public void initSdk(final Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        //TODO? 中介测试组件，发布前需要删除
//        AppLovinSdk.getInstance(activity).showMediationDebugger();

        AppLovinSdk.initializeSdk(activity, new AppLovinSdk.SdkInitializationListener() {
            @Override
            public void onSdkInitialized(final AppLovinSdkConfiguration configuration) {
                YLog.d(TAG + "Initialize sdk successful, " + configuration.getConsentDialogState().name());
                consentDialogState = configuration.getConsentDialogState();
                updatePrivacyConsent(activity, consentDialogState);

                setInitialized(true);

                if (initializeCallback != null) {
                    initializeCallback.onInitializeSuccess(getAdvertCode());
                }
            }
        });
    }

    @Override
    public void initVideoAd(final Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isVideoInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, getAdvertCode(), KEY_UNIT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoUnitId is null", getAdvertCode());
            return;
        }

        if (rewardedAd == null) {
            rewardedAd = MaxRewardedAd.getInstance(videoUnitId, activity);
            rewardedAd.setListener(videoAdListener);
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, videoUnitId: " + videoUnitId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");

        if (videoAdvertIsLoaded(activity)) {
            rewardedAd.showAd();
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent(activity, consentDialogState);

        if (rewardedAd != null) {
            rewardedAd.loadAd();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedAd != null && rewardedAd.isReady();
    }

    @Override
    public void initInterstitialAd(final Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isInterInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, getAdvertCode(), KEY_UNIT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interUnitId is null", getAdvertCode());
            return;
        }

        if (interstitialAd == null) {
            interstitialAd = new MaxInterstitialAd(interUnitId, activity);
            interstitialAd.setListener(interstitialAdListener);
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interUnitId: " + interUnitId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadInterCallback(reloadCallback);
        YLog.d(TAG + "Loading interstitial ad...");

        this.updatePrivacyConsent(activity, consentDialogState);

        if (interstitialAd != null) {
            interstitialAd.loadAd();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");

        if (interstitialAdvertIsLoaded(activity)) {
            interstitialAd.showAd();
        }
    }

    @Override
    public void initBannerAd(final Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isBannerInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String bannerUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, getAdvertCode(), KEY_UNIT_ID_BANNER);
        if (TextUtils.isEmpty(bannerUnitId)) {
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "bannerUnitId is null", getAdvertCode());
            return;
        }

        if (bannerAdView == null) {
            bannerAdView = new MaxAdView(bannerUnitId, activity);
            bannerAdView.setListener(bannerAdListener);
            bannerAdView.loadAd();
        }

        this.setBannerInitialized(true);
        YLog.d(TAG + "Initialize banner ad successful, bannerUnitId: " + bannerUnitId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.setBannerCallback(callback);
        YLog.d(TAG + "Showing banner ad...");

        this.updatePrivacyConsent(activity, consentDialogState);

        if (hasLoadBanner()) {
            Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity, bannerAdView, align);
            bannerAdView.setVisibility(View.VISIBLE);
//            bannerAdView.startAutoRefresh();

            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public boolean hasLoadBanner() {
        return this.isBannerLoaded();
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d(TAG + "Hide banner ad...");
        if (bannerAdView != null) {
            bannerAdView.setVisibility(View.GONE);
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerAdView);
        }
    }

    @Override
    public void removeBanner(Activity activity) {
        hideBanner(activity);
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(TAG + "setBannerAlign, align:" + align);
    }

    private void updatePrivacyConsent(Activity activity, AppLovinSdkConfiguration.ConsentDialogState consentDialogState) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            if (consentDialogState == AppLovinSdkConfiguration.ConsentDialogState.APPLIES) {
                AppLovinPrivacySettings.setHasUserConsent(privacy.isHasUserConsent(), activity);
                if (privacy.isHasUserConsent()) {
                    YLog.d(TAG + "(GDPR) The user has consented");
                } else {
                    YLog.d(TAG + "(GDPR) The user has not consented");
                }
            }
            AppLovinPrivacySettings.setIsAgeRestrictedUser(privacy.isAgeRestrictedUser(), activity);
            if (privacy.isAgeRestrictedUser()) {
                YLog.d(TAG + "(COPPA) The user is known to be in an age-restricted category (i.e., under the age of 16)");
            } else {
                YLog.d(TAG + "(COPPA) The user is not known to be in an age-restricted category (i.e., under the age of 16)");
            }
            AppLovinPrivacySettings.setDoNotSell(privacy.isDoNotSell(), activity);
            if (privacy.isDoNotSell()) {
                YLog.d(TAG + "(CCPA) The user has opted out of the sale of their personal information");
            } else {
                YLog.d(TAG + "(CCPA) The user has not opted out of the sale of their personal information");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }

    private String getMaxAdString(MaxAd ad) {
        return "MaxAd{" + "\n" + ad.getFormat() + "\n" + "UnitId{" + ad.getAdUnitId() + "}\n" + "NetworkName{" + ad.getNetworkName() + "}\n" + "}";
    }
}
