package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;

import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinErrorCodes;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Map;

/**
 * @author sunmeng
 */
public class AdvertAdapterapplovin extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterapplovin] ";
    private static final String CHANNEL_CODE = "Applovin";

    private AppLovinAd currentAd;
    private AppLovinIncentivizedInterstitial incentivizedInterstitial;

    private AppLovinSdkConfiguration.ConsentDialogState consentDialogState;

    /**
     * Ad display Listener
     */
    final private AppLovinAdDisplayListener intersAdDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd ad) {
            YLog.d(TAG + "InterstitialAd adDisplayed");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void adHidden(AppLovinAd ad) {
            YLog.d(TAG + "InterstitialAd adHidden");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };

    final private AppLovinAdDisplayListener videoAdDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            YLog.d(TAG + "RewardedAd adDisplayed");
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            YLog.d(TAG + "RewardedAd adHidden");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };

    /**
     * Ad Click Listener
     */
    final private AppLovinAdClickListener intersAdClickListener = new AppLovinAdClickListener() {
        @Override
        public void adClicked(AppLovinAd ad) {
            YLog.d(TAG + "InterstitialAd adClicked");

            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    final private AppLovinAdClickListener videoAdClickListener = new AppLovinAdClickListener() {
        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            YLog.d(TAG + "RewardedAd adClicked");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    /**
     * Ad Load Listener
     */
    final private AppLovinAdLoadListener intersAdLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd ad) {
            YLog.d(TAG + "InterstitialAd adReceived");
            currentAd = ad;
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void failedToReceiveAd(int errorCode) {
            YLog.d(TAG + "InterstitialAd failedToReceiveAd, errorCode: " + errorCode);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }
    };

    final private AppLovinAdLoadListener videoAdLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            YLog.d(TAG + "RewardedAd adReceived");

            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_LOADED, getAdvertCode());
            }

            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void failedToReceiveAd(int errorCode) {
            YLog.d(TAG + "RewardedAd failedToReceiveAd, error code: " + errorCode);

            if (errorCode == AppLovinErrorCodes.NO_FILL) {
                // Indicates that no ads are currently eligible for your device & location.
                if (getReloadVideoCallback() != null) {
                    getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "NO_FILL", getAdvertCode());
                }
            } else {
                // Unable to reach AppLovin; the user's device is likely experiencing poor connectivity.
                if (getReloadVideoCallback() != null) {
                    getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
                }
            }
        }
    };

    /**
     * Ad Playback Listener
     */
    final private AppLovinAdVideoPlaybackListener videoPlaybackListener = new AppLovinAdVideoPlaybackListener() {
        @Override
        public void videoPlaybackBegan(AppLovinAd ad) {
            YLog.d(TAG + "RewardedAd videoPlaybackBegan");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd ad, double percentViewed, boolean fullyWatched) {
            YLog.d(TAG + "RewardedAd videoPlaybackEnded");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    final private AppLovinAdRewardListener rewardListener = new AppLovinAdRewardListener() {
        @Override
        public void userRewardVerified(AppLovinAd ad, Map<String, String> response) {

        }

        @Override
        public void userOverQuota(AppLovinAd ad, Map<String, String> response) {

        }

        @Override
        public void userRewardRejected(AppLovinAd ad, Map<String, String> response) {

        }

        @Override
        public void validationRequestFailed(AppLovinAd ad, int errorCode) {

        }

        @Override
        public void userDeclinedToViewAd(AppLovinAd ad) {

        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getSdkVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
        if (incentivizedInterstitial != null) {
            incentivizedInterstitial.dismiss();
        }
    }

    @Override
    public void initSdk(final Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        AppLovinSdk.initializeSdk(activity, new AppLovinSdk.SdkInitializationListener() {
            @Override
            public void onSdkInitialized(final AppLovinSdkConfiguration configuration) {
                YLog.d(TAG + "Initialize sdk successful, " + configuration.getConsentDialogState().name());
                consentDialogState = configuration.getConsentDialogState();

                updatePrivacyConsent(activity, configuration.getConsentDialogState());

                setInitialized(true);

                if (initializeCallback != null) {
                    initializeCallback.onInitializeSuccess(getAdvertCode());
                }
            }
        });
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        setVideoInitialized(true);
        if (initializeCallback != null) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
        }
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");

        if (videoAdvertIsLoaded(activity)) {
            incentivizedInterstitial.show(activity, rewardListener, videoPlaybackListener, videoAdDisplayListener, videoAdClickListener);
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent(activity, consentDialogState);
        if (incentivizedInterstitial == null) {
            incentivizedInterstitial = AppLovinIncentivizedInterstitial.create(activity);
        }

        incentivizedInterstitial.preload(videoAdLoadListener);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return incentivizedInterstitial != null && incentivizedInterstitial.isAdReadyToDisplay();
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        setInterInitialized(true);
        if (initializeCallback != null) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Loading interstitial ad...");
        this.updatePrivacyConsent(activity, consentDialogState);

        AppLovinSdk.getInstance(activity.getApplicationContext()).getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, intersAdLoadListener);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return currentAd != null;
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");

        if (currentAd != null) {
            final AppLovinSdk sdk = AppLovinSdk.getInstance(activity);

            final AppLovinInterstitialAdDialog interstitialAd = AppLovinInterstitialAd.create(sdk, activity);
            interstitialAd.setAdDisplayListener(intersAdDisplayListener);
            interstitialAd.setAdClickListener(intersAdClickListener);
            interstitialAd.showAndRender(currentAd);
        }
    }

    private void updatePrivacyConsent(Activity activity, AppLovinSdkConfiguration.ConsentDialogState consentDialogState) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            YLog.d(TAG + "GDPR: " + privacy.isHasUserConsent() + ", COPPA: " + privacy.isAgeRestrictedUser() + ", CCPA: " + privacy.isDoNotSell());

            if (consentDialogState == AppLovinSdkConfiguration.ConsentDialogState.APPLIES) {
                // Show user consent dialog
                AppLovinPrivacySettings.setHasUserConsent(privacy.isHasUserConsent(), activity);
                if (privacy.isHasUserConsent()) {
                    YLog.d(TAG + "(GDPR) The user has consented");
                } else {
                    YLog.d(TAG + "(GDPR) The user has not consented");
                }
            }
            AppLovinPrivacySettings.setIsAgeRestrictedUser(privacy.isAgeRestrictedUser(), activity);
            if (privacy.isAgeRestrictedUser()) {
                YLog.d(TAG + "(COPPA) The user is known to be in an age-restricted category (i.e., under the age of 16)");
            } else {
                YLog.d(TAG + "(COPPA) The user is not known to be in an age-restricted category (i.e., under the age of 16)");
            }
            AppLovinPrivacySettings.setDoNotSell(privacy.isDoNotSell(), activity);
            if (privacy.isDoNotSell()) {
                YLog.d(TAG + "(CCPA) The user has opted out of the sale of their personal information");
            } else {
                YLog.d(TAG + "(CCPA) The user has not opted out of the sale of their personal information");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
