package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;

import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.ads.mediationtestsuite.MediationTestSuite;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author sunmeng
 */
public class AdvertAdapteradmob extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapteradmob] ";
    private static final String CHANNEL_CODE = "AdMob";

    private static final String KEY_APP_ID_INTERSTITIAL = "ad_admob_interstitial_appId";
    private static final String KEY_UNIT_ID_INTERSTITIAL = "ad_admob_interstitial_id";

    private static final String KEY_APP_ID_REWARDED_VIDEO = "ad_admob_video_appId";
    private static final String KEY_UNIT_ID_REWARDED_VIDEO = "ad_admob_video_unitId";

    private static final String KEY_APP_ID_BANNER = "ad_admob_banner_appId";
    private static final String KEY_UNIT_ID_BANNER = "ad_admob_banner_unitId";

    private String videoUnitId;

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;

    private AdView mBannerAdView;
    private InterstitialAd mInterstitialAd;
    private RewardedVideoAd mRewardedVideoAd;

    final private AdListener adBannerListener = new AdListener() {
        @Override
        public void onAdLoaded() {
            setBannerLoaded(true);
            // Code to be executed when an ad finishes loading.
            YLog.d(TAG + "BannerAd onAdLoaded");
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            // Code to be executed when an ad request fails.
            setBannerLoaded(false);
            YLog.d(TAG + "BannerAd onAdFailedToLoad, errorCode: " + errorCode);
        }

        @Override
        public void onAdOpened() {
            // Code to be executed when an ad opens an overlay that
            // covers the screen.
            YLog.d(TAG + "BannerAd onAdOpened");
        }

        @Override
        public void onAdLeftApplication() {
            // Code to be executed when the user has left the app.
            YLog.d(TAG + "BannerAd onAdLeftApplication");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdClosed() {
            // Code to be executed when when the user is about to return
            // to the app after tapping on an ad.
            YLog.d(TAG + "BannerAd onAdClosed");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };

    final private RewardedVideoAdListener rewardedVideoAdListener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoAdLoaded() {
            YLog.d(TAG + "RewardedVideoAd onRewardedVideoAdLoaded");
            setVideoLoaded(true);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            YLog.d(TAG + "RewardedVideoAd onRewardedVideoAdOpened");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoStarted() {
            YLog.d(TAG + "RewardedVideoAd onRewardedVideoStarted");
        }

        @Override
        public void onRewardedVideoAdClosed() {
            YLog.d(TAG + "RewardedVideoAd onRewardedVideoAdClosed");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {
            YLog.d(TAG + "RewardedVideoAd onRewarded");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            YLog.d(TAG + "RewardedVideoAd onRewardedVideoAdLeftApplication");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int errorCode) {
            YLog.d(TAG + "RewardedVideoAd onRewardedVideoAdFailedToLoad, error code: " + errorCode);
            setVideoLoaded(false);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted() {
            YLog.d(TAG + "RewardedVideoAd onRewardedVideoCompleted");
        }
    };

    final private AdListener adInterstitialListener = new AdListener() {
        @Override
        public void onAdClosed() {
            YLog.d(TAG + "InterstitialAd onAdClosed");

            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        //            Called when an ad request failed. The error code is usually ERROR_CODE_INTERNAL_ERROR, ERROR_CODE_INVALID_REQUEST, ERROR_CODE_NETWORK_ERROR, or ERROR_CODE_NO_FILL.
        @Override
        public void onAdFailedToLoad(int errorCode) {
            YLog.d(TAG + "InterstitialAd onAdFailedToLoad, errorCode: " + errorCode);
            setInterLoaded(false);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }

        //           Called when an ad opens an overlay that covers the screen.
        @Override
        public void onAdOpened() {
            YLog.d(TAG + "InterstitialAd onAdOpened");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        //            Called when an ad leaves the application  eg： 去往浏览器
        @Override
        public void onAdLeftApplication() {
            YLog.d(TAG + "InterstitialAd onAdLeftApplication");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        //            Called when an ad is received.
        @Override
        public void onAdLoaded() {
            YLog.d(TAG + "InterstitialAd onAdLoaded");
            setInterLoaded(true);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return "19.2.0";
    }

    @Override
    public String getSdkVersion() {
        return "19.2.0";
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        if (mBannerAdView != null) {
            mBannerAdView.resume();
        }

        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.resume(activity);
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (mBannerAdView != null) {
            mBannerAdView.pause();
        }
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.pause(activity);
        }
    }

    @Override
    public void onDestroy(Activity activity) {
        if (mBannerAdView != null) {
            mBannerAdView.setAdListener(null);
            mBannerAdView.destroy();
            mBannerAdView = null;
        }

        if (mInterstitialAd != null) {
            mInterstitialAd.setAdListener(null);
            mInterstitialAd = null;
        }

        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.destroy(activity);
            mRewardedVideoAd = null;
        }
    }

    @Override
    public void initSdk(final Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        if (activity == null || initializeCallback == null) {
            return;
        }

        if (this.isInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_APP_ID_BANNER);
//        appId = "ca-app-pub-7188592076082444~5943610619";
//        appId = "ca-app-pub-9340590208017770~4136585439"; // yodo1-test-demo 中介聚合
//        appId = "ca-app-pub-7188592076082444~6397588552"; //金好，SDK QA-Android-GP
//        appId = "ca-app-pub-3940256099942544~3347511713"; // 官方demo
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_ID_REWARDED_VIDEO);
        }
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_ID_INTERSTITIAL);
        }

        if (TextUtils.isEmpty(appId)) {
            YLog.d(TAG + "Initialize sdk failure, appId is null.");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }


        final String finalAppId = appId;
        MobileAds.initialize(activity, new OnInitializationCompleteListener() {
            @Override
            public void onInitializationComplete(InitializationStatus initializationStatus) {
                Map<String, AdapterStatus> statusMap = initializationStatus.getAdapterStatusMap();
                for (String adapterClass : statusMap.keySet()) {
                    AdapterStatus status = statusMap.get(adapterClass);
                    YLog.d(TAG, String.format(
                            "Adapter name: %s, Description: %s, Latency: %d",
                            adapterClass, status.getDescription(), status.getLatency()));
                }

                AdvertAdapteradmob.this.setInitialized(true);
                YLog.d(TAG + "Initialize sdk successful, appId: " + finalAppId);
                initializeCallback.onInitializeSuccess(getAdvertCode());

//                setDeviceIDs(activity.getApplicationContext());
                //TODO? 中介测试组件，发版前需要移除，gradle 中的 mediation-test-suite 需要一并移除
//                MediationTestSuite.launch(activity);
            }
        });
        //google exception.Hunter,2020年04月16日18:27:29
//        try {
//            MobileAds.initialize(activity.getApplicationContext(), appId);
//            this.setInitialized(true);
//            YLog.d(TAG + "Initialize sdk successful, appId: " + appId);
//            initializeCallback.onInitializeSuccess(getAdvertCode());
//
//            setDeviceIDs(activity);
//            //TODO? 中介测试组件，发版前需要移除，gradle 中的 mediation-test-suite 需要一并移除
//            MediationTestSuite.launch(activity);
//        } catch (Exception e) {
//            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "exception happend:" + e.getMessage(), getAdvertCode());
//        }
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (!this.isInitialized() || activity == null || initializeCallback == null) {
            return;
        }

        if (this.isVideoInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNIT_ID_REWARDED_VIDEO);
//        videoUnitId = "ca-app-pub-9340590208017770/9122152959"; //yodo1-test-demo 中介聚合
//        videoUnitId = "ca-app-pub-7188592076082444/4409009020"; //QA
//        videoUnitId = "ca-app-pub-3940256099942544/5224354917"; // 官方 demo
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoUnitId is null", getAdvertCode());
            return;
        }

        // Use an activity context to get the rewarded video instance.
        mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance(activity);
        mRewardedVideoAd.setRewardedVideoAdListener(rewardedVideoAdListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, videoUnitId: " + videoUnitId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);

        YLog.d(TAG + "Showing rewarded video ad...");
        if (mRewardedVideoAd != null && mRewardedVideoAd.isLoaded()) {
            mRewardedVideoAd.show();
        }
        this.setVideoLoaded(false);
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.loadAd(videoUnitId, createAdRequest(activity, this.getPrivacy()));
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return this.isVideoLoaded();
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (!this.isInitialized() || activity == null || initializeCallback == null) {
            return;
        }

        if (this.isInterInitialized()) {
            return;
        }

        String interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNIT_ID_INTERSTITIAL + "1");
//        interUnitId = "ca-app-pub-9340590208017770/7436987456"; //yodo1-test-demo 中介聚合
//        interUnitId = "ca-app-pub-7188592076082444/8539825720"; //QA
//        interUnitId = "ca-app-pub-3940256099942544/8691691433"; //官方 demo
        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interUnitId is null", getAdvertCode());
            return;
        }

        mInterstitialAd = new InterstitialAd(activity);
        mInterstitialAd.setAdUnitId(interUnitId);
        mInterstitialAd.setAdListener(adInterstitialListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interUnitId: " + interUnitId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadInterCallback(reloadCallback);
        YLog.d(TAG + "Loading interstitial ad...");

        // Request a new ad if one isn't already loaded
        if (mInterstitialAd != null && !mInterstitialAd.isLoaded()) {
            mInterstitialAd.loadAd(createAdRequest(activity, getPrivacy()));
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return this.isInterLoaded();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        this.setInterLoaded(false);

        YLog.d(TAG + "Showing interstitial ad...");
        if (mInterstitialAd != null && mInterstitialAd.isLoaded()) {
            mInterstitialAd.show();
        }
    }

    @Override
    public void initBannerAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (!this.isInitialized() || activity == null || initializeCallback == null) {
            return;
        }

        if (this.isBannerInitialized()) {
            return;
        }

        String bannerUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_UNIT_ID_BANNER);
//        bannerUnitId = "ca-app-pub-9340590208017770/2939887986";  //yodo1-test-demo 中介聚合
//        bannerUnitId = "ca-app-pub-7188592076082444/1044479086"; // QA
//        bannerUnitId = "ca-app-pub-3940256099942544/6300978111"; // 官方 demo
        if (TextUtils.isEmpty(bannerUnitId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, bannerUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "bannerUnitId is null", getAdvertCode());
            return;
        }

        if (mBannerAdView == null) {
            mBannerAdView = new AdView(activity);
            mBannerAdView.setAdUnitId(bannerUnitId);
            // 自适应 banner
            AdSize adSize = getAdSize(activity);
            mBannerAdView.setAdSize(adSize);
//            mBannerAdView.setAdSize(BANNER);
            mBannerAdView.setAdListener(adBannerListener);
            mBannerAdView.loadAd(createAdRequest(activity, getPrivacy()));
        }

        this.setBannerInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, bannerUnitId: " + bannerUnitId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    private AdSize getAdSize(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);

        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;
        int adWidth = (int) (widthPixels / density);

        // Get adaptive ad size and return for setting on the ad view.
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(activity, adWidth);
    }

    /**
     * 显示banner广告
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    @Override
    public void showBanner(final Activity activity, Yodo1AdCallback callback) {
        this.setBannerCallback(callback);
        YLog.d(TAG + "Showing banner ad...");

        if (hasLoadBanner()) {
            YLog.d(TAG + "showBanner ");
            Yodo1BannerAlign.setYodo1BannerLayout(activity, mBannerAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    /**
     * banner广告删除
     *
     * @param activity Activity
     */
    @Override
    public void removeBanner(Activity activity) {
        setBannerLoaded(false);
        YLog.d(TAG + "Remove banner ad...");

        if (mBannerAdView != null) {
            mBannerAdView.destroy();
            mBannerAdView = null;
        }
    }

    /**
     * 隐藏
     *
     * @param activity Activity
     */
    @Override
    public void hideBanner(Activity activity) {
        YLog.d(TAG + "Hide banner ad...");
        if (mBannerAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, mBannerAdView);
        }
    }

    /**
     * 设置banner展示位置
     *
     * @param activity Activity
     * @param align    banner展示位置
     */
    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(TAG + "setBannerAlign, align:" + align);
    }

    @Override
    public boolean hasLoadBanner() {
        return this.isBannerLoaded();
    }

    private static AdRequest createAdRequest(final Activity activity, Yodo1Privacy privacy) {
        final AdRequest.Builder builder = new AdRequest.Builder();
        final Bundle adExtras = new Bundle();

        if (privacy != null) {
            //COPPA
            builder.tagForChildDirectedTreatment(privacy.isAgeRestrictedUser());
            if (privacy.isAgeRestrictedUser()) {
                YLog.d(TAG + "(COPPA) The user is known to be in an age-restricted category (i.e., under the age of 16)");
            } else {
                YLog.d(TAG + "(COPPA) The user is not known to be in an age-restricted category (i.e., under the age of 16)");
            }

            //GDPR
            if (!privacy.isHasUserConsent()) {
                adExtras.putString("npa", "1");

                YLog.d(TAG + "(GDPR) The user has not consented");
            } else {
                YLog.d(TAG + "(GDPR) The user has consented");
            }

            //CCPA
            if (privacy.isDoNotSell()) {
                // Restrict data processing - https://developers.google.com/admob/android/ccpa
                adExtras.putInt("rdp", 1);

                SharedPreferences sharedPref = activity.getPreferences(Context.MODE_PRIVATE);
                SharedPreferences.Editor editor = sharedPref.edit();
                editor.putInt("gad_rdp", 1);

                editor.apply();

                YLog.d(TAG + "(CCPA) The user has opted out of the sale of their personal information");
            } else {
                YLog.d(TAG + "(CCPA) The user has not opted out of the sale of their personal information");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
        builder.addNetworkExtrasBundle(AdMobAdapter.class, adExtras);

        return builder.build();
        //TODO? 仅作为测试使用，发布时移除
//        setDeviceIDs(activity);

//        AdRequest adRequest = builder.build();
//        boolean isTestDevice = adRequest.isTestDevice(activity);
//        YLog.d(TAG + " cur isTestDevice : " + isTestDevice);
//        return adRequest;
    }

    //TODO? 添加测试设备使用，相关调用在发版时需要移除
    private static void setDeviceIDs(Context context) {
        String d0 = "220D179890CA78A519C5811E6C27A9DD";// 华为TL00
        String d1 = "BCE4F16BC2536906C243F0066044E9EC";// 三星S9
        String d2 = "77F708E525228E1E45F2153EC4F87537";// 金好1
        String d3 = "47FD37145F27C7CC927E6AF2E146C069";//金好2
        //53e1a0e1-ed72-490a-9be2-f9f031866a22 三星S9(这种设备id 值不起作用，只有google 的官方日志才可以)
        List<String> testDeviceIds = Arrays.asList(d0, d1, d2, d3);
        RequestConfiguration configuration =
                new RequestConfiguration.Builder().setTestDeviceIds(testDeviceIds).build();
        MobileAds.setRequestConfiguration(configuration);
    }

}
