package com.yodo1.android.ops.net;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;

import com.yodo1.android.ops.constants.Yodo1ErrorCode;
import com.yodo1.nohttp.InitializationConfig;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.URLConnectionNetworkExecutor;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.nohttp.rest.RestResponse;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONObject;

/**
 * Created by yodo1 on 18/1/2.
 *
 * @author yodo1
 */
public class Yodo1HttpManage {

    private static final String TAG = "[Yodo1HttpManage] ";
    private static Yodo1HttpManage instance;
    private static Context mActivity;

    /**
     * 用来标记取消。
     */
    private Object mObject = new Object();

    /**
     * 请求队列。
     */
    private RequestQueue mQueue;
    private boolean isInitialized = false;

    public static Yodo1HttpManage getInstance() {
        if (instance == null) {
            instance = new Yodo1HttpManage();
        }
        return instance;
    }

    public void initHttp(Context activity) {
        if (isInitialized) {
            return;
        }
        mActivity = activity;
        Log.d("yodo1-games-sdk", TAG + "Yodo1HttpManage init..begin ." + System.currentTimeMillis());
        NoHttp.initialize(InitializationConfig.newBuilder(mActivity)
                // 设置全局连接超时时间，单位毫秒，默认10s。
                .connectionTimeout(30 * 1000)
                // 设置全局服务器响应超时时间，单位毫秒，默认10s。
                .readTimeout(30 * 1000)
                // 配置网络层，URLConnectionNetworkExecutor，如果想用OkHttp：OkHttpNetworkExecutor。
                .networkExecutor(new URLConnectionNetworkExecutor())
                .build()
        );
        mQueue = NoHttp.newRequestQueue(1);
        isInitialized = true;
        Log.d("yodo1-games-sdk", TAG + "Yodo1HttpManage init...end " + System.currentTimeMillis());
        // 初始化时间大约几十ms 初始化操作从Yodo1OlconifgProvr类中初始化 mQueue实例化时间总是优先于网络请求
    }

    /**
     * 发起请求。
     *
     * @param what      what.
     * @param request   请求对象。
     * @param callback  回调函数。
     * @param isLoading 实现显示加载框。
     * @param <T>       想请求到的数据类型。
     */
    public <T> void connect(final int what, final Request<T> request, final HttpListener<T> callback, final boolean isLoading) {
        // 初始化请求队列，传入的参数是请求并发值。
        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                if (!isInitialized || mActivity == null || mQueue == null) {
                    // 未初始化或者初始化了游戏关闭调用销毁导致mActivity为空或者mQueue队列为null 则拦截网络请求
                    callback.onFailed(0, new RestResponse<T>(null, true, null, null, 0L, null));
                    return;
                } else {
                    mQueue.add(what, request, new HttpResponseListener<>(mActivity, request, callback));
                }
            }
        });
    }

    public Yodo1SDKResponse getResponseObject(int requestType, Response<String> response) {
        boolean isSuccess = false;
        int errorCode = 0;
        String message = null, data = null;
        JSONObject jsonData = null;

        if (response == null || TextUtils.isEmpty(response.get())) {
            isSuccess = false;
            errorCode = Yodo1ErrorCode.ERRORCODE_DATAFORMAT_ERROR;
        } else {
            data = response.get();
            try {
                JSONObject obj = new JSONObject(data);
                if (obj.optInt("error_code") != 0) {
                    isSuccess = false;
                    errorCode = obj.getInt("error_code");
                    message = obj.optString("error_msg");
                } else {
                    //success
                    isSuccess = true;
                    jsonData = obj;
                }
            } catch (Exception e) {
                YLog.d(TAG + "getResponseObject data:" + data);
                isSuccess = false;
                errorCode = Yodo1ErrorCode.ERRORCODE_DATAFORMAT_ERROR;
            }
        }
        Yodo1SDKResponse responseObject = new Yodo1SDKResponse(requestType, isSuccess, errorCode);
        responseObject.setRawData(data);
        responseObject.setMessage(message);
        if (isSuccess) {
            responseObject.setResponse(jsonData);
        }
        return responseObject;
    }

    public void onDestroy() {
        mActivity = null;
        if (mQueue != null) {
            // 和声明周期绑定，退出时取消这个队列中的所有请求，当然可以在你想取消的时候取消也可以，不一定和声明周期绑定。
            mQueue.cancelBySign(mObject);
            // 因为回调函数持有了activity，所以退出activity时请停止队列。
            mQueue.stop();
            mQueue = null;
        }
        isInitialized = false;
    }

}
