package com.yodo1.advert.factory;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;
import com.yodo1.sensor.Yodo1Sensor;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

/**
 * @author yodo1
 */
public class Yodo1AdvertActivityObserver implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "[Yodo1AdvertActivityObserver] ";

    String mainClassName = "";

    private boolean isMainActivity(Activity activity) {
        if (activity == null) {
            return false;
        }

        if (TextUtils.isEmpty(mainClassName)) {
            mainClassName = Yodo1SharedPreferences.getString(activity, "YODO1_MAIN_CLASS");
        }

        return activity.getClass().getName().equals(mainClassName);
    }


    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        updateTrack(activity);

        YLog.d(TAG + "onActivityCreated  " + activity.getClass().getSimpleName());
        if (!isMainActivity(activity)) {
            return;
        }
        YLog.d(TAG + "onActivityCreated");

        Yodo1HttpManage.getInstance().initHttp(activity);
        boolean splashAdSwitch = YOnlineConfigUtils.isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
        YLog.d(TAG + "onActivityCreated, SplashAd switch = " + splashAdSwitch);
        if (splashAdSwitch) {
            Intent intent = new Intent(activity, Yodo1SplashAdActivity.class);
            activity.startActivity(intent);
        }

        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() != null) {
                adapter.getValue().onCreate(activity);
            }
        }
    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {
        YLog.d(TAG + "onActivityResumed  " + activity.getClass().getSimpleName());
        if (!isMainActivity(activity)) {
            return;
        }
        YLog.d(TAG + "onActivityResumed");
        Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener() {
            @Override
            public void getDataFinish(int code, String onlineConfig) {
                track(code);
            }
        });
        if (Yodo1OnlineConfig.getInstance().hasData()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onResume(activity);
                }
            }
            Yodo1Analytics.onResume(activity);
        }
    }

    /**
     *  记录onlineConfig事件
     *
     * @param code onlineConfig接口的返回结果
     */
    private void track(int code){
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("errorCode",code);
            if(code==0 || code == 10){
                jsonObject.put("result","success");
            }else{
                jsonObject.put("result","fail");
            }
            Yodo1Sensor.track("onlineParameter",jsonObject);
        } catch (JSONException e) {
//                    e.printStackTrace();
            YLog.d(TAG + "getOnlineConfig upload sensor : " + e.getMessage());
        }
    }

    @Override
    public void onActivityPaused(Activity activity) {
        YLog.d(TAG + "onActivityPaused  " + activity.getClass().getSimpleName());
        if (!isMainActivity(activity)) {
            return;
        }
        YLog.d(TAG + "onActivityPaused");
        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() != null) {
                adapter.getValue().onPause(activity);
            }
        }
        Yodo1Analytics.onPause(activity);
    }

    //Biz libs,Hunter,zjq
    private void updateTrack(Activity activity) {
        StringBuilder sb = new StringBuilder("{");
        Map<String, AdapterAdvertBase> adapters = Yodo1AdvertAdapterFactory.getInstance().getAdapters();
        for (Map.Entry<String, AdapterAdvertBase> entry : adapters.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\"").append(":");
            sb.append("\"").append(entry.getValue().getSDKVesion()).append("\"");
            sb.append(",");
        }
        sb.append("}");
    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        YLog.d(TAG + "onActivityDestroyed  " + activity.getClass().getSimpleName());
        if (!isMainActivity(activity)) {
            return;
        }
        YLog.d(TAG + "onActivityDestroyed");

        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() != null) {
                adapter.getValue().onDestroy(activity);
            }
        }

        Yodo1Analytics.onDestroy(activity);
        Yodo1HttpManage.getInstance().onDestroy();
        Yodo1OnlineConfig.getInstance().onDestroy();
    }
}