package com.yodo1.advert.entity;

/**
 * @author sunmeng
 */
public enum AdErrorCode {
    /**
     * 广告加载失败
     */
    ADVERT_ERROR_LOADED_FAILED(0),
    /**
     * 不支持该广告形式
     */
    ADVERT_ERROR_NO_SUPPORT(1),
    /**
     * 广告播放开关关闭
     */
    ADVERT_ERROR_SWITCHCLOSE(2),
    /**
     * 广告播放列表为空
     */
    ADVERT_ERROR_NO_ADLIST(3),
    /**
     * 广告播放过于频繁，未达到要求的时间间隔
     */
    ADVERT_ERROR_MISS_INTERVAL(4),
    /**
     * 网络异常
     */
    ADVERT_ERROR_NETWORK(5),
    /**
     * 未知情况
     */
    ADVERT_ERROR_UNKNOW(6);

    private int code;

    /**
     * 构造函数，枚举类型只能为私有
     *
     * @param code 枚举Code
     */
    AdErrorCode(int code) {
        this.code = code;
    }


    public int getErrorCode() {
        return code;
    }


}
