package com.yodo1.sensor;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.sensorsdata.analytics.android.minisdk.Yodo1SensorsDataAPI;
import com.sensorsdata.analytics.android.minisdk.util.JSONUtils;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1PropertiesUtils;

import org.json.JSONObject;



/**
 * @author :huangguofeng
 * date    :2020-03-24
 * package :com.yodo1.sensor
 * desc    : 神策埋点中转类
 */
public class Yodo1SensorHelper {
    private  static Yodo1SensorHelper instance;
    private  static final String TAG = "[Yodo1SensorHelper] ";
    /**
     *  初始化状态
     */
    private static boolean isInit=false;
    /**
     *  debug模式，只是用于开启和关闭神策的日志
     */
    private boolean debug=false;
    /**
     *  数据上传地址debug url，仅限开启debug时生效
     */
    private String url=null;
    /**
     *  数据上传地址 正式url。默认数据接收地址
     */
    private String releaseUrl="https://youdaoyi.datasink.sensorsdata.cn/sa?project=production&token=7d89c1c8b84d30c8";

    public  static Yodo1SensorHelper getInstance() {
        if (instance == null) {
            instance = new Yodo1SensorHelper();
        }
        return instance;
    }

    private Yodo1SensorHelper(){

    }


    public  void init(Context context) {
        if(isInit){
            Log.d(TAG , "sensor 禁止多次初始化 ");
            return;
        }
        isInit=true;
        Log.d(TAG ,   "The sensor init is called...");
        debug=getDebugState(context);
        url=getDataUrl(context);

        if(debug){
            /**
             *  debug模式，开启日志,配置了测试的url就用测试的，没有配置就用正式的
             */
            if(TextUtils.isEmpty(url)){
                Log.d(TAG , " 神策功能debug状态 ：true    数据接收地址1 = "+releaseUrl);
                Yodo1SensorsDataAPI.sharedInstance(context,releaseUrl,Yodo1SensorsDataAPI.DebugMode.DEBUG_AND_TRACK);
            }else{
                Log.d(TAG , " 神策功能debug状态 ：true    数据接收地址2 ： "+url);
                Yodo1SensorsDataAPI.sharedInstance(context,url,Yodo1SensorsDataAPI.DebugMode.DEBUG_AND_TRACK);
            }
        }else{
            /**
             *  正式环境 初始化releaseUrl 关闭神策日志的debug，注册静态属性
             */
            Log.d(TAG , " 神策功能debug状态 ：false    数据接收地址 ： "+releaseUrl);
            Yodo1SensorsDataAPI.sharedInstance(context,releaseUrl,Yodo1SensorsDataAPI.DebugMode.DEBUG_OFF);
        }
        registerSuperProperties(context);
    }

    /**
     * 获取debug环境
     *
     * @param context 上下文
     */
    private boolean getDebugState(Context context) {
        YLog.d(TAG + "The getDebugState method is called...");
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager()
                    .getApplicationInfo(SysUtils.getPackageName(context), PackageManager.GET_META_DATA);
            Bundle configBundle = appInfo.metaData;
            if(configBundle==null){
                YLog.d(TAG + "The metaData is null，sensor turn off debug ");
                return false;
            }
            /**
             *  获取debug状态的开关
             */
            return configBundle.getBoolean("Y_SDK_SENSORS_DEBUG_SWITCH", false);
        } catch (PackageManager.NameNotFoundException e) {
            YLog.d(TAG + "getDebugState NameNotFoundException  e ： "+e.getMessage());
        }
        return false;

    }

    /**
     * 获取数据上传url
     *
     * @param context 上下文
     */
    private String getDataUrl(Context context) {
        YLog.d(TAG + "The getDataUrl method is called...");
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager()
                    .getApplicationInfo(SysUtils.getPackageName(context), PackageManager.GET_META_DATA);
            Bundle configBundle = appInfo.metaData;
            if(configBundle==null){
                YLog.d(TAG + "The metaData is null，miss sensor url ");
                return "";
            }
            /**
             *  如果是debug状态，获取debug url
             */
            if(debug){
                return configBundle.getString("Y_SDK_SENSORS_DEBUG_URL", "");
            }

        } catch (PackageManager.NameNotFoundException e) {
            YLog.d(TAG + "getDataUrl NameNotFoundException  e ： "+e.getMessage());
        }
        return "";

    }

    /**
     *  备用方法
     */
    public  void onDestroy() {
        YLog.d(TAG + "The onDestroy of  method is called...");
    }

    /**
     *  1:请在初始化 SDK 后立即调用 registerSuperProperties() 方法，确保每个事件都会添加已设置的公共属性。
     *  2:神策事件属性大小写敏感（详见官网文档:数据格式），设置公共属性前需确保事件表中不存在仅大小写不同的同名属性，否则会导致所有事件因存在同名属性而不能入库。
     *  3:重复调用registerSuperProperties()会覆盖之前已设置的公共属性，公共属性会保存在App本地SharedPreferences中
     *  4:可以通过 unregisterSuperProperty() 删除一个静态公共属性，使用clearSuperProperties()会删除所有已设置的事件公共属性。
     */
    public  void registerSuperProperties(Context context){
        if(!isInit){
            YLog.d(TAG + "sensor 没有初始化 无法registerSuperProperties ");
            return;
        }
        Log.d(TAG , " registerSuperProperties  is call ");
        try {
            JSONObject properties = new JSONObject();
            properties.put("gameName", SysUtils.getAppName(context));
            properties.put("gameVersion", SysUtils.getVersionName(context));
            properties.put("gameBundleId", SysUtils.getPackageName(context));
            properties.put("sdkType",Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKType"));
            properties.put("sdkVersion", Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKVersion"));
            if(!TextUtils.isEmpty(Yodo1CommonUtils.getMetedataStr(context, "Yodo1ChannelCode"))){
                properties.put("publishChannelCode", Yodo1CommonUtils.getMetedataStr(context, "Yodo1ChannelCode"));
            }else{
                properties.put("publishChannelCode", ""+Yodo1PropertiesUtils.getInstance().getBasicConfigValue("CHANNEL_CODE_PUBLISH"));
            }
            Log.i(TAG , " registerSuperProperties content :\n" + JSONUtils.formatJson(properties.toString()));
            Yodo1SensorsDataAPI.sharedInstance().registerSuperProperties(properties);
        } catch (Exception e) {
            YLog.d(TAG +" registerSuperProperties  Exception e : "+e.getMessage());
        }
    }


    /**
     * 1:当事件公共属性和事件属性的 Key 冲突时，事件属性优先级最高，它会覆盖事件公共属性。
     * 2:事件属性是一个 JSONObject 对象
     * 3:JSONObject 中每个元素描述一个属性，Key 为属性名称，必需是 String 类型
     * 4:JSONObject 中，每个元素的Value是属性的值，支持String、Number、Boolean、JSONArray 和 Date，对于JSONArray，其中所有元素必须是String类型
     *
     * @param eventId 埋点事件名
     * @param properties 埋点事件附加属性
     */
    public  void track(String eventId, JSONObject properties){
        if(!isInit){
            YLog.d(TAG + "sensor 没有初始化 无法track eventId ： "+eventId);
            return;
        }
        try {
            if(!TextUtils.isEmpty(eventId) && properties!=null){
                Yodo1SensorsDataAPI.sharedInstance().track(eventId,properties);
            }else{
                YLog.d(TAG +" eventId is null or properties is null ");
            }
        } catch (Exception e) {
            YLog.d(TAG +" track  Exception e : "+e.getMessage());
        }
    }

    /**
     *  记录激活事件
     *  1：多次调用此方法只会触发一次激活事件（触发激活事件时会自动保存 $first_visit_time 首次访问时间属性到用户表）
     *  2：触发激活事件时会尝试获取 IMEI 号，请动态申请 android.permission.READ_PHONE_STATE 权限后再调用 trackInstallation
     *  3：申请权限结果回调时（无论申请权限成功失败），都要调用 trackInstallation() 触发激活事件
     */
    public  void trackInstallation(String eventId, JSONObject properties){
        if(!isInit){
            YLog.d(TAG + "sensor 没有初始化 无法trackInstallation eventId ： "+eventId);
            return;
        }
        try {
            if(!TextUtils.isEmpty(eventId) && properties!=null){
                Yodo1SensorsDataAPI.sharedInstance().track(eventId,properties);
            }else{
                YLog.d(TAG +" eventId is null or properties is null ");
            }
        } catch (Exception e) {
            YLog.d(TAG +" track  Exception e : "+e.getMessage());
        }
    }


    /**
     *  记录用户属性
     *
     * @param properties 用户属性
     */
    public  void profileSet(JSONObject properties){
        if(!isInit){
            YLog.d(TAG + "profileSet fail : sensor 没有初始化 无法记录用户属性");
            return;
        }
        try {
            if(properties!=null){
                Yodo1SensorsDataAPI.sharedInstance().profileSet(properties);
            }else{
                YLog.d(TAG +"profileSet fail : properties is null  ");
            }
        } catch (Exception e) {
            YLog.d(TAG +" profileSet  Exception e : "+e.getMessage());
        }
    }

}
