package com.yodo1.sdk.kit;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;

import com.yodo1.sdk.base.android.Yodo1BaseUtils;

/**
 * 权限检查及动态权限申请
 *
 * @author zhuxc
 */
public class Yodo1PermissonUtils {
    public static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    private static String[] permissions = {Manifest.permission.READ_PHONE_STATE, Manifest.permission.WRITE_EXTERNAL_STORAGE};

    private static int requestCode = 10086;

    /**
     * 判断应用是否有某个权限
     *
     * @param ctx        Context
     * @param permission permission
     * @return 是否含有此权限
     */
    public static boolean hasPermission(Context ctx, String permission) {

        PackageManager pm = ctx.getPackageManager();
        boolean bl = (PackageManager.PERMISSION_GRANTED == pm.checkPermission(permission, SysUtils.getPackageName(ctx)));

        return bl;
    }


    /**
     * 检查并申请某个动态权限
     *
     * @param activity Activity
     */
    public static void requestPermisson(Activity activity) {

        if (Build.VERSION.SDK_INT >= 23) {
            //6.0以上系统
            boolean result = hasPermission(activity, permissions);
            //判断是否已经拥有某项权限
            if (!result) {
                Yodo1BaseUtils.requestPermission(activity,permissions,requestCode);
//                ActivityCompat.requestPermissions(activity, permissions, requestCode);
            }
        }
    }

    /**
     * 权限检查
     *
     * @param cxt         Context
     * @param permissions 权限数组
     * @return 1
     */
    public static boolean hasPermission(Context cxt, String[] permissions) {
        for (String permission : permissions) {
            if (!Yodo1BaseUtils.checkSelfPermission(cxt, permission)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 权限程序是否在manifest文件中声明了某权限
     *
     * @param cxt         Context
     * @param permissions String[]
     * @return 是否在manifest文件中声明了某权限
     */
    public static boolean hasPermissionForManifest(Context cxt, String[] permissions) {
        for (String permission : permissions) {
            if ((PackageManager.PERMISSION_GRANTED != cxt.getPackageManager()
                    .checkPermission(permission, cxt.getPackageName()))) {
                return false;
            }
        }
        return true;
    }

    // 请求权限
    public static void requestPermission(Activity activity,String[] permission,int code){
        Yodo1BaseUtils.requestPermission(activity,permission,code);
    }

    // 检查权限
    public static boolean checkSelfPermission(Context context,String permission){
        if(Yodo1BaseUtils.checkSelfPermission(context,permission)){
            return true;
        }
        return false;
    }

    //shouldShowRequestPermissionRationale是Google提供的是否要显示提示界面的方法。
    //如果用户曾经拒绝过权限，或者在设置界面里关掉过权限，那么会返回true
    //如果用户从来没有拒绝过权限，或者点了'不再提示'并拒绝，又或者系统本身不允许这种权限的出现。则会返回false
    public static boolean shouldShowRequestPermissionRationale(Activity activity,String permission){
        return  Yodo1BaseUtils.shouldShowRequestPermissionRationale(activity,permission);
    }
}
