package com.yodo1.sdk.kit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * Created by yodo1 on 2016/5/25.
 */
public class Yodo1OperatorUtils {

    public static final int CHANNEL_ID_default = 0;
    public static final int CHANNEL_ID_cmcc = 1 << 0;
    public static final int CHANNEL_ID_telecom = 1 << 1;
    public static final int CHANNEL_ID_unicom = 1 << 2;
    private static final String TAG = "Yodo1OperatorUtils";
    /**
     * TelephonyManager提供设备上获取通讯服务信息的入口。 应用程序可以使用这个类方法确定的电信服务商和国家 以及某些类型的用户访问信息。
     * 应用程序也可以注册一个监听器到电话收状态的变化。不需要直接实例化这个类
     * 使用Context.getSystemService(Context.TELEPHONY_SERVICE)来获取这个类的实例。
     */
    private static TelephonyManager telephonyManager;
    /**
     * 国际移动用户识别码
     */
    private static String IMSI = "";

    /**
     * Role:Telecom service providers获取手机服务商信息
     * 需要加入权限 android.permission.READ_PHONE_STATE
     *
     * @param context Context
     * @return imsi
     */
    @SuppressLint("MissingPermission")
    public static String getProvidersName(Context context) {
        String nop = null;
        telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        // 返回唯一的用户ID;就是这张卡的编号神马的
        if (telephonyManager != null && Yodo1PermissonUtils.hasPermission(context, android.Manifest.permission.READ_PHONE_STATE)) {
            IMSI = telephonyManager.getSubscriberId();
        }
        Log.i(TAG, "IMSI == " + IMSI);

        if (IMSI == null || IMSI.length() < 1 || (telephonyManager.getSimState() == TelephonyManager.SIM_STATE_ABSENT)) {
            return nop;
        }

        nop = IMSI.substring(0, 5);
        return nop;
    }

    /**
     * 判断当前设备是平板还是手机
     *
     * @param context Context
     * @return 平板返回 True，手机返回 False
     */
    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK) >= Configuration.SCREENLAYOUT_SIZE_LARGE;
    }


    /**
     * 获取手机运营商类型
     *
     * @param context Context
     * @return operator type
     */
    @SuppressLint("MissingPermission")
    public static int getOperatorType(Context context) {
        if (isTablet(context)) {
            return 0;
        }
        TelephonyManager phoneManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String operator = null;
        if (phoneManager != null && Yodo1PermissonUtils.hasPermission(context, android.Manifest.permission.READ_PHONE_STATE)) {
            operator = phoneManager.getSubscriberId();
        }
        if (operator == null || operator.length() < 1 || (phoneManager.getSimState() == TelephonyManager.SIM_STATE_ABSENT)) {
            return 0;
        } else {
            if (operator.startsWith("46000") || operator.startsWith("46002") || operator.startsWith("46007") || operator.startsWith("46020")) {
                return CHANNEL_ID_cmcc;
            }
            if (operator.startsWith("46001") || operator.startsWith("46006")) {
                return CHANNEL_ID_unicom;
            }
            if (operator.startsWith("46003") || operator.startsWith("46005") || operator.startsWith("46011")) {
                return CHANNEL_ID_telecom;
            }
        }
        return 0;
    }

    /**
     * 获取网络状态，wifi,wap,2g,3g.
     *
     * @param context 上下文
     * @return network type
     */
    public static String getNetWorkType(Context context) {
        String mNetWorkType = "";
        ConnectivityManager manager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (manager != null && Yodo1PermissonUtils.hasPermission(context, android.Manifest.permission.ACCESS_NETWORK_STATE)) {
            networkInfo = manager.getActiveNetworkInfo();
        }
        if (networkInfo != null && networkInfo.isConnected()) {
            String type = networkInfo.getTypeName();

            if ("WIFI".equalsIgnoreCase(type)) {
                mNetWorkType = "wifi";
            } else if ("MOBILE".equalsIgnoreCase(type)) {
                String proxyHost = android.net.Proxy.getDefaultHost();
                mNetWorkType = TextUtils.isEmpty(proxyHost) ? (isFastMobileNetwork(context) ? "3g" : "2g") : "wap";
            }
        } else {
            mNetWorkType = "NETWORKTYPE_INVALID";
        }
        return mNetWorkType;
    }

    /**
     * 获取网络状态，wifi,wap,2g,3g.
     *
     * @param context 上下文
     * @return 网络类型
     */
    public static int getNetworkType(Context context) {
        int mNetWorkType = 0;
        String net = getNetWorkType(context);
        switch (net) {
            case "wifi":
                mNetWorkType = 100;
                break;
            case "3g":
                mNetWorkType = 3;
                break;
            case "2g":
                mNetWorkType = 2;
                break;
            case "4g":
                mNetWorkType = 4;
                break;
            case "5g":
                mNetWorkType = 5;
                break;
            default:
                mNetWorkType = 0;
                break;
        }
        return mNetWorkType;
    }

    private static boolean isFastMobileNetwork(Context context) {
        telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        if (telephonyManager != null) {
            switch (telephonyManager.getNetworkType()) {
                case TelephonyManager.NETWORK_TYPE_1xRTT:
                    return false; // ~ 50-100 kbps
                case TelephonyManager.NETWORK_TYPE_CDMA:
                    return false; // ~ 14-64 kbps
                case TelephonyManager.NETWORK_TYPE_EDGE:
                    return false; // ~ 50-100 kbps
                case TelephonyManager.NETWORK_TYPE_EVDO_0:
                    return true; // ~ 400-1000 kbps
                case TelephonyManager.NETWORK_TYPE_EVDO_A:
                    return true; // ~ 600-1400 kbps
                case TelephonyManager.NETWORK_TYPE_GPRS:
                    return false; // ~ 100 kbps
                case TelephonyManager.NETWORK_TYPE_HSDPA:
                    return true; // ~ 2-14 Mbps
                case TelephonyManager.NETWORK_TYPE_HSPA:
                    return true; // ~ 700-1700 kbps
                case TelephonyManager.NETWORK_TYPE_HSUPA:
                    return true; // ~ 1-23 Mbps
                case TelephonyManager.NETWORK_TYPE_UMTS:
                    return true; // ~ 400-7000 kbps
                case TelephonyManager.NETWORK_TYPE_EHRPD:
                    return true; // ~ 1-2 Mbps
                case TelephonyManager.NETWORK_TYPE_EVDO_B:
                    return true; // ~ 5 Mbps
                case TelephonyManager.NETWORK_TYPE_HSPAP:
                    return true; // ~ 10-20 Mbps
                case TelephonyManager.NETWORK_TYPE_IDEN:
                    return false; // ~25 kbps
                case TelephonyManager.NETWORK_TYPE_LTE:
                    return true; // ~ 10+ Mbps
                case TelephonyManager.NETWORK_TYPE_UNKNOWN:
                    return false;
                default:
                    return false;
            }
        }
        return false;
    }

    /**
     * 唯一的设备ID：
     * GSM手机的 IMEI 和 CDMA手机的 MEID.
     * Return null if device ID is not available.
     *
     * @param context Context
     * @return imei
     */
    @SuppressLint("MissingPermission")
    public static String getIMEI(Context context) {
        String imei = "";
        telephonyManager = (TelephonyManager) context.getSystemService(context.TELEPHONY_SERVICE);
        if (telephonyManager != null && Yodo1PermissonUtils.hasPermission(context, android.Manifest.permission.READ_PHONE_STATE)) {
            try {
                imei = telephonyManager.getDeviceId();
                if (TextUtils.isEmpty(imei) || "0".equals(imei) || "000000000000000".equals(imei)) {
                    imei = "";
                }
                YLog.d("Android Q 适配无法获取IMEI");
            } catch (Exception e) {
                imei = "";
            }
        }
        return imei;
    }


    /**
     * 返回唯一的用户ID;就是这张卡的编号
     *
     * @param context Context
     * @return Return null if device ID is not available.
     */
    @SuppressLint("MissingPermission")
    public static String getIMSI(Context context) {
        String imsi = null;
        telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        if (telephonyManager != null && Yodo1PermissonUtils.hasPermission(context, android.Manifest.permission.READ_PHONE_STATE)) {
            try {
                imsi = telephonyManager.getDeviceId();
                if (TextUtils.isEmpty(imsi) || "0".equals(imsi) || "000000000000000".equals(imsi)) {
                    imsi = "";
                }
                YLog.d("Android Q 适配无法获取IMSI");
            } catch (Exception e) {
                imsi = "";
            }
        }
        return imsi;
    }


    /***
     * 获取网关IP地址
     * @return hostIp
     */
    public static String getHostIp() {
        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface intf = en.nextElement();
                for (Enumeration<InetAddress> ipAddr = intf.getInetAddresses(); ipAddr.hasMoreElements(); ) {
                    InetAddress inetAddress = ipAddr.nextElement();
                    if (!inetAddress.isLoopbackAddress()) {
                        return inetAddress.getHostAddress();
                    }
                }
            }
        } catch (Exception e) {
        }
        return null;
    }
}
