package com.yodo1.advert.factory;

import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sensor.Yodo1Sensor;

import java.util.Map;

/**
 * @author zhuxc
 */
public class Yodo1AdvertProvider extends ContentProvider {
    private static final String TAG = "[Yodo1AdvertProvider] ";

    private Yodo1AdvertActivityObserver lifecycle;

    @Override
    public boolean onCreate() {
        Log.d("yodo1-games-sdk", TAG + "onCreate");
        boolean isDebugLogEnabled = false;
        String ySdkLog = Yodo1CommonUtils.getMetedataStr(this.getContext(), "Y_SDK_LOG");
        if (ySdkLog.equals("true")) {
            isDebugLogEnabled = true;
        } else {
            String str = YFileUtils.readFilesFromSDCard(".yodo1ads");
            if (!TextUtils.isEmpty(str) && str.contains("openYodo1Log")) {
                isDebugLogEnabled = true;
            }
        }
        if (isDebugLogEnabled) {
            YLog.setDebugMode(true);
            YLog.setOnLog(true);
            YLog.v(TAG + "The debug log has been enabled.");
        }

        YLog.d(TAG + "init sensor");
        Yodo1Sensor.init(getContext());

        registerLifecycle((Application) getContext());

        String processName = SysUtils.getProcessName(getContext(), android.os.Process.myPid());
        //判断是否为当前主进程，以防有多进程造成重复初始化
        if (getContext().getPackageName().equals(processName)) {
            if (Yodo1OnlineConfig.getInstance().hasData()) {

                //加载广告插件
                Yodo1AdvertAdapterFactory.getInstance().initAdvertAdapters(getContext());
                //广告Application初始化
                for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                    if (adapter.getValue() != null) {
                        adapter.getValue().onCreateApplication((Application) getContext());

                        String advertCode = adapter.getValue().getAdvertCode();
                        String sdkVersion = adapter.getValue().getSDKVesion();
                        YLog.d(TAG + "[" + advertCode + "] Sdk Version: " + (TextUtils.isEmpty(sdkVersion) ? "Not fetched" : sdkVersion));
                    }
                }
                Yodo1AdvertHelper.getInstance().onCreateApplication(getContext());
            }
        }

        return true;
    }

    private void registerLifecycle(Application context) {
        if (null != lifecycle) {
            context.unregisterActivityLifecycleCallbacks(lifecycle);
        }
        lifecycle = new Yodo1AdvertActivityObserver();
        context.registerActivityLifecycleCallbacks(lifecycle);
    }


    @Override
    public Cursor query(Uri uri, String[] strings, String s, String[] strings1, String s1) {
        return null;
    }


    @Override
    public String getType(Uri uri) {
        return null;
    }


    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return null;
    }

    @Override
    public int delete(Uri uri, String s, String[] strings) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String s, String[] strings) {
        return 0;
    }
}
