package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.Tapjoy;
import com.tapjoy.TapjoyLog;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Hashtable;

/**
 * @author yodo1
 */
public class AdvertAdaptertapjoy extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptertapjoy] ";
    private static final String CHANNEL_CODE = "Tapjoy";

    private static final String KEY_APP_KEY = "ad_tapjoy_appkey";
    private static final String KEY_PLACEMENT_VIDEO = "ad_tapjoy_placement_video";
    private static final String KEY_PLACEMENT_INTERSTITIAL = "ad_tapjoy_placement_interstitial";

    private static String placementInterstitial, placementVideo;

    private TJPlacement interstitialPlacement, videoPlacement;

    private TJPlacementListener videoListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onRequestSuccess");
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d(TAG + "RewardedAd onRequestFailure, tjPlacement: " + tjPlacement + ", tjError code: " + tjError.code + ", tjError message: " + tjError.message);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, tjError.code, tjError.message, getAdvertCode());
            }
        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onContentReady");
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onContentShow");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onContentDismiss");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d(TAG + "RewardedAd onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d(TAG + "RewardedAd onRewardRequest");
        }

        @Override
        public void onClick(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onClick");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    private TJPlacementVideoListener tjPlacementVideoListener = new TJPlacementVideoListener() {
        @Override
        public void onVideoStart(TJPlacement tjPlacement) {

        }

        @Override
        public void onVideoError(TJPlacement tjPlacement, String s) {

        }

        @Override
        public void onVideoComplete(TJPlacement tjPlacement) {
            // Best Practice: We recommend calling getCurrencyBalance as often as possible so the user�s balance is always up-to-date.
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    private TJPlacementListener interstitialListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onRequestSuccess");
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d(TAG + "InterstitialAd onRequestFailure, tjPlacement:" + tjPlacement + ", tjError code:" + tjError.code + ", tjError message: " + tjError.message);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, tjError.code, tjError.message, getAdvertCode());
            }
        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onContentReady");
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onContentShow");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, CHANNEL_CODE);
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onContentDismiss");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, CHANNEL_CODE);
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d(TAG + "InterstitialAd onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d(TAG + "InterstitialAd onRewardRequest");
        }

        @Override
        public void onClick(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onClick");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return Tapjoy.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        Tapjoy.onActivityStart(activity);
    }

    @Override
    public void onPause(Activity activity) {
        Tapjoy.onActivityStart(activity);
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String appkey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_KEY);
        if (TextUtils.isEmpty(appkey)) {
            appkey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_KEY);
        }
        if (TextUtils.isEmpty(appkey)) {
            YLog.d(TAG + "Initialize sdk failure, appkey is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appkey is null", getAdvertCode());
            return;
        }
        Hashtable<String, Object> connectFlags = new Hashtable<>();
        boolean isDebugEnabled = false;
        if (isDebugEnabled) {
            connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "true");
            Tapjoy.setDebugEnabled(true);
            TapjoyLog.setDebugEnabled(true);
        } else {
            connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "false");
            Tapjoy.setDebugEnabled(false);
            TapjoyLog.setDebugEnabled(false);
        }

        Tapjoy.setActivity(activity);

        this.updatePrivacyConsent(activity);
        Tapjoy.connect(activity.getApplicationContext(), appkey, connectFlags, new TJConnectListener() {
            @Override
            public void onConnectSuccess() {
                YLog.d(TAG + "Initialize sdk successful, onConnectSuccess");

                setInitialized(true);
                initializeCallback.onInitializeSuccess(getAdvertCode());
            }

            @Override
            public void onConnectFailure() {
                YLog.d(TAG + "Initialize sdk failure, onConnectFailure");
                initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "connect failure", getAdvertCode());
            }
        });
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        placementInterstitial = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_INTERSTITIAL);
        if (TextUtils.isEmpty(placementInterstitial)) {
            YLog.d(TAG + "Initialize interstitial video ad failure, placementInterstitial is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "placementInterstitial is null", getAdvertCode());
            return;
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial video ad successful, placementInterstitial: " + placementInterstitial);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (interstitialAdvertIsLoaded(activity)) {
                        YLog.d(TAG + "Showing interstitial video ad...");
                        interstitialPlacement.showContent();
                    }

                }
            });
        } catch (Exception exception) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Exception", CHANNEL_CODE);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        try {
            this.updatePrivacyConsent(activity);
            if (Tapjoy.isConnected()) {
                YLog.d(TAG + "Loading interstitial video ad...");
                interstitialPlacement = Tapjoy.getPlacement(placementInterstitial, interstitialListener);
                interstitialPlacement.requestContent();
            } else {
                YLog.d(TAG + "SDK must finish connecting before requesting content.");
            }
        } catch (Exception exception) {
            YLog.d("Tapjoy SDK Exception .");
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialPlacement != null && interstitialPlacement.isContentReady();
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        placementVideo = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_VIDEO);
        if (TextUtils.isEmpty(placementVideo)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, placementVideo is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "placementVideo is null", getAdvertCode());
            return;
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, placementVideo: " + placementVideo);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (videoAdvertIsLoaded(activity)) {
                    YLog.d(TAG + "Showing rewarded video ad...");

                    videoPlacement.showContent();
                }
            }
        });

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);

        try {
            this.updatePrivacyConsent(activity);
            if (Tapjoy.isConnected()) {
                YLog.d(TAG + "Loading rewarded video ad...");

                videoPlacement = Tapjoy.getPlacement(placementVideo, videoListener);

                videoPlacement.setVideoListener(tjPlacementVideoListener);
                videoPlacement.requestContent();
            } else {
                YLog.d(TAG + "SDK must finish connecting before requesting content.");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } catch (Error e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return videoPlacement != null && videoPlacement.isContentReady();
    }

    private void updatePrivacyConsent(Activity activity) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            YLog.d(TAG + "GDPR: " + privacy.isHasUserConsent() + ", COPPA: " + privacy.isAgeRestrictedUser() + ", CCPA: " + privacy.isDoNotSell());

            Tapjoy.setUserConsent(privacy.isHasUserConsent() ? "1" : "0");
            Tapjoy.belowConsentAge(privacy.isAgeRestrictedUser());
            Tapjoy.setActivity(activity);
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
