package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.text.TextUtils;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author sunmeng
 */
public class AdvertAdapterapplovinmax extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterapplovinmax] ";
    private static final String CHANNEL_CODE_MAX = "ApplovinMax";

    private static final String KEY_APPLOVIN_INTERSTITIAL_ID = "ad_applovin_interstitial_id";
    private static final String KEY_APPLOVIN_VIDEO_ID = "ad_applovin_video_id";
    private static final String KEY_APPLOVIN_BANNER_ID = "ad_applovin_banner_id";

    private MaxInterstitialAd interstitialAd;
    private MaxRewardedAd rewardedAd;
    private MaxAdView bannerAdView;

    private AppLovinSdkConfiguration.ConsentDialogState consentDialogState;

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;

    private MaxAdListener interstitialAdListener = new MaxAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdLoaded, UnitId: " + maxAd.getAdUnitId());
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d(TAG + "InterstitialAd onAdLoadFailed, s: " + s + ", i: " + i);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            // Interstitial ad failed to load. We recommend re-trying in 3 seconds.
            final Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (interstitialAd != null) {
                        interstitialAd.loadAd();
                    }
                }
            }, 3000);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdDisplayed, UnitId: " + maxAd.getAdUnitId());
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdHidden, UnitId: " + maxAd.getAdUnitId());
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d(TAG + "InterstitialAd onAdClicked, UnitId: " + maxAd.getAdUnitId());
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.d(TAG + "InterstitialAd onAdDisplayFailed, UnitId: " + maxAd.getAdUnitId());
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "", getAdvertCode());
            }
            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }
    };

    private MaxRewardedAdListener videoAdListener = new MaxRewardedAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdLoaded");
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d(TAG + "RewardedAd onAdLoadFailed, s: " + s + ", i: " + i);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            // Rewarded ad failed to load. We recommend re-trying in 3 seconds.
            final Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (rewardedAd != null) {
                        rewardedAd.loadAd();
                    }
                }
            }, 3000);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdDisplayed, UnitId: " + maxAd.getAdUnitId());
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdHidden, UnitId: " + maxAd.getAdUnitId());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onAdClicked, UnitId: " + maxAd.getAdUnitId());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.d(TAG + "RewardedAd onAdDisplayFailed, i: " + i + ", UnitId: " + maxAd.getAdUnitId());
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "", getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onRewardedVideoStarted, UnitId: " + maxAd.getAdUnitId());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            YLog.d(TAG + "RewardedAd onRewardedVideoCompleted, UnitId: " + maxAd.getAdUnitId());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {

        }
    };

    private MaxAdViewAdListener bannerAdListener = new MaxAdViewAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdLoaded, adUnitId: " + ad.getAdUnitId());
            setBannerLoaded(true);
        }

        @Override
        public void onAdLoadFailed(String adUnitId, int errorCode) {
            YLog.d(TAG + "BannerAd onAdLoadFailed, adUnitId: " + adUnitId + ", errorCode: " + errorCode);
            setBannerLoaded(false);
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdDisplayed, adUnitId: " + ad.getAdUnitId());

        }

        @Override
        public void onAdHidden(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdHidden, adUnitId: " + ad.getAdUnitId());
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdClicked, adUnitId: " + ad.getAdUnitId());
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, int errorCode) {
            YLog.d(TAG + "BannerAd onAdDisplayFailed, adUnitId: " + ad.getAdUnitId() + ", errorCode: " + errorCode);
            if (getBannerCallback() != null) {
                getBannerCallback().onAdError(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode + "", getAdvertCode());
            }
        }

        @Override
        public void onAdExpanded(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdDisplayed, adUnitId: " + ad.getAdUnitId());

        }

        @Override
        public void onAdCollapsed(MaxAd ad) {
            YLog.d(TAG + "BannerAd onAdDisplayed, adUnitId: " + ad.getAdUnitId());

        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE_MAX;
    }

    @Override
    public String getSDKVesion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }


    @Override
    public void initSdk(final Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        AppLovinSdk.initializeSdk(activity, new AppLovinSdk.SdkInitializationListener() {
            @Override
            public void onSdkInitialized(final AppLovinSdkConfiguration configuration) {
                // AppLovin SDK is initialized, start loading ads
                YLog.d(TAG + "Initialize sdk successful, " + configuration.getConsentDialogState().name());
                consentDialogState = configuration.getConsentDialogState();
                updatePrivacyConsent(activity, consentDialogState);

                setInitialized(true);

                if (initializeCallback != null) {
                    initializeCallback.onInitializeSuccess(getAdvertCode());
                }
            }
        });
    }

    @Override
    public void initVideoAd(final Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isVideoInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, getAdvertCode(), KEY_APPLOVIN_VIDEO_ID);
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoUnitId is null", getAdvertCode());
            return;
        }

        if (rewardedAd == null) {
            rewardedAd = MaxRewardedAd.getInstance(videoUnitId, activity);
            rewardedAd.setListener(videoAdListener);
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, videoUnitId: " + videoUnitId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");

        if (videoAdvertIsLoaded(activity)) {
            rewardedAd.showAd();
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent(activity, consentDialogState);

        if (rewardedAd != null) {
            rewardedAd.loadAd();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedAd != null && rewardedAd.isReady();
    }

    @Override
    public void initInterstitialAd(final Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isInterInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, getAdvertCode(), KEY_APPLOVIN_INTERSTITIAL_ID);
        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(TAG + "Initialize interstitial video ad failure, interUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interUnitId is null", getAdvertCode());
            return;
        }

        if (interstitialAd == null) {
            interstitialAd = new MaxInterstitialAd(interUnitId, activity);
            interstitialAd.setListener(interstitialAdListener);
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial video ad successful, interUnitId: " + interUnitId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadInterCallback(reloadCallback);
        YLog.d(TAG + "Loading interstitial video ad...");

        this.updatePrivacyConsent(activity, consentDialogState);

        if (interstitialAd != null) {
            interstitialAd.loadAd();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);
        YLog.d(TAG + "Showing interstitial video ad...");

        if (interstitialAdvertIsLoaded(activity)) {
            // Load the first ad
            interstitialAd.showAd();
        }
    }

    @Override
    public void initBannerAd(final Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isBannerInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String bannerUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, getAdvertCode(), KEY_APPLOVIN_BANNER_ID);
        if (TextUtils.isEmpty(bannerUnitId)) {
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "bannerUnitId is null", getAdvertCode());
            return;
        }

        if (bannerAdView == null) {
            bannerAdView = new MaxAdView(bannerUnitId, activity);
            bannerAdView.setListener(bannerAdListener);
            bannerAdView.loadAd();
        }

        this.setBannerInitialized(true);
        YLog.d(TAG + "Initialize banner ad successful, bannerUnitId: " + bannerUnitId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.setBannerCallback(callback);
        YLog.d(TAG + "Showing banner ad...");

        this.updatePrivacyConsent(activity, consentDialogState);

        if (hasLoadBanner()) {
            Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity, bannerAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public boolean hasLoadBanner() {
        return this.isBannerLoaded();
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d(TAG + "Hide banner ad...");
        if (bannerAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerAdView);
        }
    }

    @Override
    public void removeBanner(Activity activity) {

    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(TAG + "setBannerAlign, align:" + align);
    }

    private void updatePrivacyConsent(Activity activity, AppLovinSdkConfiguration.ConsentDialogState consentDialogState) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            YLog.d(TAG + "GDPR: " + privacy.isHasUserConsent() + ", COPPA: " + privacy.isAgeRestrictedUser() + ", CCPA: " + privacy.isDoNotSell());

            if (consentDialogState == AppLovinSdkConfiguration.ConsentDialogState.APPLIES) {
                // Show user consent dialog
                AppLovinPrivacySettings.setHasUserConsent(privacy.isHasUserConsent(), activity);
            }
            AppLovinPrivacySettings.setIsAgeRestrictedUser(privacy.isAgeRestrictedUser(), activity);
            AppLovinPrivacySettings.setDoNotSell(privacy.isDoNotSell(), activity);
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
