/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.crashreport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.WebView;
import com.tencent.bugly.BuglyStrategy;
import com.tencent.bugly.CrashModule;
import com.tencent.bugly.crashreport.common.strategy.StrategyBean;
import com.tencent.bugly.crashreport.crash.BuglyBroadcastReceiver;
import com.tencent.bugly.crashreport.crash.c;
import com.tencent.bugly.crashreport.crash.d;
import com.tencent.bugly.crashreport.crash.h5.H5JavaScriptInterface;
import com.tencent.bugly.crashreport.crash.h5.b;
import com.tencent.bugly.crashreport.crash.jni.NativeCrashHandler;
import com.tencent.bugly.proguard.q;
import com.tencent.bugly.proguard.w;
import com.tencent.bugly.proguard.x;
import com.tencent.bugly.proguard.z;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CrashReport {
    private static Context a;

    public static void enableBugly(boolean bl) {
        com.tencent.bugly.b.a = bl;
    }

    public static void initCrashReport(Context context) {
        a = context;
        com.tencent.bugly.b.a(CrashModule.getInstance());
        com.tencent.bugly.b.a(a);
    }

    public static void initCrashReport(Context context, UserStrategy userStrategy) {
        a = context;
        com.tencent.bugly.b.a(CrashModule.getInstance());
        com.tencent.bugly.b.a(context, userStrategy);
    }

    public static void initCrashReport(Context context, String string, boolean bl) {
        BuglyStrategy buglyStrategy = null;
        if (context != null) {
            a = context;
            com.tencent.bugly.b.a(CrashModule.getInstance());
            com.tencent.bugly.b.a(context, string, bl, buglyStrategy);
        }
    }

    public static void initCrashReport(Context context, String string, boolean bl, UserStrategy userStrategy) {
        if (context == null) {
            return;
        }
        a = context;
        com.tencent.bugly.b.a(CrashModule.getInstance());
        com.tencent.bugly.b.a(context, string, bl, userStrategy);
    }

    public static String getBuglyVersion(Context context) {
        if (context == null) {
            x.d("Please call with context.", new Object[0]);
            return "unknown";
        }
        com.tencent.bugly.crashreport.common.info.a.a(context);
        return com.tencent.bugly.crashreport.common.info.a.c();
    }

    public static void testJavaCrash() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not test Java crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a a2 = com.tencent.bugly.crashreport.common.info.a.b();
        if (a2 != null) {
            a2.b(24096);
        }
        throw new RuntimeException("This Crash create for Test! You can go to Bugly see more detail!");
    }

    public static void testNativeCrash() {
        CrashReport.testNativeCrash(false, false, false);
    }

    public static void testNativeCrash(boolean bl, boolean bl2, boolean bl3) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not test native crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        x.a("start to create a native crash for test!", new Object[0]);
        c.a().a(bl, bl2, bl3);
    }

    public static void testANRCrash() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not test ANR crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        x.a("start to create a anr crash for test!", new Object[0]);
        c.a().j();
    }

    public static void postException(Thread thread, int n2, String string, String string2, String string3, Map<String, String> map) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        d.a(thread, n2, string, string2, string3, map);
    }

    public static void postException(int n2, String string, String string2, String string3, Map<String, String> map) {
        CrashReport.postException(Thread.currentThread(), n2, string, string2, string3, map);
    }

    public static void postCatchedException(Throwable throwable) {
        CrashReport.postCatchedException(throwable, Thread.currentThread(), false);
    }

    public static void postCatchedException(Throwable throwable, Thread thread) {
        CrashReport.postCatchedException(throwable, thread, false);
    }

    public static void postCatchedException(Throwable throwable, Thread thread, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (throwable == null) {
            x.d("throwable is null, just return", new Object[0]);
            return;
        }
        if (thread == null) {
            thread = Thread.currentThread();
        }
        c.a().a(thread, throwable, false, null, null, bl);
    }

    public static void closeNativeReport() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not close native report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().f();
    }

    public static void startCrashReport() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not start crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().c();
    }

    public static void closeCrashReport() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not close crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().d();
    }

    public static void closeBugly() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not close bugly because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (a == null) {
            return;
        }
        Object object = BuglyBroadcastReceiver.getInstance();
        if (object != null) {
            object.unregister(a);
        }
        CrashReport.closeCrashReport();
        com.tencent.bugly.crashreport.biz.b.a(a);
        object = w.a();
        if (object != null) {
            ((w)object).b();
        }
    }

    public static void setUserSceneTag(Context objectArray, int n2) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set tag caught because bugly is disable.");
            return;
        }
        if (objectArray == null) {
            Log.e((String)x.a, (String)"setTag args context should not be null");
            return;
        }
        if (n2 <= 0) {
            x.d("setTag args tagId should > 0", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)objectArray).a(n2);
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = n2;
        x.b("[param] set user scene tag: %d", objectArray);
    }

    public static int getUserSceneTagId(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get user scene tag because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserSceneTagId args context should not be null");
            return -1;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).H();
    }

    public static String getUserData(Context context, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserDataValue args context should not be null");
            return "unknown";
        }
        if (z.a(string)) {
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).g(string);
    }

    public static void putUserData(Context objectArray, String string, String object) {
        Object object2;
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not put user data because bugly is disable.");
            return;
        }
        if (objectArray == null) {
            Log.w((String)x.a, (String)"putUserData args context should not be null");
            return;
        }
        if (string == null) {
            x.d("putUserData args key should not be null or empty", new Object[0]);
            return;
        }
        if (object == null) {
            String cfr_ignored_1 = (String)object;
            x.d("putUserData args value should not be null", new Object[0]);
            return;
        }
        if (!string.matches("[a-zA-Z[0-9]]+")) {
            x.d("putUserData args key should match [a-zA-Z[0-9]]+  {" + string + "}", new Object[0]);
            return;
        }
        if (object.length() > 200) {
            Object[] objectArray2 = object;
            Object[] objectArray3 = new Object[1];
            object = objectArray3;
            objectArray3[0] = 200;
            x.d("user data value length over limit %d, it will be cutted!", object);
            object = objectArray2.substring(0, 200);
        }
        if ((object2 = com.tencent.bugly.crashreport.common.info.a.a((Context)objectArray)).E().contains(string)) {
            object2 = NativeCrashHandler.getInstance();
            if (object2 != null) {
                object2.putKeyValueToNative(string, (String)object);
            }
            com.tencent.bugly.crashreport.common.info.a.a((Context)objectArray).b(string, (String)object);
            Object[] objectArray4 = new Object[2];
            objectArray = objectArray4;
            objectArray4[0] = string;
            objectArray4[1] = object;
            x.c("replace KV %s %s", objectArray);
            return;
        }
        if (object2.D() >= 10) {
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = 10;
            x.d("user data size is over limit %d, it will be cutted!", objectArray);
            return;
        }
        if (string.length() > 50) {
            Object[] objectArray6 = new Object[2];
            object2 = objectArray6;
            objectArray6[0] = 50;
            objectArray6[1] = string;
            x.d("user data key length over limit %d , will drop this new key %s", object2);
            string = string.substring(0, 50);
        }
        if ((object2 = NativeCrashHandler.getInstance()) != null) {
            object2.putKeyValueToNative(string, (String)object);
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)objectArray).b(string, (String)object);
        Object[] objectArray7 = new Object[2];
        objectArray = objectArray7;
        objectArray7[0] = string;
        objectArray7[1] = object;
        x.b("[param] set user data: %s - %s", objectArray);
    }

    public static String removeUserData(Context objectArray, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not remove user data because bugly is disable.");
            return "unknown";
        }
        if (objectArray == null) {
            Log.e((String)x.a, (String)"removeUserData args context should not be null");
            return "unknown";
        }
        if (z.a(string)) {
            return null;
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string;
        x.b("[param] remove user data: %s", objectArray);
        return com.tencent.bugly.crashreport.common.info.a.a((Context)objectArray2).f(string);
    }

    public static Set<String> getAllUserDataKeys(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get all keys of user data because bugly is disable.");
            return new HashSet<String>();
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getAllUserDataKeys args context should not be null");
            return new HashSet<String>();
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).E();
    }

    public static int getUserDatasSize(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get size of user data because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserDatasSize args context should not be null");
            return -1;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).D();
    }

    public static String getAppID() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get App ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).f();
    }

    public static void setUserId(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        CrashReport.setUserId(a, string);
    }

    public static void setUserId(Context object, String string) {
        String string2;
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.e((String)x.a, (String)"Context should not be null when bugly has not been initialed!");
            return;
        }
        if (string == null) {
            x.d("userId should not be null", new Object[0]);
            return;
        }
        if (string.length() > 100) {
            string2 = string.substring(0, 100);
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = 100;
            objectArray[2] = string2;
            x.d("userId %s length is over limit %d substring to %s", objectArray2);
        } else {
            string2 = string;
        }
        if (string2.equals(com.tencent.bugly.crashreport.common.info.a.a((Context)object).g())) {
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)object).b(string2);
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = string2;
        x.b("[user] set userId : %s", (Object[])object);
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeUserId(string2);
        }
        if (CrashModule.getInstance().hasInitialized()) {
            com.tencent.bugly.crashreport.biz.b.a();
        }
    }

    public static String getUserId() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get user ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).g();
    }

    public static String getAppVer() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get app version because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).j;
    }

    public static String getAppChannel() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get App channel because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).l;
    }

    public static void setContext(Context context) {
        a = context;
    }

    public static boolean isLastSessionCrash() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"The info 'isLastSessionCrash' is not accurate because bugly is disable.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return false;
        }
        return c.a().b();
    }

    public static void setSdkExtraData(Context context, String string, String string2) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not put SDK extra data because bugly is disable.");
            return;
        }
        if (context != null && !z.a(string) && !z.a(string2)) {
            com.tencent.bugly.crashreport.common.info.a.a(context).a(string, string2);
            return;
        }
    }

    public static Map<String, String> getSdkExtraData() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).A;
    }

    public static Map<String, String> getSdkExtraData(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)context).A;
    }

    private static void putSdkData(Context objectArray, String object, String object2) {
        if (objectArray != null && !z.a((String)object) && !z.a((String)object2)) {
            if ((object = object.replace("[a-zA-Z[0-9]]+", "")).length() > 100) {
                Object[] objectArray2 = object;
                Object[] objectArray3 = new Object[1];
                object = objectArray3;
                objectArray3[0] = 50;
                Log.w((String)x.a, (String)String.format("putSdkData key length over limit %d, will be cutted.", object));
                object = objectArray2.substring(0, 50);
            }
            if (object2.length() > 500) {
                Object[] objectArray4 = object2;
                Object[] objectArray5 = new Object[1];
                object2 = objectArray5;
                objectArray5[0] = 200;
                Log.w((String)x.a, (String)String.format("putSdkData value length over limit %d, will be cutted!", object2));
                object2 = objectArray4.substring(0, 200);
            }
            com.tencent.bugly.crashreport.common.info.a.a((Context)objectArray).c((String)object, (String)object2);
            Object[] objectArray6 = new Object[2];
            objectArray = objectArray6;
            objectArray6[0] = object;
            objectArray6[1] = object2;
            x.b(String.format("[param] putSdkData data: %s - %s", objectArray), new Object[0]);
            return;
        }
    }

    public static void setIsAppForeground(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set 'isAppForeground' because bugly is disable.");
            return;
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            x.c("App is in foreground.", new Object[0]);
        } else {
            x.c("App is in background.", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(bl);
    }

    public static void setIsDevelopmentDevice(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set 'isDevelopmentDevice' because bugly is disable.");
            return;
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            x.c("This is a development device.", new Object[0]);
        } else {
            x.c("This is not a development device.", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).y = bl;
    }

    public static void setSessionIntervalMills(long l2) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set 'SessionIntervalMills' because bugly is disable.");
            return;
        }
        com.tencent.bugly.crashreport.biz.b.a(l2);
    }

    public static void setAppVersion(Context object, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App version because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppVersion args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App version is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)object).j = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppVersion(string);
        }
    }

    public static void setAppChannel(Context object, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App channel because Bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppChannel args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App channel is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)object).l = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppChannel(string);
        }
    }

    public static void setAppPackage(Context object, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppPackage args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App package is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)object).c = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppPackage(string);
        }
    }

    public static void setCrashFilter(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set crash stack filter: " + string));
        c.n = string;
    }

    public static void setCrashRegularFilter(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set crash stack filter: " + string));
        c.o = string;
    }

    public static void setHandleNativeCrashInJava(boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Should handle native crash in Java profile after handled in native profile: " + bl));
        NativeCrashHandler.setShouldHandleInJava(bl);
    }

    public static void setBuglyDbName(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set DB name because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set Bugly DB name: " + string));
        q.a = string;
    }

    public static void enableObtainId(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set DB name because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)x.a, (String)"enableObtainId args context should not be null");
            return;
        }
        Log.i((String)x.a, (String)("Enable identification obtaining? " + bl));
        com.tencent.bugly.crashreport.common.info.a.a(context).b(bl);
    }

    public static void setAuditEnable(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)x.a, (String)"setAppPackage args context should not be null");
            return;
        }
        Log.i((String)x.a, (String)("Set audit enable: " + bl));
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).B = bl;
    }

    public static void setServerUrl(String string) {
        if (!z.a(string) && z.c(string)) {
            String string2 = string;
            com.tencent.bugly.crashreport.common.strategy.a.a(string2);
            StrategyBean.b = string2;
            StrategyBean.c = string2;
            return;
        }
        Log.i((String)x.a, (String)"URL is invalid.");
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean bl) {
        return CrashReport.setJavascriptMonitor(webView, bl, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebView webView, boolean bl, boolean bl2) {
        a a2;
        if (webView == null) {
            Log.w((String)x.a, (String)"WebView is null.");
            return false;
        }
        a a3 = a2;
        a3(webView);
        return CrashReport.setJavascriptMonitor(a2, bl, bl2);
    }

    public static boolean setJavascriptMonitor(WebViewInterface webViewInterface, boolean bl) {
        return CrashReport.setJavascriptMonitor(webViewInterface, bl, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebViewInterface objectArray, boolean bl, boolean bl2) {
        if (objectArray == null) {
            Log.w((String)x.a, (String)"WebViewInterface is null.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            x.e("CrashReport has not been initialed! please to call method 'initCrashReport' first!", new Object[0]);
            return false;
        }
        x.a("Set Javascript exception monitor of webview.", new Object[0]);
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set JavaScript monitor because bugly is disable.");
            return false;
        }
        Object[] objectArray2 = new Object[1];
        Object object = objectArray2;
        objectArray2[0] = objectArray.getUrl();
        x.c("URL of webview is %s", object);
        if (!bl2 && Build.VERSION.SDK_INT < 19) {
            x.e("This interface is only available for Android 4.4 or later.", new Object[0]);
            return false;
        }
        x.a("Enable the javascript needed by webview monitor.", new Object[0]);
        objectArray.setJavaScriptEnabled(true);
        object = H5JavaScriptInterface.getInstance((WebViewInterface)objectArray);
        if (object != null) {
            x.a("Add a secure javascript interface to the webview.", new Object[0]);
            objectArray.addJavascriptInterface((H5JavaScriptInterface)object, "exceptionUploader");
        }
        if (bl) {
            Object[] objectArray3 = new Object[1];
            Object object2 = objectArray3;
            objectArray3[0] = b.b();
            x.a("Inject bugly.js(v%s) to the webview.", object2);
            object2 = b.a();
            if (object2 == null) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = b.b();
                x.e("Failed to inject Bugly.js.", objectArray);
                return false;
            }
            objectArray.loadUrl("javascript:" + (String)object2);
        }
        return true;
    }

    public static void setHttpProxy(String string, int n2) {
        com.tencent.bugly.proguard.a.a(string, n2);
    }

    public static void setHttpProxy(InetAddress inetAddress, int n2) {
        com.tencent.bugly.proguard.a.a(inetAddress, n2);
    }

    public static Proxy getHttpProxy() {
        return com.tencent.bugly.proguard.a.b();
    }

    public static interface WebViewInterface {
        public String getUrl();

        public void setJavaScriptEnabled(boolean var1);

        public void loadUrl(String var1);

        public void addJavascriptInterface(H5JavaScriptInterface var1, String var2);

        public CharSequence getContentDescription();
    }

    public static class CrashHandleCallback
    extends BuglyStrategy.a {
    }

    public static class UserStrategy
    extends BuglyStrategy {
        private CrashHandleCallback a;

        public UserStrategy(Context context) {
        }

        @Override
        public synchronized CrashHandleCallback getCrashHandleCallback() {
            return this.a;
        }

        public synchronized void setCrashHandleCallback(CrashHandleCallback crashHandleCallback) {
            this.a = crashHandleCallback;
        }
    }
}

