/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.minisdk;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.WindowManager;
import com.sensorsdata.analytics.android.minisdk.AnalyticsMessages;
import com.sensorsdata.analytics.android.minisdk.ConfigurationChecker;
import com.sensorsdata.analytics.android.minisdk.EventTimer;
import com.sensorsdata.analytics.android.minisdk.EventType;
import com.sensorsdata.analytics.android.minisdk.ISensorsDataAPI;
import com.sensorsdata.analytics.android.minisdk.PersistentDistinctId;
import com.sensorsdata.analytics.android.minisdk.PersistentFirstDay;
import com.sensorsdata.analytics.android.minisdk.PersistentFirstStart;
import com.sensorsdata.analytics.android.minisdk.PersistentLoginId;
import com.sensorsdata.analytics.android.minisdk.PersistentSuperProperties;
import com.sensorsdata.analytics.android.minisdk.SALog;
import com.sensorsdata.analytics.android.minisdk.SensorsDataAPIEmptyImplementation;
import com.sensorsdata.analytics.android.minisdk.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.minisdk.SensorsDataExceptionHandler;
import com.sensorsdata.analytics.android.minisdk.SensorsDataGPSLocation;
import com.sensorsdata.analytics.android.minisdk.SensorsDataScreenOrientationDetector;
import com.sensorsdata.analytics.android.minisdk.SensorsDataThreadPool;
import com.sensorsdata.analytics.android.minisdk.SharedPreferencesLoader;
import com.sensorsdata.analytics.android.minisdk.exceptions.InvalidDataException;
import com.sensorsdata.analytics.android.minisdk.util.SensorsDataUtils;
import com.yodo1.sdk.kit.c;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1SensorsDataAPI
implements ISensorsDataAPI {
    static final int VTRACK_SUPPORTED_MIN_API = 16;
    static Boolean ENABLE_LOG = false;
    private static final Pattern KEY_PATTERN = Pattern.compile("^((?!^distinct_id$|^original_id$|^time$|^properties$|^id$|^first_id$|^second_id$|^users$|^events$|^event$|^user_id$|^date$|^datetime$)[a-zA-Z_$][a-zA-Z\\d_$]{0,99})$", 2);
    private static final Map<Context, Yodo1SensorsDataAPI> sInstanceMap = new HashMap<Context, Yodo1SensorsDataAPI>();
    private static final SharedPreferencesLoader sPrefsLoader = new SharedPreferencesLoader();
    private static SensorsDataGPSLocation mGPSLocation;
    private static final SimpleDateFormat mIsFirstDayDateFormat;
    private static final String TAG = "Yodo1SensorsDataAPI";
    static final String VERSION = "1.10.4-mini";
    public static final String SENSORS_DATA_API_FILE_NAME = ".sa";
    private String mServerUrl;
    private String mOriginServerUrl;
    private DebugMode mDebugMode;
    private int mFlushInterval;
    private int mFlushBulkSize;
    private boolean mEnableAndroidId;
    private final Context mContext;
    private final AnalyticsMessages mMessages;
    private final PersistentDistinctId mDistinctId;
    private final PersistentLoginId mLoginId;
    private final PersistentSuperProperties mSuperProperties;
    private final PersistentFirstStart mFirstStart;
    private final PersistentFirstDay mFirstDay;
    private final Map<String, Object> mDeviceInfo;
    private final Map<String, EventTimer> mTrackTimer;
    private int mFlushNetworkPolicy;
    private long mMaxCacheSize;
    private SensorsDataScreenOrientationDetector mOrientationDetector;

    private int toNetworkType(String string) {
        if ("NULL".equals(string)) {
            return 255;
        }
        if ("WIFI".equals(string)) {
            return 8;
        }
        if ("2G".equals(string)) {
            return 1;
        }
        if ("3G".equals(string)) {
            return 2;
        }
        if ("4G".equals(string)) {
            return 4;
        }
        return 255;
    }

    Yodo1SensorsDataAPI() {
        this.mFlushNetworkPolicy = 14;
        this.mMaxCacheSize = 0x2000000L;
        this.mContext = null;
        this.mMessages = null;
        this.mDistinctId = null;
        this.mLoginId = null;
        this.mSuperProperties = null;
        this.mFirstStart = null;
        this.mFirstDay = null;
        this.mDeviceInfo = null;
        this.mTrackTimer = null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    Yodo1SensorsDataAPI(Context var1_2, String var2_3, DebugMode var3_4) {
        block34: {
            block33: {
                block35: {
                    super();
                    this.mFlushNetworkPolicy = 14;
                    this.mMaxCacheSize = 0x2000000L;
                    this.mContext = var1_2 /* !! */ ;
                    this.mDebugMode = var3_4;
                    var4_5 = var1_2 /* !! */ .getApplicationContext().getPackageName();
                    try {
                        SensorsDataUtils.cleanUserAgent(this.mContext);
                    }
                    catch (Exception v0) {
                        v0.printStackTrace();
                    }
                    try {
                        SALog.init(this);
                        var5_7 /* !! */  = var1_2 /* !! */ .getApplicationContext().getPackageManager().getApplicationInfo((String)var4_5, (int)128).metaData;
                        if (var5_7 /* !! */  != null) ** GOTO lbl21
                    }
                    catch (PackageManager.NameNotFoundException var0_1) {
                        throw new RuntimeException("Can't configure Yodo1SensorsDataAPI with package name " + var4_5, var0_1);
                    }
                    var5_7 /* !! */  = v1;
                    v1 = new Bundle();
lbl21:
                    // 2 sources

                    this.setServerUrl((String)var2_3);
                    if (var3_4 != DebugMode.DEBUG_OFF) ** GOTO lbl26
                    Yodo1SensorsDataAPI.ENABLE_LOG = var5_7 /* !! */ .getBoolean("com.sensorsdata.analytics.android.EnableLogging", false);
                    break block35;
lbl26:
                    // 1 sources

                    Yodo1SensorsDataAPI.ENABLE_LOG = var5_7 /* !! */ .getBoolean("com.sensorsdata.analytics.android.EnableLogging", true);
                }
                v2 = this;
                v3 = v2;
                v4 = v2;
                this.mFlushInterval = var5_7 /* !! */ .getInt("com.sensorsdata.analytics.android.FlushInterval", 15000);
                this.mFlushBulkSize = var5_7 /* !! */ .getInt("com.sensorsdata.analytics.android.FlushBulkSize", 100);
                v2.mEnableAndroidId = var5_7 /* !! */ .getBoolean("com.sensorsdata.analytics.android.AndroidId", true);
                v2.mMessages = AnalyticsMessages.getInstance(v2.mContext, c.b(this.mContext) + ".sa");
                var2_3 = v5;
                v5 = new SharedPreferencesLoader.OnPrefsLoadedListener(){

                    @Override
                    public void onPrefsLoaded(SharedPreferences sharedPreferences) {
                    }
                };
                var2_3 = Yodo1SensorsDataAPI.sPrefsLoader.loadPreferences(var1_2 /* !! */ , c.b(var1_2 /* !! */ ) + ".sa", (SharedPreferencesLoader.OnPrefsLoadedListener)var2_3);
                v4.mDistinctId = new PersistentDistinctId((Future<SharedPreferences>)var2_3);
                if (v3.mEnableAndroidId) {
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)this.mDistinctId.get()))) break block33;
                    var4_5 = SensorsDataUtils.getAndroidID(this.mContext);
                    if (!SensorsDataUtils.isValidAndroidId(var4_5)) break block33;
                    try {
                        this.identify(var4_5);
                    }
                    catch (Exception v6) {
                        v6.printStackTrace();
                    }
                }
            }
            v7 = this;
            v7.mLoginId = new PersistentLoginId((Future<SharedPreferences>)var2_3);
            v7.mSuperProperties = new PersistentSuperProperties((Future<SharedPreferences>)var2_3);
            v7.mFirstStart = new PersistentFirstStart((Future<SharedPreferences>)var2_3);
            v7.mFirstDay = new PersistentFirstDay((Future<SharedPreferences>)var2_3);
            if (Build.VERSION.SDK_INT >= 14) {
                v8 = this;
                ((Application)var1_2 /* !! */ .getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new SensorsDataActivityLifecycleCallbacks(v8, v8.mFirstStart, this.mFirstDay));
            }
            if (var3_4 != DebugMode.DEBUG_OFF) {
                v9 = new Object[3];
                var2_3 = v9;
                var2_3[0] = this.mServerUrl;
                v9[1] = this.mFlushInterval;
                v9[2] = var3_4;
                Log.i((String)"Yodo1SensorsDataAPI", (String)String.format(Locale.CHINA, "Initialized the instance of Sensors Analytics SDK with server url '%s', flush interval %d ms, debugMode: %s", var2_3));
            }
            var2_3 = v10;
            new HashMap<String, String>().put("$lib", "Android");
            var2_3.put("$lib_version", "1.10.4-mini");
            var2_3.put("$os", "Android");
            var4_5 = "$os_version";
            var5_7 /* !! */  = Build.VERSION.RELEASE;
            if (var5_7 /* !! */  == null) {
                var5_7 /* !! */  = "UNKNOWN";
            }
            var2_3.put(var4_5, var5_7 /* !! */ );
            var4_5 = "$manufacturer";
            var5_7 /* !! */  = Build.MANUFACTURER;
            if (var5_7 /* !! */  == null) {
                var5_7 /* !! */  = "UNKNOWN";
            }
            var2_3.put(var4_5, var5_7 /* !! */ );
            if (TextUtils.isEmpty((CharSequence)Build.MODEL)) {
                var2_3.put("$model", "UNKNOWN");
            } else {
                var2_3.put("$model", Build.MODEL.trim());
            }
            v11 = var2_3;
            v12 = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            try {
                v11.put("$app_version", v12.versionName);
            }
            catch (Exception var4_6) {
                if (var3_4 == DebugMode.DEBUG_OFF) break block34;
                Log.i((String)"Yodo1SensorsDataAPI", (String)"Exception getting app version name", (Throwable)var4_6);
            }
        }
        var1_2 /* !! */  = var1_2 /* !! */ .getResources().getDisplayMetrics();
        var2_3.put("$screen_height", var1_2 /* !! */ .heightPixels);
        var2_3.put("$screen_width", var1_2 /* !! */ .widthPixels);
        var3_4 = (WindowManager)this.mContext.getSystemService("window");
        try {
            ** if (Build.VERSION.SDK_INT < 17) goto lbl-1000
        }
        catch (Exception v16) {
            var2_3.put("$screen_height", var1_2 /* !! */ .heightPixels);
        }
lbl-1000:
        // 1 sources

        {
            v13 = var3_4;
            var4_5 = v14;
            v14 = new Point();
            if (v13 != null) {
                v15 = var2_3;
                var3_4.getDefaultDisplay().getRealSize((Point)var4_5);
                v15.put("$screen_height", var4_5.y);
            }
        }
lbl-1000:
        // 4 sources

        {
        }
        if (!TextUtils.isEmpty((CharSequence)(var1_2 /* !! */  = SensorsDataUtils.getCarrier(this.mContext)))) {
            var2_3.put("$carrier", var1_2 /* !! */ );
        }
        if (!TextUtils.isEmpty((CharSequence)(var1_2 /* !! */  = SensorsDataUtils.getAndroidID(this.mContext)))) {
            var2_3.put("$device_id", var1_2 /* !! */ );
        }
        v17 = this;
        v17.mDeviceInfo = Collections.unmodifiableMap(var2_3);
        v17.mTrackTimer = new HashMap<String, EventTimer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Yodo1SensorsDataAPI sharedInstance(Context var0) {
        if (var0 /* !! */  == null) {
            return new SensorsDataAPIEmptyImplementation();
        }
        v0 = var0 /* !! */ ;
        var0 /* !! */  = Yodo1SensorsDataAPI.sInstanceMap;
        synchronized (var0 /* !! */ ) {
            var1_1 = Yodo1SensorsDataAPI.sInstanceMap.get(v0.getApplicationContext());
            if (var1_1 != null) ** GOTO lbl16
            Log.i((String)"Yodo1SensorsDataAPI", (String)"The static method sharedInstance(context, serverURL, debugMode) should be called before calling sharedInstance()");
            return new SensorsDataAPIEmptyImplementation();
lbl16:
            // 1 sources

            return var1_1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Yodo1SensorsDataAPI sharedInstance(Context object, String string, DebugMode debugMode) {
        if (object == null) {
            return new SensorsDataAPIEmptyImplementation();
        }
        Context context = object;
        object = sInstanceMap;
        synchronized (object) {
            Yodo1SensorsDataAPI yodo1SensorsDataAPI;
            block11: {
                Yodo1SensorsDataAPI yodo1SensorsDataAPI2;
                Context context2 = context.getApplicationContext();
                yodo1SensorsDataAPI = sInstanceMap.get(context2);
                if (yodo1SensorsDataAPI != null) break block11;
                if (!ConfigurationChecker.checkBasicConfiguration(context2)) break block11;
                yodo1SensorsDataAPI = yodo1SensorsDataAPI2;
                yodo1SensorsDataAPI2 = new Yodo1SensorsDataAPI(context2, string, debugMode);
                sInstanceMap.put(context2, yodo1SensorsDataAPI);
            }
            if (yodo1SensorsDataAPI != null) {
                return yodo1SensorsDataAPI;
            }
            return new SensorsDataAPIEmptyImplementation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Yodo1SensorsDataAPI sharedInstance() {
        Map<Context, Yodo1SensorsDataAPI> map = sInstanceMap;
        synchronized (map) {
            block7: {
                if (sInstanceMap.size() <= 0) break block7;
                Iterator<Yodo1SensorsDataAPI> iterator = sInstanceMap.values().iterator();
                if (!iterator.hasNext()) break block7;
                return iterator.next();
            }
            return new SensorsDataAPIEmptyImplementation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void allInstances(InstanceProcessor instanceProcessor) {
        Map<Context, Yodo1SensorsDataAPI> map = sInstanceMap;
        synchronized (map) {
            Iterator<Yodo1SensorsDataAPI> iterator = sInstanceMap.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                instanceProcessor.process(iterator.next());
            }
        }
    }

    private void disableDebugMode() {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
        yodo1SensorsDataAPI.mDebugMode = DebugMode.DEBUG_OFF;
        yodo1SensorsDataAPI.enableLog(false);
        yodo1SensorsDataAPI.mServerUrl = yodo1SensorsDataAPI.mOriginServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackEvent(final EventType eventType, final String string, final JSONObject jSONObject, final String string2) {
        EventTimer eventTimer;
        if (string != null) {
            Map<String, EventTimer> map = this.mTrackTimer;
            Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
            synchronized (map) {
                eventTimer = yodo1SensorsDataAPI.mTrackTimer.get(string);
                yodo1SensorsDataAPI.mTrackTimer.remove(string);
            }
        } else {
            eventTimer = null;
        }
        SensorsDataThreadPool.getInstance().execute(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [81[CATCHBLOCK]], but top level block is 22[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    private boolean isFirstDay() {
        String string = (String)((Yodo1SensorsDataAPI)((Object)string)).mFirstDay.get();
        if (string == null) {
            return true;
        }
        return string.equals(mIsFirstDayDateFormat.format(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void assertPropertyTypes(EventType object, JSONObject jSONObject) throws InvalidDataException {
        if (jSONObject == null) {
            return;
        }
        object = jSONObject.keys();
        while (object.hasNext()) {
            Object object2;
            String string = (String)object.next();
            this.assertKey(string);
            try {
                object2 = jSONObject.get(string);
            }
            catch (JSONException jSONException) {
                throw new InvalidDataException("Unexpected property key. [key='" + string + "']");
            }
            {
                if (!(object2 instanceof String || object2 instanceof Number || object2 instanceof JSONArray || object2 instanceof Boolean || object2 instanceof Date)) {
                    throw new InvalidDataException("The property value must be an instance of String/Number/Boolean/JSONArray. [key='" + string + "', value='" + object2.toString() + "']");
                }
                if ("app_crashed_reason".equals(string)) {
                    if (!(object2 instanceof String) || string.startsWith("$") || ((String)object2).length() <= 16382) continue;
                    SALog.d(TAG, "The property value is too long. [key='" + string + "', value='" + object2.toString() + "']");
                    continue;
                }
                if (!(object2 instanceof String) || string.startsWith("$") || ((String)object2).length() <= 8191) continue;
                SALog.d(TAG, "The property value is too long. [key='" + string + "', value='" + object2.toString() + "']");
                continue;
            }
            break;
        }
        return;
    }

    private void assertKey(String string) throws InvalidDataException {
        if (string != null && string.length() >= 1) {
            if (KEY_PATTERN.matcher(string).matches()) {
                return;
            }
            throw new InvalidDataException("The key '" + string + "' is invalid.");
        }
        throw new InvalidDataException("The key is empty.");
    }

    private void assertDistinctId(String string) throws InvalidDataException {
        if (string != null && string.length() >= 1) {
            if (string.length() <= 255) {
                return;
            }
            throw new InvalidDataException("The max length of distinct_id or original_id or login_id is 255.");
        }
        throw new InvalidDataException("The distinct_id or original_id or login_id is empty.");
    }

    static /* synthetic */ void access$000(Yodo1SensorsDataAPI yodo1SensorsDataAPI, String string) throws InvalidDataException {
        yodo1SensorsDataAPI.assertKey(string);
    }

    static /* synthetic */ void access$100(Yodo1SensorsDataAPI yodo1SensorsDataAPI, EventType eventType, JSONObject jSONObject) throws InvalidDataException {
        yodo1SensorsDataAPI.assertPropertyTypes(eventType, jSONObject);
    }

    static /* synthetic */ Map access$200(Yodo1SensorsDataAPI yodo1SensorsDataAPI) {
        return yodo1SensorsDataAPI.mDeviceInfo;
    }

    static /* synthetic */ Context access$300(Yodo1SensorsDataAPI yodo1SensorsDataAPI) {
        return yodo1SensorsDataAPI.mContext;
    }

    static /* synthetic */ PersistentSuperProperties access$400(Yodo1SensorsDataAPI yodo1SensorsDataAPI) {
        return yodo1SensorsDataAPI.mSuperProperties;
    }

    static /* synthetic */ SensorsDataGPSLocation access$500() {
        return mGPSLocation;
    }

    static /* synthetic */ boolean access$600(Yodo1SensorsDataAPI yodo1SensorsDataAPI) {
        return yodo1SensorsDataAPI.isFirstDay();
    }

    static /* synthetic */ AnalyticsMessages access$700(Yodo1SensorsDataAPI yodo1SensorsDataAPI) {
        return yodo1SensorsDataAPI.mMessages;
    }

    static {
        mIsFirstDayDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    }

    protected boolean isShouldFlush(String string) {
        return (this.toNetworkType(string) & this.mFlushNetworkPolicy) != 0;
    }

    @Override
    public JSONObject getPresetProperties() {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2 = jSONObject;
        jSONObject3();
        jSONObject3.put("$app_version", this.mDeviceInfo.get("$app_version"));
        jSONObject3.put("$lib", (Object)"Android");
        jSONObject3.put("$lib_version", (Object)VERSION);
        jSONObject3.put("$manufacturer", this.mDeviceInfo.get("$manufacturer"));
        jSONObject3.put("$model", this.mDeviceInfo.get("$model"));
        jSONObject3.put("$os", (Object)"Android");
        jSONObject3.put("$os_version", this.mDeviceInfo.get("$os_version"));
        jSONObject3.put("$screen_height", this.mDeviceInfo.get("$screen_height"));
        jSONObject3.put("$screen_width", this.mDeviceInfo.get("$screen_width"));
        String string = SensorsDataUtils.networkType(this.mContext);
        jSONObject.put("$wifi", string.equals("WIFI"));
        jSONObject.put("$network_type", (Object)string);
        jSONObject.put("$carrier", this.mDeviceInfo.get("$carrier"));
        jSONObject.put("$is_first_day", this.isFirstDay());
        try {
            jSONObject.put("$device_id", this.mDeviceInfo.get("$device_id"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setServerUrl(String var1_1) {
        block8: {
            this.mOriginServerUrl = var1_1;
            if (TextUtils.isEmpty((CharSequence)var1_1)) ** GOTO lbl19
            if (this.mDebugMode == DebugMode.DEBUG_OFF) ** GOTO lbl19
            var1_1 = Uri.parse((String)var1_1);
            var2_2 = var1_1.getPath().lastIndexOf(47);
            if (var2_2 == -1) break block8;
            v0 = this;
            v1 = var1_1;
            this = var1_1.getPath().substring(0, var2_2) + "/debug";
            try {
                v0.mServerUrl = v1.buildUpon().path(this).build().toString();
                break block8;
lbl19:
                // 2 sources

                this.mServerUrl = var1_1;
                this.disableDebugMode();
            }
            catch (Exception v2) {
                v2.printStackTrace();
            }
        }
    }

    @Override
    public void enableLog(boolean bl) {
        ENABLE_LOG = bl;
    }

    @Override
    public long getMaxCacheSize() {
        return this.mMaxCacheSize;
    }

    @Override
    public void setMaxCacheSize(long l2) {
        if (l2 > 0L) {
            if (l2 < 0x1000000L) {
                l2 = 0x1000000L;
            }
            this.mMaxCacheSize = l2;
        }
    }

    @Override
    public void setFlushNetworkPolicy(int n2) {
        this.mFlushNetworkPolicy = n2;
    }

    @Override
    public int getFlushInterval() {
        return this.mFlushInterval;
    }

    @Override
    public void setFlushInterval(int n2) {
        if (n2 < 5000) {
            n2 = 5000;
        }
        this.mFlushInterval = n2;
    }

    @Override
    public int getFlushBulkSize() {
        return this.mFlushBulkSize;
    }

    @Override
    public void setFlushBulkSize(int n2) {
        this.mFlushBulkSize = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setGPSLocation(double d2, double d3) {
        try {
            if (mGPSLocation == null) {
                mGPSLocation = new SensorsDataGPSLocation();
            }
            mGPSLocation.setLatitude((long)(d2 * Math.pow(10.0, 6.0)));
            mGPSLocation.setLongitude((long)(d3 * Math.pow(10.0, 6.0)));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void clearGPSLocation() {
        mGPSLocation = null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void enableTrackScreenOrientation(boolean var1_1) {
        block4: {
            if (!var1_1) ** GOTO lbl8
            if (this.mOrientationDetector != null) ** GOTO lbl6
            this.mOrientationDetector = new SensorsDataScreenOrientationDetector(this.mContext, 3);
lbl6:
            // 2 sources

            this.mOrientationDetector.enable();
            break block4;
lbl8:
            // 1 sources

            if (this.mOrientationDetector == null) break block4;
            try {
                this.mOrientationDetector.disable();
                this.mOrientationDetector = null;
            }
            catch (Exception v0) {
                v0.printStackTrace();
            }
        }
    }

    @Override
    public void resumeTrackScreenOrientation() {
        block3: {
            if (this.mOrientationDetector == null) break block3;
            try {
                this.mOrientationDetector.enable();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void stopTrackScreenOrientation() {
        block3: {
            if (this.mOrientationDetector == null) break block3;
            try {
                this.mOrientationDetector.disable();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String getScreenOrientation() {
        block3: {
            if (this.mOrientationDetector == null) break block3;
            try {
                return this.mOrientationDetector.getOrientation();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void trackAppCrash() {
        SensorsDataExceptionHandler.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getDistinctId() {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = persistentDistinctId;
        PersistentDistinctId persistentDistinctId = yodo1SensorsDataAPI.mDistinctId;
        synchronized (persistentDistinctId) {
            return (String)yodo1SensorsDataAPI.mDistinctId.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAnonymousId() {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = persistentDistinctId;
        PersistentDistinctId persistentDistinctId = yodo1SensorsDataAPI.mDistinctId;
        synchronized (persistentDistinctId) {
            return (String)yodo1SensorsDataAPI.mDistinctId.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void resetAnonymousId() {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
        PersistentDistinctId persistentDistinctId = yodo1SensorsDataAPI.mDistinctId;
        synchronized (persistentDistinctId) {
            String string;
            if (yodo1SensorsDataAPI.mEnableAndroidId && SensorsDataUtils.isValidAndroidId(string = SensorsDataUtils.getAndroidID(this.mContext))) {
                this.mDistinctId.commit(string);
                return;
            }
            this.mDistinctId.commit(UUID.randomUUID().toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLoginId() {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = persistentLoginId;
        PersistentLoginId persistentLoginId = yodo1SensorsDataAPI.mLoginId;
        synchronized (persistentLoginId) {
            return (String)yodo1SensorsDataAPI.mLoginId.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void identify(String string) {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
        yodo1SensorsDataAPI.assertDistinctId(string);
        PersistentDistinctId persistentDistinctId = yodo1SensorsDataAPI.mDistinctId;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = this;
        // MONITORENTER : persistentDistinctId
        try {
            yodo1SensorsDataAPI2.mDistinctId.commit(string);
            // MONITOREXIT : persistentDistinctId
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : persistentDistinctId
            try {
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void login(String string) {
        String string2 = string;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = yodo1SensorsDataAPI;
        yodo1SensorsDataAPI.assertDistinctId(string);
        PersistentLoginId persistentLoginId = yodo1SensorsDataAPI.mLoginId;
        try {
            if (!string2.equals(yodo1SensorsDataAPI2.mLoginId.get())) {
                Yodo1SensorsDataAPI yodo1SensorsDataAPI3 = this;
                yodo1SensorsDataAPI3.mLoginId.commit(string);
                if (!string.equals(yodo1SensorsDataAPI3.getAnonymousId())) {
                    this.trackEvent(EventType.TRACK_SIGNUP, "$SignUp", null, this.getAnonymousId());
                }
            }
            // MONITOREXIT : persistentLoginId
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : persistentLoginId
            try {
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        PersistentLoginId persistentLoginId = this.mLoginId;
        synchronized (persistentLoginId) {
            this.mLoginId.commit(null);
            return;
        }
    }

    @Override
    public void track(String string, JSONObject jSONObject) {
        try {
            this.trackEvent(EventType.TRACK, string, jSONObject, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void track(String string) {
        try {
            this.trackEvent(EventType.TRACK, string, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void trackTimerStart(String string) {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
        yodo1SensorsDataAPI.assertKey(string);
        Map<String, EventTimer> map = yodo1SensorsDataAPI.mTrackTimer;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = this;
        // MONITORENTER : map
        yodo1SensorsDataAPI2.mTrackTimer.put(string, new EventTimer(TimeUnit.SECONDS));
        try {
            // MONITOREXIT : map
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : map
            try {
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void trackTimerEnd(String string, JSONObject jSONObject) {
        this.track(string, jSONObject);
    }

    @Override
    public void trackTimerEnd(String string) {
        this.track(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTrackTimer() {
        Map<String, EventTimer> map = this.mTrackTimer;
        synchronized (map) {
            this.mTrackTimer.clear();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appEnterBackground() {
        v0 = this;
        this = v0.mTrackTimer;
        synchronized (this) {
            block10: {
                block9: {
                    try lbl-1000:
                    // 4 sources

                    {
                        for (Map.Entry<String, EventTimer> var2_3 : v0.mTrackTimer.entrySet()) {
                            if (var2_3 == null) continue;
                            ** GOTO lbl-1000
                        }
                        break block9;
                    }
                    catch (Throwable v1) {
                        break block10;
                    }
                    catch (Exception var1_2) {
                        SALog.i("Yodo1SensorsDataAPI", "appEnterBackground error:" + var1_2.getMessage());
                        break block9;
                    }
lbl-1000:
                    // 1 sources

                    {
                        if ("$AppEnd".equals(var2_3.getKey().toString()) || (var2_3 = var2_3.getValue()) == null) ** GOTO lbl-1000
                    }
                    {
                        v2 = var2_3;
                        v2.setEventAccumulatedDuration(v2.getEventAccumulatedDuration() + SystemClock.elapsedRealtime() - var2_3.getStartTime());
                        v2.setStartTime(SystemClock.elapsedRealtime());
                    }
                    ** GOTO lbl-1000
                }
                return;
            }
            throw v1;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appBecomeActive() {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = map;
        Map<String, EventTimer> map = yodo1SensorsDataAPI.mTrackTimer;
        synchronized (map) {
            Throwable throwable2;
            block8: {
                try {
                    for (Map.Entry<String, EventTimer> entry : yodo1SensorsDataAPI.mTrackTimer.entrySet()) {
                        if (entry == null || (entry = entry.getValue()) == null) continue;
                        ((EventTimer)((Object)entry)).setStartTime(SystemClock.elapsedRealtime());
                    }
                }
                catch (Exception exception) {
                    SALog.i(TAG, "appBecomeActive error:" + exception.getMessage());
                }
                {
                    catch (Throwable throwable2) {
                        break block8;
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    @Override
    public void flush() {
        this.mMessages.flush();
    }

    @Override
    public void flushSync() {
        this.mMessages.sendData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject getSuperProperties() {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = persistentSuperProperties;
        PersistentSuperProperties persistentSuperProperties = yodo1SensorsDataAPI.mSuperProperties;
        synchronized (persistentSuperProperties) {
            return (JSONObject)yodo1SensorsDataAPI.mSuperProperties.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void registerSuperProperties(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = yodo1SensorsDataAPI4;
        yodo1SensorsDataAPI.assertPropertyTypes(EventType.REGISTER_SUPER_PROPERTIES, jSONObject);
        PersistentSuperProperties persistentSuperProperties = yodo1SensorsDataAPI.mSuperProperties;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = yodo1SensorsDataAPI4;
        JSONObject jSONObject2 = jSONObject;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI3 = yodo1SensorsDataAPI4;
        // MONITORENTER : persistentSuperProperties
        try {
            Yodo1SensorsDataAPI yodo1SensorsDataAPI4 = (JSONObject)yodo1SensorsDataAPI3.mSuperProperties.get();
            SensorsDataUtils.mergeJSONObject(jSONObject2, (JSONObject)yodo1SensorsDataAPI4);
            yodo1SensorsDataAPI2.mSuperProperties.commit(yodo1SensorsDataAPI4);
            // MONITOREXIT : persistentSuperProperties
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : persistentSuperProperties
            try {
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void unregisterSuperProperty(String string) {
        PersistentSuperProperties persistentSuperProperties = yodo1SensorsDataAPI4.mSuperProperties;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = yodo1SensorsDataAPI4;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = yodo1SensorsDataAPI;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI3 = yodo1SensorsDataAPI;
        // MONITORENTER : persistentSuperProperties
        Yodo1SensorsDataAPI yodo1SensorsDataAPI4 = (JSONObject)yodo1SensorsDataAPI2.mSuperProperties.get();
        yodo1SensorsDataAPI4.remove(string);
        try {
            yodo1SensorsDataAPI3.mSuperProperties.commit(yodo1SensorsDataAPI4);
            // MONITOREXIT : persistentSuperProperties
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : persistentSuperProperties
            try {
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSuperProperties() {
        PersistentSuperProperties persistentSuperProperties = this.mSuperProperties;
        synchronized (persistentSuperProperties) {
            this.mSuperProperties.commit(new JSONObject());
            return;
        }
    }

    @Override
    public void profileSet(JSONObject jSONObject) {
        try {
            this.trackEvent(EventType.PROFILE_SET, null, jSONObject, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileSet(String string, Object object) {
        JSONObject jSONObject;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = yodo1SensorsDataAPI2;
        EventType eventType = EventType.PROFILE_SET;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = jSONObject;
        try {
            yodo1SensorsDataAPI2();
            yodo1SensorsDataAPI.trackEvent(eventType, null, jSONObject.put(string, object), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileSetOnce(JSONObject jSONObject) {
        try {
            this.trackEvent(EventType.PROFILE_SET_ONCE, null, jSONObject, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileSetOnce(String string, Object object) {
        JSONObject jSONObject;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = yodo1SensorsDataAPI2;
        EventType eventType = EventType.PROFILE_SET_ONCE;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = jSONObject;
        try {
            yodo1SensorsDataAPI2();
            yodo1SensorsDataAPI.trackEvent(eventType, null, jSONObject.put(string, object), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileIncrement(Map<String, ? extends Number> map) {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
        EventType eventType = EventType.PROFILE_INCREMENT;
        try {
            yodo1SensorsDataAPI.trackEvent(eventType, null, new JSONObject(map), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileIncrement(String string, Number number) {
        JSONObject jSONObject;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = yodo1SensorsDataAPI2;
        EventType eventType = EventType.PROFILE_INCREMENT;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = jSONObject;
        try {
            yodo1SensorsDataAPI2();
            yodo1SensorsDataAPI.trackEvent(eventType, null, jSONObject.put(string, (Object)number), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileAppend(String string, String string2) {
        JSONObject jSONObject;
        JSONArray jSONArray;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = yodo1SensorsDataAPI2;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = jSONArray;
        yodo1SensorsDataAPI2();
        jSONArray.put((Object)string2);
        string2 = jSONObject;
        string2();
        jSONObject.put(string, (Object)yodo1SensorsDataAPI2);
        try {
            yodo1SensorsDataAPI.trackEvent(EventType.PROFILE_APPEND, null, (JSONObject)string2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileAppend(String string, Set<String> jSONArray) {
        JSONObject jSONObject;
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray;
        jSONArray = jSONArray2;
        jSONArray2 = new JSONArray();
        Iterator iterator = jSONArray3.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            jSONArray.put((Object)((String)iterator.next()));
        }
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = yodo1SensorsDataAPI2;
        Yodo1SensorsDataAPI yodo1SensorsDataAPI2 = jSONObject;
        yodo1SensorsDataAPI2();
        jSONObject.put(string, (Object)jSONArray);
        try {
            yodo1SensorsDataAPI.trackEvent(EventType.PROFILE_APPEND, null, (JSONObject)yodo1SensorsDataAPI2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileUnset(String string) {
        Yodo1SensorsDataAPI yodo1SensorsDataAPI = this;
        EventType eventType = EventType.PROFILE_UNSET;
        try {
            yodo1SensorsDataAPI.trackEvent(eventType, null, new JSONObject().put(string, true), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void profileDelete() {
        try {
            this.trackEvent(EventType.PROFILE_DELETE, null, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isDebugMode() {
        return this.mDebugMode.isDebugMode();
    }

    boolean isDebugWriteData() {
        return this.mDebugMode.isDebugWriteData();
    }

    String getServerUrl() {
        return this.mServerUrl;
    }

    static interface InstanceProcessor {
        public void process(Yodo1SensorsDataAPI var1);
    }

    public final class NetworkType {
        public static final int TYPE_NONE = 0;
        public static final int TYPE_2G = 1;
        public static final int TYPE_3G = 2;
        public static final int TYPE_4G = 4;
        public static final int TYPE_WIFI = 8;
        public static final int TYPE_ALL = 255;
    }

    public static enum DebugMode {
        DEBUG_OFF(false, false),
        DEBUG_ONLY(true, false),
        DEBUG_AND_TRACK(true, true);

        private final boolean debugMode;
        private final boolean debugWriteData;

        private DebugMode(boolean bl, boolean bl2) {
            this.debugMode = bl;
            this.debugWriteData = bl2;
        }

        boolean isDebugMode() {
            return this.debugMode;
        }

        boolean isDebugWriteData() {
            return this.debugWriteData;
        }
    }
}

