package com.yodo1.sensor;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONObject;


/**
 * @author :huangguofeng
 * date :2020-03-24
 * package :com.yodo1.sensor
 * desc    : 神策埋点入口类
 */
public class Yodo1Sensor {
    private static final String TAG = "[Yodo1Sensor] ";
    private static Yodo1SensorHelper helper = Yodo1SensorHelper.getInstance();
    private static boolean isOpen=false;

    public static void init(Context context) {
        YLog.d(TAG + "The Yodo1Sensor init  method is called...");
        if(checkSwitch(context)){
            isOpen=true;
            YLog.d(TAG + "The sensor is turn on....");
            helper.init(context);
        }else{
            isOpen=false;
            YLog.d(TAG + "The sensor is turn off....");
        }
    }

    public static void destroy() {
        YLog.d(TAG + "The onDestroy of activity life cycle method is called...");
        helper.onDestroy();
    }

    /**
     *  检查manifest中神策的配置 默认开启
     */
    private static boolean checkSwitch(Context context){
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getApplicationContext().getPackageManager()
                    .getApplicationInfo(SysUtils.getPackageName(context), PackageManager.GET_META_DATA);
            Bundle configBundle = appInfo.metaData;
            if(configBundle==null){
                YLog.d(TAG + "The metaData is null，turn off sensor");
                return false;
            }
            /**
             *  获取神策功能总控开关
             */
            return configBundle.getBoolean("Y_SDK_SENSORS_SWITCH", false);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }


    /**
     * desc：记录激活事件
     *
     * @param eventId  激活事件名
     * @param properties 激活事件属性
     */
    public static void trackInstallation(String eventId, JSONObject properties){
        if(isOpen){
            YLog.d(TAG + "The trackInstallation method is called...");
            helper.trackInstallation(eventId,properties);
        }else{
            YLog.d(TAG + "The sensor is turn off...");
        }
    }


    /**
     * desc：事件埋点
     *
     * @param  eventId  事件名
     * @param  properties  事件属性
     */
    public static void track(String eventId, JSONObject properties){
        if(isOpen){
            YLog.d(TAG + "The track method is called...");
            helper.track(eventId,properties);
        }else{
            YLog.d(TAG + "The sensor is turn off...");
        }

    }

    /**
     * desc：用户属性设置
     *
     * @param  properties  事件属性
     */
    public static void profileSet(JSONObject properties){
        if(isOpen){
            YLog.d(TAG + "The profileSet method is called...");
            helper.profileSet(properties);
        }else{
            YLog.d(TAG + "The sensor is turn off...");
        }

    }
}
