package com.yodo1.bugly;

import android.content.Context;
import android.text.TextUtils;

import com.tencent.bugly.crashreport.CrashReport;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

/**
 * 2020年3月26日17:41:38,appid by onlineConfig.var.
 *
 * @author Administrator Hunter
 */
public class Yodo1ExceptionHandler {

    private static final String TAG = "[Yodo1ExceptionHandler Bugly] ";
    private static final String ONLINE_CONFIG_APP_ID = "BuglyAnalytic_AppId";
    private boolean isInitialized = false;
    private static Yodo1ExceptionHandler mHandler;

    public static Yodo1ExceptionHandler getInstance() {
        if (mHandler == null) {
            mHandler = new Yodo1ExceptionHandler();
        }
        return mHandler;
    }

    /**
     * 初始化
     */
    public void initSdk(Context context) {
        YLog.d(TAG + "initSdk called!");
        if (!isInitialized) {
            String value = Yodo1OnlineConfig.getInstance().getConfigParam(ONLINE_CONFIG_APP_ID, "");
            YLog.d(TAG + "App Id:" + value);
            if (!TextUtils.isEmpty(value)) {
                CrashReport.initCrashReport(context, value, false);
                YLog.d(TAG + "Init done. The version: " + CrashReport.getBuglyVersion(context));
                isInitialized = true;
            }
        }
    }

    public void setChannel(Context context, String channel) {
        CrashReport.setAppChannel(context, channel);
    }

    /**
     * 添加用户Userid
     */
    public void setUserId(Context context, String mUserId) {
        CrashReport.setUserId(context, mUserId);
    }

    /**
     * 添加用户超级属性
     */
    public void setUserProperties(Context context, String key, String value) {
        if (key == null || value == null) {
            return;
        }
        CrashReport.putUserData(context, key, value);
    }

    /**
     * 添加普通超级属性
     */
    public void addSuperProperties(Context context, String key, String value) {
        if (key == null || value == null) {
            return;
        }
//        CrashReport.setSdkExtraData(context, key, value);
        CrashReport.putUserData(context, key, value);
    }
}
