package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.my.target.ads.InterstitialAd;
import com.my.target.ads.MyTargetView;
import com.my.target.common.MyTargetPrivacy;
import com.my.target.common.MyTargetVersion;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author yodo1
 */
public class AdvertAdaptermytarget extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptermytarget] ";
    private static final String CHANNEL_CODE = "MyTarget";

    private static final String KEY_SLOT_BANNER = "ad_mytarget_slot_banner";
    private static final String KEY_SLOT_INTERSTITIAL = "ad_mytarget_slot_interstitial";
    private static final String KEY_SLOT_VIDEO = "ad_mytarget_slot_video";

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;

    private MyTargetView bannerAdView;
    private InterstitialAd interstitialAd;
    private InterstitialAd videoAd;

    private MyTargetView.MyTargetViewListener bannerAdListener = new MyTargetView.MyTargetViewListener() {
        @Override
        public void onLoad(MyTargetView myTargetView) {
            // The ad is successfully loaded. Start displaying ad
            YLog.d(TAG + "BannerAd onLoad");
            setBannerLoaded(true);
        }

        @Override
        public void onNoAd(String reason, MyTargetView myTargetView) {
            YLog.d(TAG + "BannerAd onNoAd, reason: " + reason);
            setBannerLoaded(false);
        }

        @Override
        public void onClick(MyTargetView myTargetView) {
            YLog.d(TAG + "BannerAd onClick");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onShow(MyTargetView myTargetView) {
            YLog.d(TAG + "BannerAd onShow");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }
    };

    private InterstitialAd.InterstitialAdListener interstitialAdListener = new InterstitialAd.InterstitialAdListener() {
        @Override
        public void onLoad(InterstitialAd ad) {
            YLog.d(TAG + "InterstitialAd onLoad");
            setInterLoaded(true);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onNoAd(String reason, InterstitialAd ad) {
            YLog.d(TAG + "InterstitialAd onNoAd, reason: " + reason);
            setInterLoaded(false);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, reason, getAdvertCode());
            }
        }

        @Override
        public void onClick(InterstitialAd ad) {
            YLog.d(TAG + "InterstitialAd onClick");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onDisplay(InterstitialAd ad) {
            YLog.d(TAG + "InterstitialAd onDisplay");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onDismiss(InterstitialAd ad) {
            YLog.d(TAG + "InterstitialAd onDismiss");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoCompleted(InterstitialAd ad) {
            YLog.d(TAG + "InterstitialAd onVideoCompleted");

        }
    };

    private InterstitialAd.InterstitialAdListener videoAdListener = new InterstitialAd.InterstitialAdListener() {
        @Override
        public void onLoad(InterstitialAd ad) {
            YLog.d(TAG + "VideoAd onLoad");
            setVideoLoaded(true);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onNoAd(String reason, InterstitialAd ad) {
            YLog.d(TAG + "VideoAd onNoAd, reason: " + reason);
            setVideoLoaded(false);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, reason, getAdvertCode());
            }
        }

        @Override
        public void onClick(InterstitialAd ad) {
            YLog.d(TAG + "VideoAd onClick");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onDisplay(InterstitialAd ad) {
            YLog.d(TAG + "VideoAd onDisplay");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onDismiss(InterstitialAd ad) {
            YLog.d(TAG + "VideoAd onDismiss");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoCompleted(InterstitialAd ad) {
            // This is used by the publisher to disburse the reward to the user
            YLog.d(TAG + "VideoAd onVideoCompleted");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };


    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return MyTargetVersion.VERSION;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (bannerAdView != null) {
            bannerAdView.destroy();
        }
    }

    @Override
    public void initSdk(Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        // Enabling debug mode
//        InterstitialAd.setDebugMode(true);

        this.updatePrivacyConsent();
        setInitialized(true);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String interstitialSlot = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_SLOT_INTERSTITIAL);
        if (TextUtils.isEmpty(interstitialSlot)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialSlot is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialSlot is null", getAdvertCode());
            return;
        }

        int slot = -1;
        try {
            slot = Integer.parseInt(interstitialSlot);
        } catch (Exception ignored) {

        }
        if (slot == -1) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialSlot is invalid, " + interstitialSlot);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialSlot is invalid", getAdvertCode());
            return;
        }
        // Create an instance of InterstitialAd
        interstitialAd = new InterstitialAd(slot, activity);
        interstitialAd.setListener(interstitialAdListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interstitialSlot: " + interstitialSlot);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);
        YLog.d(TAG + "Loading interstitial ad...");

        if (interstitialAd != null) {
            interstitialAd.show();
            setInterLoaded(false);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");

        if (interstitialAd != null) {
            interstitialAd.load();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return this.isInterLoaded();
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String videoSlot = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_SLOT_VIDEO);
        if (TextUtils.isEmpty(videoSlot)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoSlot is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoSlot is null", getAdvertCode());
            return;
        }

        int slot = -1;
        try {
            slot = Integer.parseInt(videoSlot);
        } catch (Exception ignored) {

        }
        if (slot == -1) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoSlot is invalid, " + videoSlot);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoSlot is invalid", getAdvertCode());
            return;
        }

        // Create an instance of InterstitialAd
        videoAd = new InterstitialAd(slot, activity);
        videoAd.setListener(videoAdListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, videoSlot: " + videoSlot);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setVideoCallback(callback);

        YLog.d(TAG + "Showing rewarded video ad...");
        if (videoAd != null) {
            videoAd.show();
            setVideoLoaded(false);
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent();

        if (videoAd != null) {
            videoAd.load();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return this.isVideoLoaded();
    }

    @Override
    public void initBannerAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        String bannerSlot = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_SLOT_BANNER);
        if (TextUtils.isEmpty(bannerSlot)) {
            YLog.d(TAG + "Initialize banner ad failure, bannerSlot is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "bannerSlot is null", getAdvertCode());
            return;
        }

        int slot = -1;
        try {
            slot = Integer.parseInt(bannerSlot);
        } catch (Exception ignored) {

        }
        if (slot == -1) {
            YLog.d(TAG + "Initialize banner ad failure, bannerSlot is invalid, " + bannerSlot);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "bannerSlot is invalid", getAdvertCode());
            return;
        }

        bannerAdView = new MyTargetView(activity);
        bannerAdView.init(slot);
        bannerAdView.setListener(bannerAdListener);
        bannerAdView.load();

        this.setBannerInitialized(true);
        YLog.d(TAG + "Initialize banner ad successful, bannerSlot: " + bannerSlot);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.setBannerCallback(callback);
        YLog.d(TAG + "Showing banner ad...");

        this.updatePrivacyConsent();

        if (hasLoadBanner()) {
            Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity, bannerAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d(TAG + "Hide banner ad...");
        if (bannerAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerAdView);
        }
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(TAG + "setBannerAlign, align:" + align);
    }

    @Override
    public boolean hasLoadBanner() {
        return this.isBannerLoaded();
    }

    private void updatePrivacyConsent() {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            YLog.d(TAG + "GDPR: " + privacy.isHasUserConsent() + ", COPPA: " + privacy.isAgeRestrictedUser() + ", CCPA: " + privacy.isDoNotSell());

            MyTargetPrivacy.setUserConsent(privacy.isHasUserConsent());
            MyTargetPrivacy.setUserAgeRestricted(privacy.isAgeRestrictedUser());
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
