package com.yodo1.plugin.dmp.yodo1.helper;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;

import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsConstant;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by yodo1 on 18/5/8.
 */
public class Yodo1AnalyticsManage {
    private static final String TAG = "[Yodo1AnalyticsManage] ";

    private static final int WHAT_REFRESH_DATA_IMMEDIATE = 5000;
    private static final int WHAT_REFRESH_DATA_TIMED = 5001;

    private static Yodo1AnalyticsManage instance;
    private static Yodo1AnalyticsForYodo1 helper = new Yodo1AnalyticsForYodo1();
    private static Activity mActivity;

    /**
     * 设备唯一识别码
     */
    private String deviceId;

    /**
     * sessionId 应该由客户端通过设备唯一识别码和当前时间生成以保证全局唯一
     */
    private static String sessionId;
    /**
     * 启动时间
     */
    private static long launchTime;
    /**
     * 一次APP运行的结束时间
     */
    private static long terminalTime;
    /**
     * duration为持续时间, 单位：秒
     */
    private static long duration = 0;

    private static boolean newSession = false;
    private static Timer timer, timer1;
    private static TimerTask task, task1;

    private final Handler handler = new Handler() {
        @Override
        public void handleMessage(final Message msg) {
            //线程执行内容
            switch (msg.what) {
                case WHAT_REFRESH_DATA_IMMEDIATE:
                    helper.Update(helper);
                    break;
                case WHAT_REFRESH_DATA_TIMED:
                    //每5s刷新一次数据
                    toBackRefreshDate();
                    break;
                default:
                    break;
            }
        }
    };

    private boolean isInitialized = false;

    public static Yodo1AnalyticsManage getInstance() {
        if (instance == null) {
            instance = new Yodo1AnalyticsManage();
        }
        return instance;
    }

    public void initSDK(Activity activity, String appKey) {
        YLog.d(TAG + "initSDK...");
        String isEnabled = Yodo1OnlineConfig.getInstance().getConfigParam(AnalyticsConstant.KEY_ANALYTICS_SWITCH, "on");
        if (isEnabled.equals("off")) {
            YLog.d(TAG + "Yodo1数据统计关闭");
            return;
        }

        mActivity = activity;

        deviceId = Yodo1DeviceUtils.getDeviceId(activity);
        launchTime = Yodo1CommonUtils.getUTCTime();

        //保存当前启动时 sessionId
        sessionId = generateSessionId(deviceId, launchTime + "");

        String lastSessionId = Yodo1SharedPreferences.getString(mActivity, AnalyticsConstant.KEY_SESSION_ID);
        if (TextUtils.isEmpty(lastSessionId)) {
            lastSessionId = sessionId;
        }
        String lastDuration = Yodo1SharedPreferences.getString(mActivity, AnalyticsConstant.KEY_DURATION);

        helper.initSDK(activity, appKey);
        helper.saveLaunchEvent(activity, launchTime + "", sessionId, lastSessionId, lastDuration);
        isInitialized = true;
    }

    public void onResume(final Activity activity) {
        if (!isInitialized) {
            return;
        }

        YLog.d(TAG + "onResume...");

        try {
            launchTime = Yodo1CommonUtils.getUTCTime();
            sessionId = Yodo1SharedPreferences.getString(mActivity, AnalyticsConstant.KEY_SESSION_ID);
            String t = Yodo1SharedPreferences.getString(mActivity, AnalyticsConstant.KEY_TERMINAL_TIME);
            terminalTime = Yodo1CommonUtils.getLongValues(t);
            String d = Yodo1SharedPreferences.getString(mActivity, AnalyticsConstant.KEY_DURATION);
            duration = Yodo1CommonUtils.getLongValues(d);
            final String lastTimeSessionId = sessionId;

            boolean needNewSessionId = (!TextUtils.isEmpty(sessionId) && launchTime - terminalTime > 1800000);
            YLog.d(TAG + "Need new session id: " + needNewSessionId);
            //判断sessionId是否存在
            //如果sessionId不存在，或者应用在后台时间超过30s，生成新的并保存到本地
            if (TextUtils.isEmpty(sessionId) || needNewSessionId) {
                sessionId = generateSessionId(deviceId, Yodo1CommonUtils.getUTCTime() + "");
                Yodo1SharedPreferences.put(mActivity, AnalyticsConstant.KEY_SESSION_ID, sessionId);

                final String lastDuration = Yodo1SharedPreferences.getString(mActivity, AnalyticsConstant.KEY_DURATION);
                Yodo1SharedPreferences.put(mActivity, AnalyticsConstant.KEY_DURATION, "0");
                duration = 0;

                newSession = true;
                YLog.d(TAG + "launch data duration onResume: " + lastDuration);
                //保存新建launch事件
                YLog.d(TAG + "launch data sessionId onResume: " + sessionId);

                //启动后延时1s保存launch信息    确保SDK已经初始化完成
                helper.saveLaunchEvent(activity, launchTime + "", sessionId, lastTimeSessionId, lastDuration);
            }

            startUpdate();//定时5min上报事件信息
            refreshDate();//定时5s刷新本地信息
        } catch (Exception ignored) {
        } catch (Error ignored) {
        }
    }

    public void onPause(Activity activity) {
        if (!isInitialized) {
            return;
        }

        YLog.d(TAG + "onPause...");

        toBackRefreshDate();
        closeUpdate();//关闭定时器
    }

    public void onDestroy(Activity activity) {
        if (!isInitialized) {
            return;
        }
        YLog.d(TAG + "onDestroy...");

        if (helper != null) {
            helper.onDestroy(activity);
        }
    }

    public void onEvent(final String eventId, final HashMap<String, Object> map) {
        if (!isInitialized) {
            return;
        }

        new Thread(new Runnable() {
            @Override
            public void run() {
                //线程执行内容
                Looper.prepare();
                if (helper != null) {
                    helper.onEvent(sessionId, eventId, map);
                }
                Looper.loop();
            }
        }).start();
    }

    /**
     * 生成 Session Id
     *
     * @param deviceId 设备唯一识别码
     * @param utcTime  UTC时间戳
     * @return session id
     */
    private static String generateSessionId(String deviceId, String utcTime) {
        return deviceId + utcTime;
    }

    /**
     * 本地缓存数据刷新
     */
    private static void toBackRefreshDate() {
        terminalTime = Yodo1CommonUtils.getUTCTime();

        long currentDuration = (terminalTime - launchTime) / 1000;

        launchTime = terminalTime;
        if (newSession) {
            duration = currentDuration;
            newSession = false;
        } else {
            duration = duration + currentDuration;
        }
        YLog.d(TAG + "total duration: " + duration + " seconds");

        //保存duration
        Yodo1SharedPreferences.put(mActivity, AnalyticsConstant.KEY_DURATION, String.valueOf(duration));
        //保存terminalTime
        Yodo1SharedPreferences.put(mActivity, AnalyticsConstant.KEY_TERMINAL_TIME, String.valueOf(terminalTime));
    }

    /**
     * 定时器  调用update方法
     */
    private void startUpdate() {
        task = new TimerTask() {
            @Override
            public void run() {
                Message message = new Message();
                message.what = WHAT_REFRESH_DATA_IMMEDIATE;
                handler.sendMessage(message);
                YLog.d(TAG + "发送数据");
            }
        };

        timer = new Timer();
        timer.schedule(task, 5000, AnalyticsConstant.REPORT_DATA_INTERVAL);
        YLog.d(TAG + "开启定时上传");
    }

    /**
     * 定时器 刷新数据
     */
    private void refreshDate() {
        task1 = new TimerTask() {
            @Override
            public void run() {
                Message message = new Message();
                message.what = WHAT_REFRESH_DATA_TIMED;
                handler.sendMessage(message);
            }
        };

        timer1 = new Timer();
        timer1.schedule(task1, 1000, AnalyticsConstant.REFRESH_DATA_TIME);
    }

    /**
     * 关闭定时器
     */
    private void closeUpdate() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        if (task != null) {
            task.cancel();
            task = null;
        }

        if (timer1 != null) {
            timer1.cancel();
            timer1 = null;
        }
        if (task1 != null) {
            task1.cancel();
            task1 = null;
        }
    }
}
