package com.yodo1.advert.helper;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Handler;
import android.text.TextUtils;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdEventCode;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.advert.utils.AppsflyerUtils;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsConst;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1NetWorkUtils;
import com.yodo1.sdk.kit.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.Yodo1Privacy;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/18.
 */
public class Yodo1AdvertHelper {
    private static final String TAG = "[Yodo1AdvertHelper] ";

    /**
     * 已经排序好的播放列表, 插屏用
     */
    private ArrayList<String> interstitialAdList = new ArrayList<>();
    /**
     * 按权重排序的广告实体, 插屏用
     */
    private ArrayList<AdvertBean> interstitialAdBeans = new ArrayList<>();
    /**
     * 插屏广告的播放次数
     */
    private int interstitialPlayTimes = 0;
    /**
     * 插屏广告的最后显示时间
     */
    private long interstitialShowTimes = 0;

    /**
     * 已经排序好的播放列表, 游戏视频用
     */
    private ArrayList<String> videoAdList = new ArrayList<>();
    /**
     * 按权重排序的广告实体, 游戏视频用
     */
    private ArrayList<AdvertBean> videoAdBeans = new ArrayList<>();
    /**
     * 游戏视频广告的播放次数
     */
    private int videoPlayTimes = 0;

    /**
     * 已经排序好的播放列表, banner用
     */
    private ArrayList<String> bannerAdList = new ArrayList<>();
    /**
     * 按权重排序的广告实体, banner用
     */
    private ArrayList<AdvertBean> bannerAdBeans = new ArrayList<>();
    /**
     * banner广告的播放次数
     */
    private int bannerPlayTimes = 0;

    /**
     * 已经排序好的播放列表, 原生广告用
     */
    private ArrayList<String> nativeAdList = new ArrayList<>();
    /**
     * 按权重排序的广告实体, 原生广告用
     */
    private ArrayList<AdvertBean> nativeAdBeans = new ArrayList<>();
    private int nativePlayTimes = 0;
    private long nativeShowTimes = 0;

    /**
     * 闪屏广告播放列表
     */
    private ArrayList<String> splashAdList = new ArrayList<>();
    /**
     * 开屏广告展示总次数
     */
    private int splashShowAllTimes = 0;

    private boolean initPlayList = false;
    private boolean isInitialized = false;

    private Yodo1Privacy privacy = new Yodo1Privacy();
    /**
     * 此处用来关闭延时30s发送播放成功的回调  isDismissBanner为true时ADVERT_EVENT_DISPLAY事件拦截不做处理
     */
    private boolean isDismissBanner = false;

    private Yodo1AdvertHelper() {
    }

    // 利用静态内部类特性实现外部类的单例
    private static class SingletonHolder {
        private static Yodo1AdvertHelper singleTon = new Yodo1AdvertHelper();
    }

    public static Yodo1AdvertHelper getInstance() {
        return SingletonHolder.singleTon;
    }

    public void setPrivacy(Yodo1Privacy privacy) {
        this.privacy = privacy;
    }

    public void onCreateApplication(Context context) {
        //初始化开屏
        initSplashAds(context);
    }

    public void init(final Activity activity, final String appKey) {
        if (isInitialized) {
            YLog.d(TAG + "Yodo1 Ad core has been initialized");
            return;
        }

        if (activity == null || TextUtils.isEmpty(appKey)) {
            YLog.e(TAG + "Yodo1 Ad initialization failed, activity is null or appKey is null, please check your code.");
            return;
        }

        isInitialized = true;

        String activityName = activity.getClass().getName();
        Yodo1SharedPreferences.put(activity, "YODO1_MAIN_CLASS", activityName);

        //初始化yodo1在线参数
        Yodo1OnlineConfig.getInstance().init(activity, appKey);
        Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener() {
            @Override
            public void getDataFinish(int code, String onlineConfig) {
                YLog.d(TAG + "getOnlineConfig code: " + code);

                if (TextUtils.isEmpty(onlineConfig)) {
                    YLog.d(TAG + "在线参数没拿到");
                    return;
                }

                if (YOnlineConfigUtils.isTrunOnAdForChina(activity)) {
                    YLog.v(TAG + "Yodo1 ad have been configured for simplified Chinese users only.");
                    return;
                }

                if (YOnlineConfigUtils.isNeedRequestPermisson()) {
                    YLog.v(TAG + "Yodo1 Ad will request the necessary permissions");
                    Yodo1PermissonUtils.requestPermisson(activity);//申请展示广告所需的权限
                }

                initializeAnalyticsWithPrivacy(activity, appKey);

                Yodo1ErrorUpdataHelper.getInstance().reportErrors(activity, appKey);

                //测试模式, 展示测试按钮页面
                if (YOnlineConfigUtils.isTestModule(activity) && "PA".equals(YOnlineConfigUtils.testDeviceSource(activity))) {
                    Yodo1TestHelper.showTestWindow(activity);
                }

                initializeAllPlayList(activity);
                initializeAllSdks(activity, appKey);
            }
        });
    }

    private void initializeAnalyticsWithPrivacy(Activity activity, String appKey) {
        if (privacy != null && privacy.isReportData()) {
            Yodo1Analytics.initSDK(activity, appKey);
        }
    }

    private void initializeAllPlayList(Context context) {
        if (initPlayList) {//确保广告列表只初始化一次
            YLog.d(TAG + "Yodo1 Ad list have been loaded");
            return;
        }
        initPlayList = true;

        YLog.d(TAG + "Initialize play list...");

        //100毫秒反射各广告平台
        Yodo1AdvertAdapterFactory.getInstance().initAdvertAdapters(context);

        //默认播放次数均为0
        interstitialPlayTimes = 0;
        videoPlayTimes = 0;
        bannerPlayTimes = 0;
        nativePlayTimes = 0;

        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);
        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);
    }

    private void initializeAllSdks(final Activity activity, String gameAppkey) {
        try {
//            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdInit, "", "");
//            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdInit, "", "");
//            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdInit, "", "");
//            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdInit, "", "");

            for (final Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                if (adapter.getValue() != null) {

                    if (privacy != null) {
                        adapter.getValue().setPrivacy(privacy, activity);
                    }

                    String advertCode = adapter.getValue().getAdvertCode();
                    String sdkVersion = adapter.getValue().getSDKVesion();
                    YLog.d(TAG + "[" + advertCode + "] Sdk Version: " + (TextUtils.isEmpty(sdkVersion) ? "Not fetched" : sdkVersion));

                    adapter.getValue().initSdk(activity, new Yodo1AdInitializeCallback() {
                        @Override
                        public void onInitializeSuccess(String advertCode) {
                            initializeAllAdFormats(activity, adapter.getValue(), advertCode);
                        }

                        @Override
                        public void onInitializeFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
//                            Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, );
                        }
                    });
                }
            }
        } catch (Exception e) {
            YLog.v(TAG + "initializeAllSdks exception");
        }
    }

    private void initializeAllAdFormats(final Activity activity, final AdapterAdvertBase adapterAdvertBase, final String advertCode) {
        if (interstitialAdList.contains(advertCode.toLowerCase())) {
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdInitChannel, advertCode, "");//插屏广告平台初始化统计

            adapterAdvertBase.initInterstitialAd(activity, new Yodo1AdInitializeCallback() {
                @Override
                public void onInitializeSuccess(String advertCode) {
                    reloadInterstitialAdvert(adapterAdvertBase, activity, advertCode);
                }

                @Override
                public void onInitializeFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                    Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Interstitial);
                }
            });
        }
        if (videoAdList.contains(advertCode.toLowerCase())) {
            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdInitChannel, advertCode, "");//视频广告平台初始化统计

            adapterAdvertBase.initVideoAd(activity, new Yodo1AdInitializeCallback() {
                @Override
                public void onInitializeSuccess(String advertCode) {
                    reloadVideoAdvert(adapterAdvertBase, activity, advertCode);
                }

                @Override
                public void onInitializeFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                    Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Video);
                }
            });
        }
        if (nativeAdList.contains(advertCode.toLowerCase())) {
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdInitChannel, advertCode, "");

            adapterAdvertBase.initNativeAd(activity, new Yodo1AdInitializeCallback() {
                @Override
                public void onInitializeSuccess(String advertCode) {
                    reloadNativeAdvert(adapterAdvertBase, activity, advertCode);
                }

                @Override
                public void onInitializeFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                    Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Native);
                }
            });
        }

        if (bannerAdList.contains(advertCode.toLowerCase())) {
            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdInitChannel, advertCode, "");//视频广告平台初始化统计

            adapterAdvertBase.initBannerAd(activity, new Yodo1AdInitializeCallback() {
                @Override
                public void onInitializeSuccess(String advertCode) {

                }

                @Override
                public void onInitializeFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                    Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Banner);
                }
            });
        }
    }

    /**
     * 显示插屏广告
     *
     * @param activity Activity
     * @return 是否允许显示插屏广告，当在线参数上的开关关闭，或没到时间间隔，会返回false
     */
    public boolean showInterstitialAd(final Activity activity, final InterstitialCallback callback) {
        YLog.d(TAG + "showInterstitialAd call ...");
        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", "");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Show interstitial ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }

        if (interstitialAdList.size() == 0) {
            YLog.v(TAG + "Show interstitial ad failed, ad list is empty");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        long interval = YOnlineConfigUtils.getIntervalAdvertInterstitial();
        if (System.currentTimeMillis() - interstitialShowTimes < interval) {
            YLog.v(TAG + "Show interstitial ad failed, ad interval not completed.");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }

        String firstCode = interstitialAdList.get(0);
        YLog.d(TAG + "The interstitial ads list: " + interstitialAdList.toString() + ", first ad code: " + firstCode);
        showInterstitialAdByChannel(activity, firstCode, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序

            @Override
            public void onEvent(int eventCode, String advertCode) {

                YLog.d(TAG + "showInterstitialAd onEvent, event code: " + eventCode + ", advert code: " + advertCode);
                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        sendMsg(activity, "Click", advertCode);
                        callback.onInterstitialClicked();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        sendMsg(activity, "Close", advertCode);
                        callback.onInterstitialClosed();
                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_close);
                        AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_AD_MONETIZED_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close, AppsflyerUtils.AD_TYPE_INTERSTITIAL);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        YLog.d(TAG + "Display [" + advertCode + "] interstitial ad successfully");

                        //保存当前时间用于进行显示间隔的判断
                        interstitialShowTimes = System.currentTimeMillis();
                        callback.onInterstitialShowSucceeded();

                        sendMsg(activity, "DisPlay", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_LOADED:
//                            callback.interstitialDidLoad();
                        break;
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                if (index < interstitialAdList.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = interstitialAdList.get(index);

                    YLog.d(TAG + "Show [" + advertCode + "] interstitial ad failed," + " error code:" + errorCode + ", error message: " + errorMsg + ", will try to play [" + nextCode + "] interstitial ad.");
                    showInterstitialAdByChannel(activity, nextCode, this);
                } else { //全部播放完毕, 也就是全部失败
                    // 统计失败
                    YLog.i(TAG + "No cached interstitial ads successfully");
                    Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
                    if (callback != null) {
                        callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    /**
     * 展示某家渠道的插屏广告
     *
     * @param activity   Activity
     * @param advertCode 要展示的渠道
     * @param callback   Yodo1AdCallback
     */
    private void showInterstitialAdByChannel(final Activity activity, final String advertCode, final Yodo1AdCallback callback) {
        YLog.d(TAG + "showInterstitialAdByChannel call ... advertCode:" + advertCode);

        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.v(TAG + "Try to show [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "the network adapter is not exist", advertCode);
            return;
        }

        if (!adapter.isInterInitialized()) {
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "The interstitial ad initialization is not complete", advertCode);
            return;
        }

        if (!adapter.interstitialAdvertIsLoaded(activity)) {
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "The interstitial ad has not been cached", advertCode);
            return;
        }
        try {
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowChannel, advertCode, "");

            adapter.showIntersititalAdvert(activity, new Yodo1AdCallback() {
                @Override
                public void onEvent(int eventCode, String advertCode) {
                    YLog.d(TAG + "showInterstitialAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                    callback.onEvent(eventCode, advertCode);

                    if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLOSE) {
                        YLog.d(TAG + "Show [" + advertCode + "] interstitial ad successfully, will preloading it again");

                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_close);
                        showEnd(AdvertType.Interstitial, advertCode);
                        reloadInterstitialAdvert(adapter, activity, advertCode);
                    } else if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLICK) {
                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_click);
                    }
                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    YLog.d(TAG + "showInterstitialAdByChannel onAdError, [" + advertCode + "] interstitial ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                    callback.onAdError(errorCode, errorMsg, advertCode);

                    Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_failed);
                    reloadInterstitialAdvert(adapter, activity, advertCode);
                }
            });
        } catch (Exception exception) {
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "try catch", advertCode);
        }
    }

    /**
     * 预加载回调结果
     *
     * @param adapterBase AdapterAdvertBase
     * @param activity    Activity
     */
    public void reloadInterstitialAdvert(final AdapterAdvertBase adapterBase, final Activity activity, final String advertCode) {
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Load interstitial ad failed, the network is unavailable.");
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!adapterBase.isInterInitialized()) {
                    return;
                }
                if (!adapterBase.interstitialAdvertIsLoaded(activity)) {//当本地没有缓存的时候再加载下次广告
                    YLog.d(TAG + "loading [" + advertCode + "] interstitial ad");

                    Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadChannel, advertCode, "");

                    adapterBase.reloadInterstitialAdvert(activity, new Yodo1ReloadCallback() {

                        //预加载结果的回调
                        @Override
                        public void onReloadSuccess(String advertCode) {
                            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_finish);
                            YLog.d(TAG + "Load [" + advertCode + "] interstitial ad successfully");
                        }

                        @Override
                        public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                            YLog.d(TAG + "Load [" + advertCode + "] interstitial ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);

                            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_failed);
                            Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Interstitial);
                        }
                    });
                } else {
                    YLog.d(TAG + "[" + advertCode + "] interstitial ad has been loaded, don't need to reload it again.");
                }
            }
        });
    }

    /**
     * 预加载插屏广告是否成功
     *
     * @param activity Activity
     */
    public boolean interstitialAdIsLoaded(final Activity activity) {
        if (interstitialAdList.size() == 0) {
            YLog.v(TAG + "No cached interstitial ads, ad list is empty.");
            return false;
        }

        //如果有一个加载成功即为true
        boolean isLoaded = false;
        for (int i = 0; i < interstitialAdList.size(); i++) {
            String advertCode = interstitialAdList.get(i);
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d(TAG + "Try to load [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
                continue;
            }
            if (!adapter.isInterInitialized()) {
                continue;
            }
            if (!adapter.interstitialAdvertIsLoaded(activity)) {
                YLog.d(TAG + "[" + advertCode + "] interstitial ad preloading failed, will reload it again.");
                reloadInterstitialAdvert(adapter, activity, advertCode);
                continue;
            }
            YLog.d(TAG + "[" + advertCode + "] interstitial ad has been loaded");
            isLoaded = true;
            break;
        }

        return isLoaded;
    }

    /**
     * 显示游戏视频广告
     *
     * @param activity Activity
     * @return 是否允许显示插屏广告，当在线参数上的开关关闭，或没到时间间隔，会返回false
     */
    public boolean showVideoAd(final Activity activity, final VideoCallback callback) {
        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", "");
        YLog.d(TAG + "showVideoAd call ...");

        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Show rewarded video ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }

        if (videoAdList.size() == 0) {
            YLog.v(TAG + "Show rewarded video ad failed, ads list is empty.");
            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        String firstCode = videoAdList.get(0);
        YLog.d(TAG + "The rewarded video ads list: " + videoAdList.toString() + ", first ad code: " + firstCode);
        showVideoAdByChannel(activity, firstCode, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序
            private boolean isFinish = false;

            @Override
            public void onEvent(int eventCode, final String advertCode) {
                YLog.d(TAG + "showVideoAd onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        sendMsg(activity, "Click", advertCode);
                        callback.onVideoClicked();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_FINISH:
                        isFinish = true;
//                        callback.videoDidComplete();
                        //重载
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        //当走close方法时，延时执行0.5s.等待finish回调。确保close方法一定在finish之后再调用
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                //execute the task

                                if (isFinish) {
                                    YLog.d(TAG + "Show [" + advertCode + "] rewarded video ad completely");
                                    callback.onVideoClosed(true);
                                    sendMsg(activity, "Finish", advertCode);

                                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_finish);
                                    AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_AD_MONETIZED_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_finish, AppsflyerUtils.AD_TYPE_VIDEO);
                                } else {
                                    YLog.d(TAG + "Show [" + advertCode + "] rewarded video ad incompletely, the ad is skiped");
                                    callback.onVideoClosed(false);
                                    sendMsg(activity, "Close", advertCode);

                                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_close);
                                    AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_AD_MONETIZED_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close, AppsflyerUtils.AD_TYPE_VIDEO);
                                }
                            }

                        }, 500);

                        //重载
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        YLog.d(TAG + "Display [" + advertCode + "] rewarded video ad successfully");

                        sendMsg(activity, "DisPlay", advertCode);
                        callback.onVideoShow();
                        break;
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                if (index < videoAdList.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = videoAdList.get(index);
                    YLog.d(TAG + "Show [" + advertCode + "] rewarded video ad failed, will try to play [" + nextCode + "] rewarded video ad.");
                    showVideoAdByChannel(activity, nextCode, this);
                } else { //全部播放完毕, 也就是全部失败
                    // 统计失败
                    YLog.i(TAG + "No cached rewarded video ads successfully");
                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_failed);
                    if (callback != null) {
                        callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    /**
     * 展示某家渠道的视频广告
     *
     * @param activity   Activity
     * @param advertCode 要展示的渠道
     * @param callback   Yodo1AdCallback
     */
    private void showVideoAdByChannel(final Activity activity, final String advertCode, final Yodo1AdCallback callback) {
        YLog.d(TAG + "showVideoAdByChannel call ...");

        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d(TAG + "Try to show [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "the network adapter is not exist", advertCode);
            return;
        }

        if (!adapter.isVideoInitialized()) {
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "The video ad initialization is not complete", advertCode);
            return;
        }

        if (!adapter.videoAdvertIsLoaded(activity)) {
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "The video ad has not been cached", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowChannel, advertCode, "");

                adapter.showVideoAdvert(activity, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d(TAG + "showVideoAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        callback.onEvent(eventCode, advertCode);

                        if (eventCode == Yodo1AdConst.ADVERT_EVENT_FINISH) {
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_finish);

                            showEnd(AdvertType.Video, advertCode);
                        } else if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLOSE) {
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_close);

                            YLog.d(TAG + "[" + advertCode + "] rewarded video ad has been shown, will preloading it again.");
                            reloadVideoAdvert(adapter, activity, advertCode);
                        } else if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLICK) {
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_click);
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d(TAG + "Show [" + advertCode + "] rewarded video ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        callback.onAdError(errorCode, errorMsg, advertCode);

                        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_failed);
                        reloadVideoAdvert(adapter, activity, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 预加载回调结果
     *
     * @param adapterBase AdapterAdvertBase
     * @param activity    Activity
     */
    public void reloadVideoAdvert(final AdapterAdvertBase adapterBase, final Activity activity, final String advertCode) {
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Load rewarded video ad failed, the network is unavailable.");
            return;
        }

        if (!Yodo1Advert.loadAdForTypeMobile && Yodo1NetWorkUtils.getConnectedType(activity) != ConnectivityManager.TYPE_WIFI) {
            YLog.v(TAG + "Load rewarded video ad failed, ads are no longer requested in non-wifi state.");
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!adapterBase.isVideoInitialized()) {
                    return;
                }

                if (!adapterBase.videoAdvertIsLoaded(activity)) {//当本地没有缓存的时候再加载下次广告

                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadChannel, advertCode, "");

                    adapterBase.reloadVideoAdvert(activity, new Yodo1ReloadCallback() {
                        @Override
                        public void onReloadSuccess(String advertCode) {
                            YLog.d(TAG + "Load [" + advertCode + "] rewarded video ad successfully");
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_finish);
                        }

                        @Override
                        public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                            YLog.d(TAG + "Load [" + advertCode + "] rewarded video ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);

                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_failed);
                            Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Video);
                        }
                    });
                } else {
                    YLog.d(TAG + "[" + advertCode + "] rewarded video ad has been loaded, don't need to reload it again.");
                }
            }
        });
    }

    /**
     * 预加载视频广告是否成功
     * <p>
     * 务必在视频广告展示前调用
     *
     * @param activity Activity
     */
    public boolean videoAdIsLoaded(final Activity activity) {
        YLog.d(TAG + "videoAdIsLoaded call ...");

        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "No cached rewarded video ads, the network is unavailable.");
            return false;
        }

        if (videoAdList.size() == 0) {
            YLog.v(TAG + "No cached rewarded video ads, ad list is empty.");
            return false;
        }

        //如果有一个加载成功即为true
        boolean isLoaded = false;
        for (int i = 0; i < videoAdList.size(); i++) {
            String advertCode = videoAdList.get(i);
            YLog.d(TAG + "adverts_video advertCode :  " + advertCode);
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d(TAG + "Try to load [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
                continue;
            }
            if (!adapter.isVideoInitialized()) {
                continue;
            }
            if (!adapter.videoAdvertIsLoaded(activity)) {
                YLog.d(TAG + "[" + advertCode + "] rewarded video ad preloading failed, will reload it again.");
                reloadVideoAdvert(adapter, activity, advertCode);
                continue;
            }
            YLog.d(TAG + "[" + advertCode + "] rewarded video ad has been loaded");
            isLoaded = true;
            break;
        }

        return isLoaded;
    }

    /**
     * 预加载某家渠道的视频广告
     *
     * @param activity   Activity
     * @param advertCode advertCode
     */
    private void preloadVideoAd(Activity activity, String advertCode) {
        YLog.d(TAG + "preloadVideoAd call ...");
        if (TextUtils.isEmpty(advertCode)) {
            YLog.v(TAG + "Preload rewarded video ad failed, the ad code cannot be empty.");
            return;
        }
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Preload rewarded video ad failed, the network is unavailable.");
            return;
        }

        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            reloadVideoAdvert(adapter, activity, advertCode);
        } else {
            YLog.d(TAG + "Try to preload [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
        }
    }

    /**
     * 预加载某家渠道的插屏广告
     *
     * @param activity   Activity
     * @param advertCode advert code
     */
    private void preloadInterstitialAd(Activity activity, String advertCode) {
        YLog.d(TAG + "preloadInterstitialAd call ...");
        if (TextUtils.isEmpty(advertCode)) {
            YLog.v(TAG + "Preload interstitial ad failed, the ad code cannot be empty.");
            return;
        }
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Preload interstitial ad failed, the network is unavailable.");
            return;
        }

        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            reloadInterstitialAdvert(adapter, activity, advertCode);
        } else {
            YLog.d(TAG + "Try to preload [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
        }
    }

    /**
     * 显示Banner广告
     *
     * @param activity Activity
     */
    public void SetBannerAlign(final Activity activity, final int align) {
        YLog.d(TAG + "Yodo1AdvertHelper, SetBannerAlign call ...");
        for (int i = 0; i < bannerAdList.size(); i++) {
            String advertCode = bannerAdList.get(i);//根据播放列表循环拿到advertCode
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d(TAG + "Try to set [" + advertCode + "] banner ad align failed, the network adapter is not exist.");
                continue;
            }
            if (!adapter.isBannerInitialized()) {
                continue;
            }
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    adapter.setBannerAlign(activity, align);
                }
            });
        }
    }

    /**
     * 显示Banner广告
     *
     * @param activity Activity
     */

    public void ShowBanner(final Activity activity, final BannerCallback callback) {
        YLog.d(TAG + "Yodo1AdvertHelper, showBannerAd call ...");
        HideBanner(activity);//展示广告之前首先隐藏广告
        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", "");
        isDismissBanner = false;

        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Show banner ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return;
        }

        if (bannerAdList.size() == 0) {
            YLog.v(TAG + "Show banner ad failed, ad list is empty.");
            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return;
        }

        //获取banner时间间隔
        final long interval = YOnlineConfigUtils.getSwitchingCycle();
        //统计调用

        //展示banner广告
        final String advertCode = bannerAdList.get(0);//根据播放列表拿到第一家advertCode
        YLog.d(TAG + "The banner ads list: " + bannerAdList.toString() + ", first ad code: " + advertCode);

        showBannerAdByChannel(activity, advertCode, interval, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序
            private long time = 0; //时间标记
            private boolean disPlaySuccessful = false;//标识是否播放成功过   如果曾经播放成功过  最后一家广告播放失败后重头开始播，如果没有播放成功过，播放至最后一家返回播放失败

            @Override
            public void onEvent(int eventCode, String advertCode) {
                YLog.d(TAG + "ShowBanne onEvent, event code: " + eventCode + ", ad code: " + advertCode);

                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        callback.onBannerClicked();
                        sendMsg(activity, "Click", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        callback.onBannerClosed();
                        HideBanner(activity);
                        sendMsg(activity, "Close", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAYSUCCESS://该字段用来给外部抛出回调
                        YLog.d(TAG + "Show [" + advertCode + "] banner ad successfully");

                        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", AnalyticsConst.ShowResulet_success);
                        time = System.currentTimeMillis();
                        YLog.d(TAG + "Time1 == " + time + "   " + advertCode);
                        callback.onBannerShow();
                        sendMsg(activity, "DisPlay", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY://该字段用来表示  banner展示成功之后的逻辑
                        if (isDismissBanner) {
                            YLog.d(TAG + "Banner广告隐藏或者关闭  中止循环");
                            return;
                        }

                        if (bannerAdList.size() == 1) {
                            YLog.d(TAG + "Banner列表唯一  中止循环");
                            return;
                        }
                        disPlaySuccessful = true;
                        YLog.d(TAG + "Time2 == " + System.currentTimeMillis() + "   " + advertCode);
                        YLog.d(TAG + "Time3 == " + (System.currentTimeMillis() - time) + "   " + advertCode);


                        YLog.d(TAG + "Banner正常播放  advertCode == " + advertCode);
                        String nextCode;
                        if (index < bannerAdList.size() - 1) { //播放列表还没到最后
                            //播放下一顺位的广告
                            index++;
                            nextCode = bannerAdList.get(index);
                            YLog.d(TAG + "[" + advertCode + "] banner ad has been shown, will try to play [" + nextCode + "] banner ad.");
                        } else { //全部播放完毕, 重新开始播
                            index = 0;
                            nextCode = bannerAdList.get(index);
                            YLog.d(TAG + "All banner ads are played finish, in one loop, the ad code: " + nextCode);
                        }

                        HideBanner(activity);
                        showBannerAdByChannel(activity, nextCode, interval, this);
                        break;

                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, 0, errorMsg, AdvertType.Banner);

                if (index < bannerAdList.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = bannerAdList.get(index);

                    YLog.d(TAG + "Show [" + advertCode + "] banner ad failed, will try to play [" + nextCode + "] banner ad.");
                    showBannerAdByChannel(activity, nextCode, interval, this);
                } else { //全部播放完毕, 也就是全部失败
                    YLog.d(TAG + "Show all banner ads failed...");

                    if (disPlaySuccessful) {
                        disPlaySuccessful = false;
                        index = 0;
                        String nextCode = bannerAdList.get(index);
                        HideBanner(activity);
                        YLog.d(TAG + "Will try to play [" + nextCode + "] banner ad.");
                        showBannerAdByChannel(activity, nextCode, interval, this);
                    } else {
                        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", AnalyticsConst.ShowResulet_failed);
                        callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }

        });
    }

    /**
     * 展示某家渠道的banner广告
     *
     * @param activity   Activity
     * @param advertCode 要展示的渠道
     * @param callback   Yodo1AdCallback
     */
    private void showBannerAdByChannel(final Activity activity, final String advertCode, final long interval, final Yodo1AdCallback callback) {
        YLog.d(TAG + "showBannerAdByChannel call ..." + advertCode);

        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, "");

        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d(TAG + "Try to show [" + advertCode + "] banner ad failed, the network adapter is not exist.");

            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_failed);
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "the network adapter is not exist", advertCode);
            return;
        }

        if (!adapter.isBannerInitialized()) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "The banner ad initialization is not complete", advertCode);
            return;
        }

        if (!bannerIsIsLoaded(advertCode)) {
            YLog.d(TAG + "Try to show [" + advertCode + "] banner ad failed, no cached ads.");

            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_failed);
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "no cached banner ads", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapter.showBanner(activity, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, final String advertCode) {
                        YLog.d(TAG + "onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        switch (eventCode) {
                            case Yodo1AdConst.ADVERT_EVENT_CLICK:
                                Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_click);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, advertCode);
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, advertCode);
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                                showEnd(AdvertType.Banner, advertCode);
                                Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_success);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAYSUCCESS, advertCode);

                                YLog.d(TAG + "showBannerAdByChannel 切换时间 = " + interval);
                                new Handler().postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, advertCode);
                                    }
                                }, interval);

                                break;
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d(TAG + "Show [" + advertCode + "] banner ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_failed);

                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, errorMsg, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 预加载Banner广告是否成功
     *
     * @param advertCode advert code
     */
    public boolean bannerIsIsLoaded(String advertCode) {

        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            return adapter.hasLoadBanner();
        }

        return false;
    }

    public void RemoveBanner1(Activity activity) {
        isDismissBanner = true;
        RemoveBanner(activity);
    }

    public void HideBanner1(Activity activity) {
        isDismissBanner = true;
        HideBanner(activity);
    }

    /**
     * 关闭Banner广告
     *
     * @param activity Activity
     */

    public void RemoveBanner(final Activity activity) {
        YLog.d(TAG + "removeBannerAd call ...");

        for (int i = 0; i < bannerAdList.size(); i++) {
            String advertCode = bannerAdList.get(i);//根据播放列表循环拿到advertCode
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) {
                adapter.removeBanner(activity);
            }
        }
    }

    /**
     * 隐藏Banner广告
     *
     * @param activity Activity
     */

    public void HideBanner(final Activity activity) {
        YLog.d(TAG + "HideBanner call ...");
        for (int i = 0; i < bannerAdList.size(); i++) {
            String advertCode = bannerAdList.get(i);//根据播放列表循环拿到advertCode

            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) {
                //统计调用
                adapter.hideBanner(activity);
            }
        }
    }


    /**
     * Show the native Ad, the MAS games ignore this method.
     *
     * @param activity Activity
     * @param callback The callback method of show navive ad
     * @return true, if the native ad has been shown, false otherwise.
     */
    public boolean showNativeAd(final Activity activity, final float px, final float py, final float pw, final float ph, final NativeCallback callback) {
        YLog.d(TAG + "showNative call ...");
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", "");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v(TAG + "Show native ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }

        if (nativeAdList.size() == 0) {
            YLog.v(TAG + "Show native ad failed, native ad list is null.");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        long interval = YOnlineConfigUtils.getNativeAdvertInterstitial();
        if (System.currentTimeMillis() - nativeShowTimes < interval) {
            YLog.v("Show native ad failed, ad interval not completed.");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }

        String firstCode = nativeAdList.get(0);

        YLog.d(TAG + "The native ads list: " + nativeAdList.toString() + ", first ad code: " + firstCode);
        showNativeByChannel(activity, firstCode, px, py, pw, ph, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序

            @Override
            public void onEvent(int eventCode, String advertCode) {
                YLog.d("showNativeAd onEvent, event code: " + eventCode + ", advert code: " + advertCode);

                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        sendMsg(activity, "Click", advertCode);
                        callback.onNativeClicked();
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_click);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        sendMsg(activity, "Close", advertCode);
                        callback.onNativeClosed();
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_close);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        //保存当前时间用于进行显示间隔的判断
                        nativeShowTimes = System.currentTimeMillis();
                        callback.onNativeShow();

                        YLog.d(TAG + "Display [" + advertCode + "] native(原生广告) ad successfully");
                        sendMsg(activity, "DisPlay", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_LOADED:
//                            callback.interstitialDidLoad();
                        break;
                }

            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                if (index < nativeAdList.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = nativeAdList.get(index);

                    YLog.d(TAG + "Show [" + advertCode + "] native(原生广告) ad failed, will try to play [" + nextCode + "] native ad.");
                    showNativeByChannel(activity, nextCode, px, py, pw, ph, this);
                } else { //全部播放完毕, 也就是全部失败
                    YLog.i(TAG + "No cached native ads successfully");
                    Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowChannel, "", AnalyticsConst.ShowResulet_failed);
                    if (callback != null) {
                        callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    private void showNativeByChannel(final Activity activity, final String advertCode, final float px, final float py, final float pw, final float ph, final Yodo1AdCallback callback) {

        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d(TAG + "Try to show [" + advertCode + "] native ad failed, the network adapter is not exist.");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "the network adapter is not exist", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowChannel, advertCode, "");

                adapter.showNativeAdvert(activity, px, py, pw, ph, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d(TAG + "showNativeByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        //..统计成功，点击
                        switch (eventCode) {

                            case Yodo1AdConst.ADVERT_EVENT_CLICK:
                                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_click);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, advertCode);
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_close);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, advertCode);
                                showEnd(AdvertType.Native, advertCode);
                                reloadNativeAdvert(adapter, activity, advertCode);
                                //重载
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, advertCode);
                                break;
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d(TAG + "Show [" + advertCode + "] native(原生广告) ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_failed);
                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, errorMsg, advertCode);
                        reloadNativeAdvert(adapter, activity, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 预加载广告是否成功
     *
     * @param activity Activity
     */
    public boolean nativeAdIsLoaded(final Activity activity) {
        if (nativeAdList.size() == 0) {
            YLog.v(TAG + "No cached native ads, ad list is empty.");
            return false;
        }

        //如果有一个加载成功即为true
        boolean isLoaded = false;
        for (int i = 0; i < nativeAdList.size(); i++) {
            String advertCode = nativeAdList.get(i);
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                continue;
            }
            if (adapter.nativeAdvertIsLoaded(activity)) {
                YLog.d(TAG + "[" + advertCode + "] native(原生广告) ad has been loaded, don't need to reload it again.");
                isLoaded = true;
            } else {//没有完成加载的要重新加载
                YLog.d(TAG + "[" + advertCode + "] native(原生广告) ad preloading failed, will reload it again.");
                reloadNativeAdvert(adapter, activity, advertCode);
            }
        }

        return isLoaded;
    }

    public void reloadNativeAdvert(final AdapterAdvertBase adapterBase, final Activity activity, String advertCode) {
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel, advertCode, "");
        YLog.d(TAG + "reloadNativeAdvert: " + advertCode);
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapterBase.reloadNativeAdvert(activity, new Yodo1ReloadCallback() {
                    @Override
                    public void onReloadSuccess(String advertCode) {
                        YLog.d(TAG + "Load [" + advertCode + "] native ad successfully");
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_finish);
                    }

                    @Override
                    public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                        YLog.d(TAG + "Load [" + advertCode + "] native ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);

                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_failed);
                        Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Native);
                    }
                });
            }
        });
    }

    /**
     * 移除原生广告
     *
     * @param activity Activity
     */
    public void removeNativeAd(final Activity activity) {
        for (int i = 0; i < nativeAdList.size(); i++) {
            String advertCode = nativeAdList.get(i);//根据播放列表循环拿到advertCode
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) {
                adapter.removeNativeAdvert(activity);
            }
        }
    }


    /**
     * 初始化闪屏广告
     */
    private void initSplashAds(final Context activity) {
        if (!YOnlineConfigUtils.isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd)) {
            YLog.d(TAG + "Init splash ad failed, the switch is trun off.");
            return;
        }

        List<AdsConfigEntity> adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
        //移除没有对应adapter的AdsConfigEntity
        for (int i = adList.size() - 1; i >= 0; i--) {
            String advertCode = adList.get(i).getAdvertCode();
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                adList.remove(i);
            }
        }

        if (adList.size() == 0) {
            YLog.d(TAG + "Init splash ad failed, SplashAdControl is empty.");
            return;
        }

        int save_time = Yodo1SharedPreferences.getInt(activity, "Platform_SplashAdShowFirstTimes") + 1;//当前游戏启动次数
        String showFirstTime = Yodo1OnlineConfig.getInstance().getConfigParam("Platform_SplashAdShowFirstTimes", "1");
        int time = Integer.valueOf(showFirstTime);
        Yodo1SharedPreferences.put(activity, "Platform_SplashAdShowFirstTimes", save_time);//将当前启动次数保存到本地
        if (time > save_time) {
            YLog.d(TAG + "第" + time + "次启动开始展示开屏广告");
            return;
        }

        List<String> priorityList = new ArrayList<>();//优先播放的广告列表
        List<String> behindList = new ArrayList<>();//播放级别较低的广告列表
        splashShowAllTimes = Yodo1SharedPreferences.getInt(activity, "Platform_SplashAdShowAllTimes");//开屏广告展示总次数
        int splash_total = 0;//需要计算的开屏广告展示总数（用来计算开屏广告展示比例）
        for (int i = 0; i < adList.size(); i++) {
            int showTimes = Integer.valueOf(adList.get(i).getRatio());
            splash_total = splash_total + showTimes;
        }
        //闪屏广告播放计算
        for (int i = 0; i < adList.size(); i++) {
            if (splashShowAllTimes == 0) {//开屏从未展示过 直接读取到的数据添加进广告列表
                priorityList.add(adList.get(i).getAdvertCode());
            } else {
                String adCode = adList.get(i).getAdvertCode();
                int showTimes_local = Yodo1SharedPreferences.getInt(activity, adList.get(i).getAdvertCode().toLowerCase());//某一家广告的展示次数
                float ratio_local = (float) showTimes_local / splashShowAllTimes;//获取当前这个广告的播放比例

                int showTimes_online = Integer.valueOf(adList.get(i).getRatio());
                float ratio_online = (float) showTimes_online / splash_total;//获取理论上广告播放比例

                if (ratio_local < ratio_online) {
                    priorityList.add(adCode);
                } else {
                    behindList.add(adCode);
                }
            }
        }
        splashAdList.addAll(priorityList);
        splashAdList.addAll(behindList);

        YLog.d(TAG + "The Splash ads list: " + splashAdList.toString());
    }

    /**
     * 显示splash广告
     *
     * @param activity Activity
     * @return 是否允许显示splash广告
     */

    public boolean showSplashAd(final Activity activity, final SplashCallback callback) {
        YLog.d(TAG + "showSplashAd call ...");
        if (splashAdList.size() == 0) {
            YLog.v(TAG + "Show splash ads is failed, ad list is empty.");
            callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        String advertCode = splashAdList.get(0);
        YLog.d(TAG + "showSplashAdByChannel: " + advertCode);
        showSplashAdByChannel(activity, advertCode, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序

            @Override
            public void onEvent(int eventCode, String advertCode) {
                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        callback.onSplashClicked();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        callback.onSplashClosed();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        YLog.d(TAG + "Show [" + advertCode + "] Splash ad successfully");
                        callback.onSplashShow();

                        //保存当前时间用于进行显示间隔的判断
                        int showTimes_local = Yodo1SharedPreferences.getInt(activity, advertCode.toLowerCase());//某一家广告的展示次数
                        Yodo1SharedPreferences.put(activity, advertCode.toLowerCase(), showTimes_local + 1);//保存当前广告的展示次数
                        Yodo1SharedPreferences.put(activity, "Platform_SplashAdShowAllTimes", splashShowAllTimes + 1);//保存当前展示次数
                        break;

                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                Yodo1ErrorUpdataHelper.getInstance().errorCollection(activity, advertCode, errorCode, 0, errorMsg, AdvertType.Splash);

                if (index < splashAdList.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;

                    String nextCode = splashAdList.get(index);
                    YLog.d(TAG + "Show [" + advertCode + "] Splash ad failed, will try to play [" + nextCode + "] interstitial ad.");

                    showSplashAdByChannel(activity, nextCode, this);
                } else { //全部播放完毕, 也就是全部失败
                    YLog.d(TAG + "Show all Splash ads failed...");
                    callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                }
            }
        });

        return true;
    }

    /**
     * 展示某家渠道的开屏广告
     *
     * @param activity   Activity
     * @param advertCode 要展示的渠道
     * @param callback   Yodo1AdCallback
     */
    private void showSplashAdByChannel(final Activity activity, final String advertCode, final Yodo1AdCallback callback) {
        YLog.d(TAG + "showInterstitialAdByChannel call ...");
        //统计调用
        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d(TAG + "Try to show [" + advertCode + "] splash ad failed, the network adapter is not exist.");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "the network adapter is not exist", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapter.showSplashAdvert(activity, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d(TAG + "showSplashAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        callback.onEvent(eventCode, advertCode);
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d(TAG + "Show [" + advertCode + "] splash ad failed, ErrorCode " + errorCode + ", ErrorMessage: " + errorMsg);
                        callback.onAdError(errorCode, errorMsg, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 播放完毕
     *
     * @param advertType 广告类型(插屏、视频等)
     * @param adCode     advert code
     */
    private void showEnd(AdvertType advertType, String adCode) {
        YLog.d(TAG + "showEnd call ...");
        String advertCode = adCode.toLowerCase();
        if (advertType == AdvertType.Interstitial) {
            interstitialPlayTimes++;
            YLog.d(TAG + "Interstitial总共播放了" + interstitialPlayTimes + "次");
            for (int i = 0; i < interstitialAdBeans.size(); i++) {
                if (!TextUtils.isEmpty(interstitialAdBeans.get(i).advertCode)) {
                    if (interstitialAdBeans.get(i).advertCode.equals(advertCode)) {
                        interstitialAdBeans.get(i).playedTimes++;
                        YLog.d(TAG + "当前[" + advertCode + "]播放了" + interstitialAdBeans.get(i).playedTimes + "次");
                    }
                }
            }
            sortAdvert(interstitialAdBeans, interstitialAdList, interstitialPlayTimes); //重排序
        } else if (advertType == AdvertType.Video) {
            videoPlayTimes++;
            YLog.d(TAG + "Video总共播放了" + videoPlayTimes + "次");
            for (int i = 0; i < videoAdBeans.size(); i++) {
                if (!TextUtils.isEmpty(videoAdBeans.get(i).advertCode)) {
                    if (videoAdBeans.get(i).advertCode.equals(advertCode)) {
                        videoAdBeans.get(i).playedTimes++;
                        YLog.d(TAG + "当前[" + advertCode + "]播放了" + videoAdBeans.get(i).playedTimes + "次");
                    }
                }
            }
            sortAdvert(videoAdBeans, videoAdList, videoPlayTimes); //重排序
        } else if (advertType == AdvertType.Banner) {
            bannerPlayTimes++;
            YLog.d(TAG + "Banner总共播放了" + bannerPlayTimes + "次");
            for (int i = 0; i < bannerAdBeans.size(); i++) {
                if (bannerAdBeans.get(i).advertCode.equals(advertCode)) {
                    bannerAdBeans.get(i).playedTimes++;
                    YLog.d(TAG + "当前[" + advertCode + "]播放了" + bannerAdBeans.get(i).playedTimes + "次");
                }
            }
            sortAdvert(bannerAdBeans, bannerAdList, bannerPlayTimes); //重排序
        } else if (advertType == AdvertType.Native) {
            nativePlayTimes++;
            YLog.d(TAG + "Native总共播放了" + nativePlayTimes + "次");
            for (int i = 0; i < nativeAdBeans.size(); i++) {
                if (nativeAdBeans.get(i).advertCode.equals(advertCode)) {
                    nativeAdBeans.get(i).playedTimes++;
                    YLog.d(TAG + "当前[" + advertCode + "]播放了" + nativeAdBeans.get(i).playedTimes + "次");
                }
            }
            sortAdvert(nativeAdBeans, nativeAdList, nativePlayTimes); //重排序
        }
    }

    /**
     * 根据权重与播放次数排序
     *
     * @param advertsLst 存放广告数据实体（权重和百分比等）的集合
     * @param playList   播放列表
     */
    private void sortAdvert(ArrayList<AdvertBean> advertsLst, ArrayList<String> playList, int playtimes) {
        YLog.d(TAG + "sortAdvert call ...");
        //清空播放列表
        if (playList != null) {
            playList.clear();
        } else {
            playList = new ArrayList<>();
        }
        List<String> overAdvert = new ArrayList<>(); //存储已经超过播放百分比或者的广告渠道
        List<String> overMaxAdvert = new ArrayList<>(); //存储已经超过最大播放次数的广告渠道
        List<AdvertBean> fixAdvert = new ArrayList<>(); //存储播放比例不为-1的广告渠道  放置在广告列表最后 按照比例计算播放列表 （-1表示优先展示的广告渠道）

        for (int i = 0; i < advertsLst.size(); i++) {
            AdvertBean bean = advertsLst.get(i);
            YLog.d(TAG + bean.advertCode + "   播放次数为 : " + bean.playedTimes);
            YLog.d(TAG + bean.advertCode + "   最大播放次数为 : " + bean.maxPlayedTimes);

            if (bean.maxPlayedTimes != -1 && bean.playedTimes >= bean.maxPlayedTimes) {//maxPlayeTimes = -1 表示展示次数无穷大
                overMaxAdvert.add(bean.advertCode); //筛选出播放次数超过最大播放次数的广告  放在队尾  不参与计算
                YLog.d(TAG + bean.advertCode + " 已播放至最大播放次数  播放次数为 : " + bean.maxPlayedTimes);
            } else {
                if (bean.percentage == 0) { //区分广告播放比例为0的放在队首，按照在线参数获取到的顺序排列。播放顺序固定   不为-1的放在队尾，按照播放比例计算
                    playList.add(bean.advertCode);
                    YLog.d(TAG + bean.advertCode + " 放入对首 ");
                } else {
                    YLog.d(TAG + bean.advertCode + " 需进入排序队列 ");
                    fixAdvert.add(bean);
                }
            }
        }

        //广告播放比例计算
        for (int i = 0; i < fixAdvert.size(); i++) {
            AdvertBean bean = fixAdvert.get(i);
            float percentage_played = (float) bean.playedTimes / playtimes; //算出这个渠道的已播放量百分比
            YLog.d(TAG + bean.advertCode + " percentage_played : " + percentage_played);
            YLog.d(TAG + bean.advertCode + " bean.percentage : " + bean.percentage);
            if (percentage_played < bean.percentage) { //说明播放量还没有超标
                playList.add(bean.advertCode);
            } else { //播放量超标，先加入到超标集合中等待最后合并
                overAdvert.add(bean.advertCode);
            }
        }


        //将播放比例超标集合添加到播放列表队尾
        if (overAdvert.size() > 0) {
            playList.addAll(overAdvert);
        }
        //将播放播放次数超过最大播放次数的集合添加到播放列表队尾
        if (overMaxAdvert.size() > 0) {
            YLog.d(TAG + "超过最大播放次数的广告列表 : " + overMaxAdvert.toString());
        }

        YLog.d(TAG + "排序后 playList : " + playList.toString());
    }


    /**
     * 初始化广告属性列表与播放列表，初始按权重排序
     *
     * @param context    Context
     * @param advertType 广告类型
     */
    private void initAdvertList(Context context, Yodo1OnlineConfigAgent.AdvertType advertType) {
        YLog.d(TAG + "initAdvertList call ...");
        if (!YOnlineConfigUtils.isTrunOnYodo1Ads(advertType)) {
            YLog.v(TAG + "Initialize " + (advertType + "").replace("Platform_", "") + " failed, the switch is turn off.");
            return;
        }

        List<AdsConfigEntity> adList = Yodo1OnlineConfigAgent.getAdsControl(advertType);

        //移除没有对应adapter的AdsConfigEntity
        for (int i = adList.size() - 1; i >= 0; i--) {
            String advertCode = adList.get(i).getAdvertCode();
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                adList.remove(i);
            }
        }

        //根据广告类型决定使用哪个ArrayList
        ArrayList<AdvertBean> advertBeans;
        ArrayList<String> advertPlayList;
        switch (advertType) {
            case Platform_InterstitialAd:
                advertBeans = interstitialAdBeans;
                advertPlayList = interstitialAdList;
                break;
            case Platform_VideoAd:
                advertBeans = videoAdBeans;
                advertPlayList = videoAdList;
                break;
            case Platform_BannerAd:
                advertBeans = bannerAdBeans;
                advertPlayList = bannerAdList;
                break;
            case Platform_NativeAd:
                advertBeans = nativeAdBeans;
                advertPlayList = nativeAdList;
                break;
            default:
                YLog.v(TAG + "初始化播放列表异常， 传入的AdvertType不正确, advertType: " + advertType);
                return;
        }

        if (YOnlineConfigUtils.isTestModule(context) && YOnlineConfigUtils.isEmptyTestAdList()) {
            AdvertBean bean = new AdvertBean();
            bean.advertCode = "yodo1";
            bean.weight = 1;
            bean.maxPlayedTimes = -1;//获取最大播放数
            advertPlayList.add(bean.advertCode);
            YLog.d(TAG + "初始化 Test Mode [" + advertType + "]播放列表：" + advertPlayList.toString());
            advertBeans.add(bean);
            return;
        }

        //算出播放百分比总数
        float total = 0;
        for (int i = 0; i < adList.size(); i++) {
            String ratio = adList.get(i).getRatio();
            if (!TextUtils.isEmpty(ratio) && !"-1".equals(ratio)) {
                total += Float.valueOf(ratio);
            }

        }
        for (int i = 0; i < adList.size(); i++) {
            //实例化所有在权重列表中要播放的广告
            //并且根据总比例算出播放百分比
            AdvertBean bean = new AdvertBean();
            bean.advertCode = adList.get(i).getAdvertCode();
            bean.weight = i + 1;
            //获取最大播放数
            bean.maxPlayedTimes = Integer.valueOf(adList.get(i).getMaxShowTimes());

            float ratio = Float.valueOf(adList.get(i).getRatio());
            if (ratio != -1) {
                bean.percentage = ratio / total;
                YLog.d(TAG + "ratio: " + ratio + ", total: " + total);
            } else {
                bean.percentage = -1;
            }
            YLog.d(TAG + "bean: " + bean.advertCode + ", percentage: " + bean.percentage);

            advertBeans.add(bean);

            advertPlayList.add(advertBeans.get(i).advertCode); //初始化播放列表，默认就按权重播不考虑百分比
            YLog.d(TAG + "初始化[" + advertType + "]播放列表, 序列" + (i + 1) + ":" + advertPlayList.get(i));
        }
        YLog.d(TAG + "初始化[" + advertType + "]播放列表：" + advertPlayList.toString());

    }

    /**
     * 事件发生时发送广播
     */
    private void sendMsg(Context context, String event, String advertCode) {

    }

    public class AdvertBean {
        /**
         * 代表哪家广告平台
         */
        String advertCode;
        /**
         * 权重,从1开始
         */
        int weight;
        /**
         * 所占的播放百分比
         */
        float percentage;
        /**
         * 已播放的次数
         */
        int playedTimes = 0;
        /**
         * 最大播放次数
         */
        int maxPlayedTimes;
    }
}
