package com.yodo1.plugin.dmp.yodo1.db;


import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.yodo1.sdk.kit.SysUtils;

import java.io.File;

public class Yodo1DBUtil extends SQLiteOpenHelper {
    private static boolean mainTmpDirSet = false;
    private static final String DATABASE_NAME = "Yodo1DB.db";  //数据库名
    private static final int DATABASE_VERSION = 1;               //数据库版本号
    private String tableName;
    private Context context;
    public Yodo1DBUtil(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    public Yodo1DBUtil(Context context, String tableName) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        this.tableName = tableName;
        this.context = context;
    }


    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        createTable(sqLiteDatabase);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }
    @Override
    public SQLiteDatabase getReadableDatabase() {
        if (!mainTmpDirSet) {
            String applicationid = SysUtils.getPackageName(context);
            String directory_path = "/data/data/"+applicationid +"/databases/main";
            boolean rs = new File(directory_path).mkdir();
            Log.d("Yodo1DBUtil", rs + "");
            String pragma = "PRAGMA temp_store_directory = '/data/data/"+ directory_path+"/databases/main'";
            super.getReadableDatabase().execSQL(pragma);
            mainTmpDirSet = true;
            return super.getReadableDatabase();
        }
        return super.getReadableDatabase();
    }

    /**
     * 建立数据表
     * */
    private void createTable(SQLiteDatabase db){
        db.execSQL("create table " + tableName + "(" +
                "sessionid text," +
                "timestamp text," +
                "eventid text," +
                "event_data text," +
                "channel text," +
                "client_version text," +
                "event_type text," +
                "network text," +
                "device_id text," +
                "terminal text," +
                "bundle_id text," +
                "device_name text," +
                "phone_version text," +
                "os_version text," +
                "os text)");
    }

}
