package com.yodo1.advert.adapter.kit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;

import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.download.DownloadRequest;
import com.yodo1.nohttp.download.SimpleDownloadListener;
import com.yodo1.nohttp.download.SyncDownloadExecutor;
import com.yodo1.sdk.kit.YLog;

public class Yodo1VideoAds {

    public static Yodo1VideoCallback yodo1VideoCallback;
    private static boolean isVideoLoded = false;
    private static boolean isDownloading=false;
    public static void setYodo1VideoCallback(Yodo1VideoCallback callback) {
        yodo1VideoCallback = callback;
    }

    /**
     * 展示视频广告
     *
     * @param activity
     */
    public static void showVideoAds(Activity activity) {

        Intent intent = new Intent(activity, Yodo1VPActivity.class);
        intent.putExtra("orientation", activity.getResources().getConfiguration().orientation);
        activity.startActivity(intent);
    }

    /**
     * 是否缓存完成广告
     *
     * @return
     */
    public static boolean isReady() {
        return isVideoLoded;
    }

    /**
     * 缓存测试广告
     *
     * @param context
     */
    public static void loadYodo1Video(final Context context) {

        if (isVideoLoded) {
            YLog.d("Yodo1VideoAd  本地已有缓存的广告，忽略本次下载");
            return;
        }

        if(!isDownloading){
            isDownloading=true;

            new Thread(new Runnable() {
                @Override
                public void run() {
                    String url = "https://bj-ali-ops-sdk-docs.oss-cn-beijing.aliyuncs.com/media/ad-test-resource/ad-video-landscape.mp4";
                    if (context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
                        url = "https://bj-ali-ops-sdk-docs.oss-cn-beijing.aliyuncs.com/media/ad-test-resource/ad-video-portrait.mp4";
                    }

                    DownloadRequest request = new DownloadRequest(url, RequestMethod.GET, context.getCacheDir().getAbsolutePath(), "local_video.mp4", true, true);
                    SyncDownloadExecutor.INSTANCE.execute(0, request, new SimpleDownloadListener() {
                        @Override
                        public void onStart(int what, boolean resume, long range, Headers headers, long size) {
                            // 开始下载，回调的时候说明文件开始下载了。
                            // 参数1：what。
                            // 参数2：是否是断点续传，从中间开始下载的。
                            // 参数3：如果是断点续传，这个参数非0，表示之前已经下载的文件大小。
                            // 参数4：服务器响应头。
                            // 参数5：文件总大小，可能为0，因为服务器可能不返回文件大小。

                        }

                        @Override
                        public void onProgress(int what, int progress, long fileCount, long speed) {
                            // 进度发生变化，服务器不返回文件总大小时不回调，因为没法计算进度。
                            // 参数1：what。
                            // 参数2：进度，[0-100]。
                            // 参数3：文件总大小，可能为0，因为服务器可能不返回文件大小。
                            // 参数4：下载的速度，含义为1S下载的byte大小，计算下载速度时：
                            //        int xKB = (int) speed / 1024; // 单位：xKB/S
                            //        int xM = (int) speed / 1024 / 1024; // 单位：xM/S

                        }

                        @Override
                        public void onFinish(int what, String filePath) {
                            // 下载完成，参数2为保存在本地的文件路径。
                            YLog.d("Yodo1VideoAd  下载完成 ： " + filePath+"   完成时间 ： "+System.currentTimeMillis());
                            isVideoLoded = true;
                        }

                        @Override
                        public void onCancel(int what) {
                            super.onCancel(what);
                            isDownloading=false;
                        }

                        @Override
                        public void onDownloadError(int what, Exception exception) {
                            super.onDownloadError(what, exception);
                            isDownloading=false;
                        }

                    });
                }
            }).start();
        }


    }

}
