package com.yodo1.plugin.dmp.yodo1.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhuxc on 2018/10/16.
 */

public class Yodo1UtilDao {
    private Yodo1DBUtil du;
    private SQLiteDatabase db;

    private String tableName = "Yodo1AnalyticsDB";


    public Yodo1UtilDao(Context context){
        du = new Yodo1DBUtil(context,tableName);
        db = du.getWritableDatabase();
    }


    // 获取行数
    public long getLines() {
        Cursor cursor = db.rawQuery("select count(*) from "+tableName, null);
        cursor.moveToFirst();
        long count = cursor.getLong(0);
        cursor.close();
        return count;

    }


    // 添加联系人
    public void add( AnalyticsInfo info) {
        try {
            db.execSQL("insert into " + tableName + " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                    new Object[] {info.getSessionid(), info.getTimestamp(),
                            info.getEventid(), info.getEvent_data(), info.getChannel(),
                            info.getClient_version(), info.getEvent_type(), info.getNetwork(),
                            info.getDevice_id(), info.getTerminal(), info.getBundle_id(),
                            info.getDevice_name(), info.getPhone_version(), info.getOs_version(),
                            info.getOs()
                    });
        }catch (Exception e){}

    }


    // 修改联系人
    public void update(AnalyticsInfo info) {
        try {
            db.execSQL("update " + tableName + " set sessionid=?,timestamp=?,eventid=?,event_data=?," +
                            "channel=?,client_version=?,event_type=?,network=?,device_id=?," +
                            "terminal=?,bundle_id=?,device_name=?,phone_version=?,os_version=?,os=? where _id=?",
                    new Object[] {info.getSessionid(), info.getTimestamp(),
                            info.getEventid(), info.getEvent_data(), info.getChannel(),
                            info.getClient_version(), info.getEvent_type(), info.getNetwork(),
                            info.getDevice_id(), info.getTerminal(), info.getBundle_id(),
                            info.getDevice_name(), info.getPhone_version(), info.getOs_version(),
                            info.getOs()
                    });
        }catch (Exception e){}

    }

    // 删除联系人
    public void delete(String name) {
        try {
            db.execSQL("delete from " + tableName + "  where name=?", new String[] { name });
        }catch (Exception e){}

    }

    // 删除所有数据
    public void deleteALL() {
        try {
            db.execSQL("delete from " + tableName);
        }catch (Exception e){}

    }


    // 查询单条
    public AnalyticsInfo queryOne(String name) {
        AnalyticsInfo info = new AnalyticsInfo();
        try {
            Cursor c = db.rawQuery("select * from " + tableName + " where name= ?", new String[] { name });
            while (c.moveToNext()) {
                info.setSessionid(c.getString(0));
                info.setTimestamp(c.getString(1));
                info.setEventid(c.getString(2));
                info.setEvent_data(c.getString(3));
                info.setChannel(c.getString(4));
                info.setClient_version(c.getString(5));
                info.setEvent_type(c.getString(6));
                info.setNetwork(c.getString(7));
                info.setDevice_id(c.getString(8));
                info.setTerminal(c.getString(9));
                info.setBundle_id(c.getString(10));
                info.setDevice_name(c.getString(11));
                info.setPhone_version(c.getString(12));
                info.setOs_version(c.getString(13));
                info.setOs(c.getString(14));
            }
            c.close();
        }catch (Exception e){}


        return info;
    }

    /**
     * 查询全部
     * @return
     */
    public List<AnalyticsInfo> queryAllAnalyticsInfo() {
        ArrayList<AnalyticsInfo> infos = new ArrayList<AnalyticsInfo>();
        try {

            Cursor c = db.rawQuery("select * from " + tableName , null);
            while (c.moveToNext()) {
                AnalyticsInfo info = new AnalyticsInfo();
                info.setSessionid(c.getString(0));
                info.setTimestamp(c.getString(1));
                info.setEventid(c.getString(2));
                info.setEvent_data(c.getString(3));
                info.setChannel(c.getString(4));
                info.setClient_version(c.getString(5));
                info.setEvent_type(c.getString(6));
                info.setNetwork(c.getString(7));
                info.setDevice_id(c.getString(8));
                info.setTerminal(c.getString(9));
                info.setBundle_id(c.getString(10));
                info.setDevice_name(c.getString(11));
                info.setPhone_version(c.getString(12));
                info.setOs_version(c.getString(13));
                info.setOs(c.getString(14));
                infos.add(info);
            }
            c.close();
        }catch (Exception e){}

        return infos;
    }

    /**
     * 关闭数据库连接
     * */
    public void getClose(){
        if(db != null){
            db.close();
        }
    }
}