package com.yodo1.advert.factory;

import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;

import java.util.Map;

/**
 * @author zhuxc
 */
public class Yodo1AdvertProvider extends ContentProvider {
    private static final String TAG = "[Yodo1AdvertProvider] ";

    private Yodo1AdvertActivityObserver lifecycle;

    @Override
    public boolean onCreate() {
        Log.d("yodo1-games-sdk", TAG + "onCreate");

        String str = YFileUtils.readFilesFromSDCard(".yodo1ads");
        if (!TextUtils.isEmpty(str) && str.contains("openYodo1Log")) {
            YLog.setDebugMode(true);
            YLog.setOnLog(true);
            YLog.v(TAG + "开启Yodo1Log，打开测试模式");
        }

        String ySdkLog = Yodo1CommonUtils.getMetedataStr(this.getContext(), "Y_SDK_LOG");
        if (ySdkLog.equals("true")) {
            YLog.setDebugMode(true);
            YLog.setOnLog(true);
            YLog.v(TAG + "开启Yodo1Log，打开测试模式");
        }

        registerLifecycle((Application) getContext());

        String processName = SysUtils.getProcessName(getContext(), android.os.Process.myPid());
        //判断是否为当前主进程，以防有多进程造成重复初始化
        if (getContext().getPackageName().equals(processName)) {
            if (Yodo1OnlineConfig.getInstance().hasData()) {

                //加载广告插件
                Yodo1AdvertAdapterFactory.getInstance().initAdvertAdapters(getContext());
                //广告Application初始化
                for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                    if (adapter.getValue() != null) {
                        adapter.getValue().onCreateApplication((Application) getContext());


                    }
                }
                Yodo1AdvertHelper.getInstance().onCreateApplication(getContext());
            }
        }

        return true;
    }

    private void registerLifecycle(Application context) {
        if (null != lifecycle) {
            context.unregisterActivityLifecycleCallbacks(lifecycle);
        }
        lifecycle = new Yodo1AdvertActivityObserver();
        context.registerActivityLifecycleCallbacks(lifecycle);
    }


    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] strings, @Nullable String s, @Nullable String[] strings1, @Nullable String s1) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }


    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues contentValues) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String s, @Nullable String[] strings) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues contentValues, @Nullable String s, @Nullable String[] strings) {
        return 0;
    }
}
