package com.yodo1.advert.factory;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;

/**
 * @author yodo1
 */
public class Yodo1AdvertActivityObserver implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "[Yodo1AdvertActivityObserver] ";

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        YLog.d(TAG + "onActivityCreated");

        Yodo1HttpManage.getInstance().initHttp(activity);
        Yodo1OnlineConfig.getInstance().initConfig(activity);

        //1: 当前是游戏主Activity  2: 开屏广告已打开
        boolean splashAdSwitch = YOnlineConfigUtils.isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
        YLog.d(TAG + "onActivityCreated, SplashAd switch = " + splashAdSwitch);
        if (splashAdSwitch) {
            Intent intent = new Intent(activity, Yodo1SplashAdActivity.class);
            activity.startActivity(intent);
        }

        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() != null) {
                adapter.getValue().onCreate(activity);
            }
        }
    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {
        YLog.d(TAG + "onActivityResumed");
        Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener() {
            @Override
            public void getDataFinish(int code, String onlineConfig) {

            }
        });
        if (Yodo1OnlineConfig.getInstance().hasData()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onResume(activity);
                }
            }
            Yodo1Analytics.onResume(activity);
        }
    }

    @Override
    public void onActivityPaused(Activity activity) {
        YLog.d(TAG + "onActivityPaused");
        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() != null) {
                adapter.getValue().onPause(activity);
            }
        }

        Yodo1Analytics.onPause(activity);
    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        YLog.d(TAG + "onActivityDestroyed");
        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() != null) {
                adapter.getValue().onDestroy(activity);
            }
        }

        Yodo1Analytics.onDestroy(activity);
        Yodo1HttpManage.getInstance().onDestroy();
        Yodo1OnlineConfig.getInstance().onDestroy();
    }
}
