package com.yodo1.onlineconfig;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.os.Looper;
import android.text.TextUtils;

import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by yodo1 on 2017/8/7.
 */

public class Yodo1OnlineConfig {
    private static final String TAG = "[Yodo1OnlineConfig] ";

    public static final String ONLINECONFIG_ACTION = "cn.yodo1.broadcastreceiverregister.OnlineConfig";
    public static final String ENV_BUILD_PRODUCTION = "product"; //正式环境
    public static final String ENV_BUILD_TEST = "test"; //测试环境

    private static final String KEY_CACHE_FILE_JSON = "onlineconfig";

    private static final String URL_ONLINECONFIG_PRODUCT = "https://olc.yodo1api.com/config/getDataV2/";
    private static final String URL_ONLINECONFIG_TEST = "http://olc-test.yodo1.int:8080/config/getDataV2";
    private static final String URL_ONLINECONFIG_CDN = "https://ocd.yodo1api.com/configfiles/";
    private static final String KEY_DATA_IDENTIFER = "data_identifer";
    private static final String KEY_LOCATION_IDENTIFER = "location_identifer";
    private static final String KEY_LOCATION_IDENTIFER_TTL = "location_identifer_ttl";
    private static final String KEY_GAME_APPK = "game_appkey";
    private static final String KEY_GAME_CHANNEL_CODE = "game_channelcode";
    private static final String KEY_GAME_VERSION_NAME = "game_version";
    private static final String KEY_GAME_PACKAGE_NAME = "game_packagename";
    private static final String KEY_TIMESTAMP_GETDATA = "timestamp_getdata";
    //    private static final String KEY_ONLINECONFIG = "OnlineConfigParams";

    private static final String KEY_ONLINECONFIG_TEST_INFO = "OnlineConfigParams_TestInfo";
    private static final String KEY_ONLINECONFIG_TESTDEVICE = "OnlineConfigParams_TestDevice";
    private static final String KEY_ONLINECONFIG_TESTDEVICE_SOURCE = "OnlineConfigParams_TestDeviceSource";

    private static String buildCode = ENV_BUILD_PRODUCTION;

    public static String ChannelCode = "";
    public static String SDKVersion = "";
    public static String SDKTyoe = "";

    private static String appKey, appPackageName, appVersionName;

    private static long time = 0;
    private static Context context;
    //地理标识
    private static String location_lng = "";//手机当前经度，保留小数点后两位
    private static String location_lat = "";//手机当前纬度，保留小数点后两位
    private static volatile Yodo1OnlineConfig instance;
    public JSONObject dataObj = null;
    public JSONObject testObj = null;

    private boolean initialized = false;

    private Yodo1OnlineConfig() {

    }

    public static Yodo1OnlineConfig getInstance() {
        if (instance == null) {
            synchronized (Yodo1OnlineConfig.class) {
                if (instance == null) {
                    instance = new Yodo1OnlineConfig();
                }
            }
        }
        return instance;
    }

    public void setBuildCode(String buildCode) {
        Yodo1OnlineConfig.buildCode = buildCode;
    }

    private String getOnlineConfigUrl() {
        if (!TextUtils.isEmpty(buildCode) && buildCode.equals(ENV_BUILD_TEST)) {
            return URL_ONLINECONFIG_TEST;
        }
        return URL_ONLINECONFIG_PRODUCT;
    }

    /**
     * 根据接口获取在线参数
     *
     * @param listener 回调
     */
    private void getOnlineConfig(final Yodo1RequestListener listener) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                //首先获取设备ID
                Looper.prepare();

                try {
                    String deviceId = Yodo1DeviceUtils.getGoogleAdId(context);
                    if (TextUtils.isEmpty(deviceId)) {
                        deviceId = Yodo1DeviceUtils.getDeviceId(context);
                    }

                    Yodo1SharedPreferences.put(context, "YDEVICEID", deviceId);//保存设备ID

                    String data = Yodo1SharedPreferences.getString(context, KEY_DATA_IDENTIFER);
                    String data_identifer = !TextUtils.isEmpty(data) ? !data.equals("null") ? data : "0" : "0";
                    if(TextUtils.isEmpty(JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON))){
                        YLog.e("onineconfig.json not exist ");
                        data_identifer="0";
                        Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, data_identifer);
                    }else{
                        YLog.e("onineconfig.json exist "+JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON).length());
                    }

                    String time = System.currentTimeMillis() + "";
                    String sign = MD5EncodeUtil.MD5Encode(appKey + appVersionName + ChannelCode + time + "yodo1");//签名

                    String location_identifer = Yodo1SharedPreferences.getString(context, KEY_LOCATION_IDENTIFER);
                    if (!TextUtils.isEmpty(location_identifer)) {
                        String location_identifer_ttl = Yodo1SharedPreferences.getString(context, KEY_LOCATION_IDENTIFER_TTL);
                        String timestamp_getdata = Yodo1SharedPreferences.getString(context, KEY_TIMESTAMP_GETDATA);
                        try {
                            long time_ttl = Long.valueOf(location_identifer_ttl);
                            long time_getdata = Long.valueOf(timestamp_getdata);
                            long time_now = Long.valueOf(time);

                            //在线参数本次请求的时间戳和上次请求返回的时间戳比较   大于上次请求返回的有效时长  清空location_identifer和data_identifer
                            if ((time_getdata - time_now) > (time_ttl * 60 * 60 * 1000)) {
                                location_identifer = "";
                                data_identifer = "0";
                                Yodo1SharedPreferences.put(context, KEY_LOCATION_IDENTIFER, "");//删除本地已经缓存的地理标识
                            }
                        } catch (NumberFormatException e) {
                            location_identifer = "";
                        }
                    } else {
                        location_identifer = "";
                    }

                    JSONObject dataJson = new JSONObject();
                    try {
                        dataJson.put("game_appkey", appKey);
                        dataJson.put("device_id", deviceId);//设备ID
                        dataJson.put("version", appVersionName);
                        dataJson.put("channel", ChannelCode);
                        dataJson.put("sdk_type", SDKTyoe);
                        dataJson.put("sdk_version", SDKVersion);
                        dataJson.put("data_identifer", data_identifer);
                        dataJson.put("location_identifer", location_identifer);
                        dataJson.put("location_lng", location_lng);
                        dataJson.put("location_lat", location_lat);
                        dataJson.put("timestamp", time);
                        dataJson.put("sign", sign);

                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    String submitStr = dataJson.toString();
                    YLog.d(TAG + "Request body: " + submitStr);
                    String url = getOnlineConfigUrl();
                    Request<String> request = NoHttp.createStringRequest(url, RequestMethod.POST);
                    request.setDefineRequestBody(submitStr, "text/plain;charset=UTF-8");
                    YLog.d(TAG + "Sending POST request to " + request.url());
                    Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
                        @Override
                        public void onSucceed(int what, Response<String> response) {
                            YLog.d(TAG + "Connect onSucceed, the response: " + response.get());
                            Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                            listener.onYodo1RequestComplete(resp);
                        }

                        @Override
                        public void onFailed(int what, Response<String> response) {
                            YLog.d(TAG + "Connect onFailed");
                            Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                            listener.onYodo1RequestComplete(resp);
                        }
                    }, false);
                } catch (Exception e) {
                } catch (Error error) {
                }

                Looper.loop();
            }
        }).start();

    }

    /**
     * 获取广告数据
     *
     * @return
     * @throws JSONException
     */
    public JSONObject getJsonData() throws JSONException {
        if (context == null) {
            return null;
        }

        if (dataObj != null) {
            return dataObj;//若JsaonArray数据不为空  直接返回
        }

        String data = JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON);
        if (!TextUtils.isEmpty(data)) {
            dataObj = new JSONObject(data);
        }
        return dataObj;
    }

    /**
     * 获取高级测试信息
     *
     * @return
     * @throws JSONException
     */
    public JSONObject getJsonTestData() throws JSONException {

        if (testObj != null) {
            return testObj;//若JsaonArray数据不为空  直接返回
        }

        String data = Yodo1SharedPreferences.getString(context, KEY_ONLINECONFIG_TEST_INFO);
        if (!TextUtils.isEmpty(data)) {
            testObj = new JSONObject(data);
        }
        return testObj;
    }

    /**
     * 判断本地是否有数据
     *
     * @return
     */
    public boolean hasData() {
        boolean bl = false;

        if (context == null) {
            return false;
        }

        String data = JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON);
        if (!TextUtils.isEmpty(data)) {
            bl = true;
        }
        return bl;
    }

    /**
     * 提供给外部调用
     */
    public void getOnlineConfig(final Yodo1OnlineConfigListener listener) {

        if (TextUtils.isEmpty(appKey)) {
            return;
        }

        //后台进入前台二十分钟后重新请求数据
        if (System.currentTimeMillis() - time < 60000 * 20) {
            return;
        }
        time = System.currentTimeMillis();

        getOnlineConfig(new Yodo1RequestListener() {
            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                YLog.d(TAG + "onYodo1RequestComplete, the response string: " + resMsg);

                int errorCode = -1;
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg);
                        errorCode = jsonObj.optInt("error_code");

                        if (errorCode == 0) {
                            String data_identifer = jsonObj.optString("data_identifer");
                            String location_identifer = jsonObj.optString("location_identifer");//地理标识  客户端本地存
                            String location_identifer_ttl = jsonObj.optString("location_identifer_ttl");//地理标识有效时长   小时，客户端本地存

                            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, data_identifer);
                            //当本地地理标识为空的时候再保存获取到的地理标识
                            if (TextUtils.isEmpty(Yodo1SharedPreferences.getString(context, KEY_LOCATION_IDENTIFER))) {
                                Yodo1SharedPreferences.put(context, KEY_LOCATION_IDENTIFER, location_identifer);
                            }
                            Yodo1SharedPreferences.put(context, KEY_LOCATION_IDENTIFER_TTL, location_identifer_ttl);

                            boolean is_test_model = jsonObj.optBoolean("is_test_model");//当前是否为测试设备
                            String device_source = jsonObj.optString("device_source");
                            JSONObject testListObj = jsonObj.optJSONObject("test_list");//测试列表信息  目前只有adlist 之后还会有其他的

                            Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG_TESTDEVICE, is_test_model);
                            Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG_TESTDEVICE_SOURCE, device_source);
                            if (testListObj != null) {
                                Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG_TEST_INFO, testListObj.toString());
                            }

                            JSONObject objData = jsonObj.optJSONObject("data");
                            objData.put("is_test_model", is_test_model);
                            objData.put("device_source", device_source);
//                            Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG, objData.toString());
                            JsonCacheUtils.writeJson(context, objData, KEY_CACHE_FILE_JSON);
                            Yodo1SharedPreferences.put(context, KEY_TIMESTAMP_GETDATA, System.currentTimeMillis() + "");

                            listener.getDataFinish(errorCode, objData.toString());

                            sendMsg();
                        } else if (errorCode == 10) {
                            YLog.d(TAG + "onYodo1RequestComplete, 本地参数已是最新，无需更新");
                            String onlineconfig = JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON);
                            listener.getDataFinish(errorCode, onlineconfig);

                            sendMsg();
                        } else {
                            String error = jsonObj.optString("error");
                            YLog.d(TAG + "onYodo1RequestComplete, 获取在线参数异常, 需获取静态参数, ErrorCode: " + errorCode + ", Error: " + error);
                            //需拼接静态参数，获取在线参数静态数据
                            time = 0;
                            getCDNOnlineConfig(listener);
                        }

                    } else {
                        time = 0;
                        getCDNOnlineConfig(listener);
                    }
                } catch (JSONException e) {
                    YLog.d(TAG + "onYodo1RequestComplete, json解析异常, 需获取静态参数, message: " + e.getMessage() + ", cause: " + e.getCause());
                    time = 0;
                    getCDNOnlineConfig(listener);
                }
            }
        });
    }

    /**
     * 获取在线参数
     *
     * @param key
     * @return
     */
    public String getConfigParam(String key, String defaultValue) {
        String result = defaultValue;
        try {
            JSONObject obj = getJsonData();
            if (obj != null && !TextUtils.isEmpty(obj.optString(key))) {
                result = obj.optString(key);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d(TAG + "getConfigParam " + key + " = " + result);
        return result;

    }

    /**
     * 在线参数初始化
     *
     * @param context
     */
    public void init(final Context context, final String appKey) {
        if (initialized) {
            return;
        }
        initialized = true;

        this.appKey = appKey;
        this.context = context;

        if (TextUtils.isEmpty(ChannelCode)) {
            ChannelCode = Yodo1CommonUtils.getMetedataStr(context, "Yodo1ChannelCode");
            SDKVersion = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKVersion");
            SDKTyoe = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKType");
        }

        if (TextUtils.isEmpty(ChannelCode)) {
            ChannelCode = "Default";
        }
        YLog.v("*********** Yodo1 Info ***********");
        YLog.v("App Key: " + appKey);
        YLog.d("Publish Channel: " + ChannelCode);
        YLog.v("Sdk Type: " + SDKTyoe);
        YLog.v("Sdk Version: " + SDKVersion);
        YLog.v("*********** Yodo1 Info ***********");


        appPackageName = SysUtils.getPackageName(context);
        appVersionName = SysUtils.getVersionName(context);
        String localAppKey = Yodo1SharedPreferences.getString(context, KEY_GAME_APPK);
        String localAppPackageName = Yodo1SharedPreferences.getString(context, KEY_GAME_PACKAGE_NAME);
        String localAppVersionName = Yodo1SharedPreferences.getString(context, KEY_GAME_VERSION_NAME);
        if (!TextUtils.isEmpty(localAppKey) && !localAppKey.equals(appKey)) {
            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, "0");
        }
        if (!TextUtils.isEmpty(localAppPackageName) && !localAppPackageName.equals(appPackageName)) {
            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, "0");
        }
        if (!TextUtils.isEmpty(localAppVersionName) && !localAppVersionName.equals(appVersionName)) {
            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, "0");
        }

        Yodo1SharedPreferences.put(context, KEY_GAME_APPK, appKey);
        Yodo1SharedPreferences.put(context, KEY_GAME_PACKAGE_NAME, appPackageName);
        Yodo1SharedPreferences.put(context, KEY_GAME_VERSION_NAME, appVersionName);
        Yodo1SharedPreferences.put(context, KEY_GAME_CHANNEL_CODE, ChannelCode);

        Yodo1HttpManage.getInstance().initHttp(context);
    }

    /**
     * 在线参数初始化
     *
     * @param context
     */
    public void initConfig(final Context context) {
        this.context = context;
        getLocation();//读取当前位置
    }

    /**
     * 根据接口获取在线参数静态数据
     */
    private void getCDNOnlineConfig(final Yodo1OnlineConfigListener listener) {
        getCDNOnlineConfig(new Yodo1RequestListener() {
            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                YLog.d(TAG + "CDN onYodo1RequestComplete, the response string:" + resMsg);
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg.replace(" ", ""));

                        String data_identifer = jsonObj.optString(KEY_DATA_IDENTIFER);
                        YLog.d(TAG + "CDN onYodo1RequestComplete data_identifer : " + data_identifer);

                        String location_identifer = jsonObj.optString(KEY_LOCATION_IDENTIFER);
                        YLog.d(TAG + "CDN onYodo1RequestComplete location_identifer : " + location_identifer);

                        String local_data = Yodo1SharedPreferences.getString(context, KEY_DATA_IDENTIFER);
                        if (TextUtils.isEmpty(local_data)) {
                            local_data = "0";
                        }

                        if (Long.valueOf(data_identifer) > Long.valueOf(local_data)) {
                            JSONObject objData = jsonObj.optJSONObject("data");
                            boolean is_test_model = jsonObj.optBoolean("is_test_model");//当前是否为测试设备
                            String device_source = jsonObj.optString("device_source");
                            JSONObject testListObj = jsonObj.optJSONObject("test_list");//测试列表信息  目前只有adlist 之后还会有其他的

                            Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG_TEST_INFO, testListObj.toString());
                            Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG_TESTDEVICE, is_test_model);
                            Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG_TESTDEVICE_SOURCE, device_source);
                            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, data_identifer);
//                            Yodo1SharedPreferences.put(context, KEY_ONLINECONFIG, objData.toString());

                            JsonCacheUtils.writeJson(context, objData, KEY_CACHE_FILE_JSON);

                            listener.getDataFinish(0, objData.toString());
                        } else {
                            String onlineconfig = JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON);
                            listener.getDataFinish(0, onlineconfig);
                        }
                        sendMsg();
                    } else {
                        listener.getDataFinish(-1, "");
                    }


                } catch (JSONException e) {
                    YLog.d(TAG + "CDN onYodo1RequestComplete, json解析异常, message: " + e.getMessage() + ", cause: " + e.getCause());
                    listener.getDataFinish(-1, "");
                }

            }
        });
    }

    /**
     * 根据接口获取在线参数
     *
     * @param listener 回调
     */
    private void getCDNOnlineConfig(final Yodo1RequestListener listener) {
        String url = URL_ONLINECONFIG_CDN + MD5EncodeUtil.MD5Encode(appKey) + ".json";

        Request<String> request = NoHttp.createStringRequest(url);
        YLog.d(TAG + "Connecting to the CDN configuration, the request url: " + request.url());
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d(TAG + "Connect CDN configuration onSucceed, the response: " + response.get());
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                YLog.d(TAG + "Connect CDN configuration onFailed");
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }


    /**
     * 获取当前的位置信息
     */
    private void getLocation() {
        try {
            String[] permissions1 = new String[]{Manifest.permission.ACCESS_COARSE_LOCATION};
            String[] permissions2 = new String[]{Manifest.permission.ACCESS_FINE_LOCATION};

            boolean permissionCheck = Yodo1PermissonUtils.hasPermissionForManifest(context, permissions1);
            boolean permissionCheck2 = Yodo1PermissonUtils.hasPermissionForManifest(context, permissions2);

            if (permissionCheck || permissionCheck2) {
                boolean permissionCheck3 = Yodo1PermissonUtils.hasPermission(context, permissions1);
                boolean permissionCheck4 = Yodo1PermissonUtils.hasPermission(context, permissions2);

                if (permissionCheck3 || permissionCheck4) {
                    LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);

                    Location location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
                    if (location != null) {
                        YLog.d(TAG + "getLocation 当前GPS定位经纬度为: getLatitude = " + location.getLatitude() + ", getLongitude = " + location.getLongitude());
                        location_lng = String.format("%.2f", location.getLongitude());
                        location_lat = String.format("%.2f", location.getLatitude());
                    } else {
                        location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);

                        if (location != null) {
                            YLog.d(TAG + "getLocation 当前网络定位经纬度为: getLatitude = " + location.getLatitude() + ", getLongitude = " + location.getLongitude());

                            location_lng = String.format("%.2f", location.getLongitude());
                            location_lat = String.format("%.2f", location.getLatitude());
                        }
                    }
                } else {
                    YLog.d(TAG + "getLocation 当前应用未授权获取到定位权限");
                }

            } else {
                YLog.d(TAG + "getLocation Manifest中缺少 ACCESS_COARSE_LOCATION 定位权限");
            }
        } catch (Exception e) {
            YLog.d(TAG + "getLocation 当前定位异常");
        }
    }


    /**
     * 拉取到在线参数之后发送广播初始化
     */
    private void sendMsg() {
        YLog.d(TAG + "sendMsg 获取到在线参数，发送广播");
        context.sendBroadcast(new Intent(ONLINECONFIG_ACTION));
    }

    public void onDestroy() {
//        context = null;
        time = 0;
        initialized = false;
        dataObj = null;
        testObj = null;
        location_lng = "";
        location_lat = "";
    }

}
