package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.vungle.warren.BuildConfig;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author yodo1
 */
public class AdvertAdaptervungle extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptervungle] ";
    private static final String CHANNEL_CODE = "Vungle";

    private static final String KEY_VUNGLE_APP_ID = "ad_vungle_app_id";
    private static final String VUNGLE_PLACEMENTID = "ad_vungle_video_placementid";
    private static final String VUNGLE_INTERSTITIAL_PLACEMENTID = "ad_vungle_inter_placementid";

    private static String appId, interstitialPlacementId, rewardedPlacementId;

    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback() {

        @Override
        public void onAdStart(String placementReferenceId) {
            YLog.d(TAG + "PlayAdCallback onAdStart, placementReferenceId: " + placementReferenceId);

            if (placementReferenceId.equals(interstitialPlacementId)) {
                if (getIntersititalCallback() != null) {
                    getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }

            if (placementReferenceId.equals(rewardedPlacementId)) {
                if (getVideoCallback() != null) {
                    getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }
        }

        @Override
        public void onAdEnd(String placementReferenceId, boolean completed, boolean isCTAClicked) {
            YLog.d(TAG + "PlayAdCallback onAdEnd, placementReferenceId: " + placementReferenceId + ", completed: " + completed + ", isCTAClicked: " + isCTAClicked);

            if (placementReferenceId.equals(interstitialPlacementId) && getIntersititalCallback() != null) {
                if (isCTAClicked) {
                    getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                }

                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (placementReferenceId.equals(rewardedPlacementId) && getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                if (completed) {
                    YLog.d(TAG + "Vungle,  onAdEnd  关闭");
                    getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
                }
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d(TAG + "PlayAdCallback onError, placementReferenceId: " + placementReferenceId + ", Throwable message: " + throwable.getMessage());
        }
    };

    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback() {

        @Override
        public void onAdLoad(String placementReferenceId) {
            YLog.d(TAG + "LoadAdCallback onAdLoad, placementReferenceId: " + placementReferenceId);
            if (getReloadInterCallback() != null && placementReferenceId.equals(interstitialPlacementId)) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }

            if (getReloadVideoCallback() != null && placementReferenceId.equals(rewardedPlacementId)) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d(TAG + "LoadAdCallback onError placementReferenceId: " + placementReferenceId + ", Throwable message: " + throwable.getMessage());

            if (getReloadInterCallback() != null && placementReferenceId.equals(interstitialPlacementId)) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, throwable.getMessage() + "", getAdvertCode());
            }
            if (getReloadVideoCallback() != null && placementReferenceId.equals(rewardedPlacementId)) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, throwable.getMessage() + "", getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return BuildConfig.VERSION_NAME;
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {
    }


    @Override
    public void initSdk(final Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null || this.isInitialized()) {
            return;
        }

        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_VUNGLE_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_VUNGLE_APP_ID);
        }
        if (TextUtils.isEmpty(appId)) {
            YLog.d(TAG + "Initialize sdk failure, appId: " + appId);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                updatePrivacyConsent();

                Vungle.init(appId, activity.getApplicationContext(), new InitCallback() {
                    @Override
                    public void onSuccess() {
                        setInitialized(true);
                        YLog.d(TAG + "Initialize sdk successful, onSuccess");
                        initializeCallback.onInitializeSuccess(getAdvertCode());
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        YLog.d(TAG + "init onError, cause message: " + throwable.getMessage());
                        initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "init error: " + throwable.getMessage(), getAdvertCode());
                    }

                    @Override
                    public void onAutoCacheAdAvailable(String s) {
                        YLog.d(TAG + "init onAutoCacheAdAvailable, s: " + s);
                    }
                });
            }
        });
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, VUNGLE_INTERSTITIAL_PLACEMENTID);
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            YLog.d(TAG + "Initialize interstitial video ad failure, interstitialPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialPlacementId is null", getAdvertCode());
            return;
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial video ad successful, interstitialPlacementId: " + interstitialPlacementId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);

        boolean isReady = interstitialAdvertIsLoaded(activity);
        YLog.d(TAG + "Showing interstitial video ad...");

        if (isReady) {
            Vungle.playAd(interstitialPlacementId, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, final Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);

        YLog.d(TAG + "Loading interstitial video ad...");
        this.updatePrivacyConsent();
        if (Vungle.isInitialized()) {
            Vungle.loadAd(interstitialPlacementId, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(interstitialPlacementId);
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, VUNGLE_PLACEMENTID);
        if (TextUtils.isEmpty(rewardedPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, rewardedPlacementId is null");

            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "rewardedPlacementId is null", getAdvertCode());
            return;
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, rewardedPlacementId: " + rewardedPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setVideoCallback(callback);

        boolean isReady = videoAdvertIsLoaded(activity);
        YLog.d(TAG + "Showing rewarded video ad...");

        if (isReady) {
            Vungle.playAd(rewardedPlacementId, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);

        YLog.d(TAG + "Loading rewarded video ad...");
        this.updatePrivacyConsent();
        if (Vungle.isInitialized()) {
            Vungle.loadAd(rewardedPlacementId, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(rewardedPlacementId);
    }

    private void updatePrivacyConsent() {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            YLog.d(TAG + "GDPR: " + privacy.isHasUserConsent() + ", COPPA: " + privacy.isAgeRestrictedUser() + ", CCPA: " + privacy.isDoNotSell());

            Vungle.Consent consentStatus = privacy.isHasUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
            Vungle.updateConsentStatus(consentStatus, "");
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
