package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.UnityServices;
import com.unity3d.services.monetization.IUnityMonetizationListener;
import com.unity3d.services.monetization.UnityMonetization;
import com.unity3d.services.monetization.placementcontent.ads.IShowAdListener;
import com.unity3d.services.monetization.placementcontent.ads.ShowAdPlacementContent;
import com.unity3d.services.monetization.placementcontent.core.PlacementContent;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author yodo1
 */
public class AdvertAdapterunityads extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterunityads] ";
    private static final String CHANNEL_CODE = "Unityads";

    private static final String KEY_UNITYADS_APP_ID = "ad_unityads_app_id";
    private static final String KEY_UNITYADS_INTERSTITIAL_ID = "ad_unityads_interstitial_id";
    private static final String KEY_UNITYADS_REWARDED_ID = "ad_unityads_rewarded_id";

    private String appId;
    private String interstitialPlacementId;
    private String rewardedPlacementId;

    private IUnityMonetizationListener monetizationListener = new IUnityMonetizationListener() {
        @Override
        public void onPlacementContentReady(String placementId, PlacementContent placementcontent) {
            YLog.d(TAG + "onPlacementContentReady, placementId: " + placementId);
            if (getReloadInterCallback() != null && placementId.equals(interstitialPlacementId)) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }

            if (getReloadVideoCallback() != null && placementId.equals(rewardedPlacementId)) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onPlacementContentStateChange(String placementId, PlacementContent placementcontent, UnityMonetization.PlacementContentState previousState, UnityMonetization.PlacementContentState newState) {
            YLog.d(TAG + "onPlacementContentStateChange, placementId: " + placementId);
        }

        @Override
        public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
            YLog.d(TAG + "onUnityServicesError, error: " + error.name() + ", message: " + message);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "code:" + error.name() + ", msg:" + message, getAdvertCode());
            }

            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "code:" + error.name() + ", msg:" + message, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return UnityAds.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isInitialized()) {
            return;
        }

        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNITYADS_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNITYADS_APP_ID);
        }

        if (TextUtils.isEmpty(appId)) {
            YLog.i(TAG + "Initialize sdk failure, appId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }

        if (!UnityServices.isInitialized()) {
            updatePrivacyConsent(activity);
            UnityMonetization.initialize(activity, appId, monetizationListener, false);
            this.setInitialized(true);
            YLog.d(TAG + "Initialize interstitial video ad successful, appId: " + appId);
            initializeCallback.onInitializeSuccess(getAdvertCode());
        }
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNITYADS_INTERSTITIAL_ID);
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            YLog.d(TAG + "Initialize interstitial video ad failure, interstitialPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialPlacementId is null", getAdvertCode());
            return;
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial video ad successful, interstitialPlacementId: " + interstitialPlacementId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d(TAG + "Showing interstitial video ad...");

        if (!interstitialAdvertIsLoaded(activity)) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
            return;
        }

        PlacementContent pc = UnityMonetization.getPlacementContent(interstitialPlacementId);
        if ("SHOW_AD".equalsIgnoreCase(pc.getType())) {
            ShowAdPlacementContent p = (ShowAdPlacementContent) pc;
            p.show(activity, new IShowAdListener() {
                @Override
                public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                    YLog.d(TAG + "InterstitialAd onAdFinished, placementId: " + placementId + ", FinishState : " + withState);

                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                }

                @Override
                public void onAdStarted(String placementId) {
                    YLog.d(TAG + "InterstitialAd onAdStarted, placementId: " + placementId);
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            });
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        this.updatePrivacyConsent(activity);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(interstitialPlacementId) && UnityMonetization.isReady(interstitialPlacementId);
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNITYADS_REWARDED_ID);
        if (TextUtils.isEmpty(rewardedPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, rewardedPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "rewardedPlacementId is null", getAdvertCode());
            return;
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, rewardedPlacementId: " + rewardedPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d(TAG + "Showing rewarded video ad...");

        if (!videoAdvertIsLoaded(activity)) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
            return;
        }

        PlacementContent pc = UnityMonetization.getPlacementContent(rewardedPlacementId);
        if (pc.getType().equalsIgnoreCase("SHOW_AD")) {
            ShowAdPlacementContent p = (ShowAdPlacementContent) pc;
            p.show(activity, new IShowAdListener() {
                @Override
                public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                    YLog.d(TAG + "RewardedAd onAdFinished, placementId: " + placementId + ", FinishState : " + withState);

                    if (placementId.equals(rewardedPlacementId) && withState == UnityAds.FinishState.COMPLETED) {
                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
                    }
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                }

                @Override
                public void onAdStarted(String placementId) {
                    YLog.d(TAG + "RewardedAd onAdStarted, placementId:" + placementId);
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            });
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        this.updatePrivacyConsent(activity);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(rewardedPlacementId) && UnityMonetization.isReady(rewardedPlacementId);
    }

    private void updatePrivacyConsent(Activity activity) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            YLog.d(TAG + "GDPR: " + privacy.isHasUserConsent() + ", COPPA: " + privacy.isAgeRestrictedUser() + ", CCPA: " + privacy.isDoNotSell());

            MetaData metaData = new MetaData(activity);
            metaData.set("gdpr.consent", privacy.isHasUserConsent());
            metaData.set("privacy.consent", !privacy.isDoNotSell());
            metaData.commit();
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
