package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.mintegral.msdk.MIntegralSDK;
import com.mintegral.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mintegral.msdk.interstitialvideo.out.MTGInterstitialVideoHandler;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Map;


/**
 * @author yodo1
 */
public class AdvertAdaptermintegral_gp extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptermintegral_gp] ";
    private static final String CHANNEL_CODE = "mintegral_gp";

    private static final String KEY_MINTEGRAL_APP_ID = "ad_mintegral_gp_appid";
    private static final String KEY_MINTEGRAL_APP_KEY = "ad_mintegral_gp_appkey";

    private static final String KEY_MINTEGRAL_REWARD_UNIT_ID = "ad_mintegral_gp_rewardUnitId";
    private static final String KEY_MINTEGRAL_INTERSTITIAL_UNIT_ID = "ad_mintegral_gp_interstitialUnitId";

    private MTGRewardVideoHandler mMvRewardVideoHandler;

    private MTGInterstitialVideoHandler mMtgInterstitalVideoHandler;
    private InterstitialVideoListener interstitialVideoListener = new InterstitialVideoListener() {

        @Override
        public void onLoadSuccess(String s) {
//            YLog.d(TAG + "InterstitialVideo onLoadSuccess");
        }

        @Override
        public void onVideoLoadSuccess(String s) {
            YLog.d(TAG + "InterstitialVideo onVideoLoadSuccess");
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onVideoLoadFail(String s) {
            YLog.d(TAG + "InterstitialVideo onInterstitialVideoLoadFail, message: " + s);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, s, getAdvertCode());
            }
        }

        @Override
        public void onShowFail(String errorMsg) {
            YLog.d(TAG + "InterstitialVideo onShowFail, message: " + errorMsg);
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onAdError(Yodo1AdConst.ADVERT_EVENT_CLOSE, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onAdShow() {
            YLog.d(TAG + "InterstitialVideo onAdShow");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(boolean isCompleteView) {
            YLog.d(TAG + "InterstitialVideo onAdClose, isCompleteView: " + isCompleteView);
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdClicked(String unitId) {
            YLog.d(TAG + "InterstitialVideo onVideoAdClicked");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onVideoComplete(String s) {
            YLog.d(TAG + "InterstitialVideo onVideoComplete");
        }

        @Override
        public void onEndcardShow(String s) {
            YLog.d(TAG + "InterstitialVideo onEndcardShow");
        }

    };
    private RewardVideoListener rewardVideoListener = new RewardVideoListener() {

        @Override
        public void onVideoLoadSuccess(String s) {
            YLog.d(TAG + "RewardVideo onVideoLoadSuccess");
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onLoadSuccess(String s) {
//            YLog.d(TAG + "RewardVideo onLoadSuccess");
        }

        @Override
        public void onVideoLoadFail(String s) {
            YLog.d(TAG + "RewardVideo onVideoLoadFail, message: " + s);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, s, getAdvertCode());
            }
        }

        @Override
        public void onShowFail(String errorMsg) {
            YLog.d(TAG + "RewardVideo onShowFail, message: " + errorMsg);
            if (getVideoCallback() != null) {
                getVideoCallback().onAdError(Yodo1AdConst.ADVERT_EVENT_CLOSE, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onAdShow() {
            YLog.d(TAG + "RewardVideo onAdShow");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(boolean isCompleteView, String RewardName, float RewardAmout) {
            YLog.d(TAG + "RewardVideo onAdClose, isCompleteView:" + isCompleteView + ", RewardName: " + RewardName + ", RewardAmout: " + RewardAmout);

            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdClicked(String unitId) {
            YLog.d(TAG + "RewardVideo onVideoAdClicked");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onVideoComplete(String s) {
            YLog.d(TAG + "RewardVideo onVideoComplete, message: " + s);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onEndcardShow(String s) {
            YLog.d(TAG + "RewardVideo onEndcardShow");
        }

    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return "10.1.51";
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_ID);
        String appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_KEY);

        if (TextUtils.isEmpty(appId) && TextUtils.isEmpty(appKey)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_ID);
            appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_KEY);
        }

        if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(appKey)) {
            YLog.d(TAG + "Initialize sdk failure, AppID or AppKey is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

//        MIntegralConstans.DEBUG = true;
        MIntegralSDK sdk = MIntegralSDKFactory.getMIntegralSDK();
        // test appId and appKey

        this.updatePrivacyConsent(activity);

        Map<String, String> map = sdk.getMTGConfigurationMap(appId, appKey);

        // if you modify applicationId, please add the following attributes,
        // otherwise it will crash
        // map.put(MobVistaConstans.PACKAGE_NAME_MANIFEST, "your AndroidManifest
        // package value");
        sdk.init(map, activity.getApplication());

        this.setInitialized(true);
        YLog.d(TAG + "Initialize sdk successful, " + "AppID: " + appId + ", AppKey: " + appKey);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isInterInitialized()) {
            return;
        }

        String interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_MINTEGRAL_INTERSTITIAL_UNIT_ID);
        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(TAG + "Initialize interstitial video ad failure, interUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interUnitId is null", getAdvertCode());
            return;
        }

        mMtgInterstitalVideoHandler = new MTGInterstitialVideoHandler(activity, interUnitId);
        mMtgInterstitalVideoHandler.setInterstitialVideoListener(interstitialVideoListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial video ad successful, " + "interUnitId: " + interUnitId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);
        YLog.d(TAG + "Showing interstitial video ad...");
        if (interstitialAdvertIsLoaded(activity)) {
            mMtgInterstitalVideoHandler.show();
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        YLog.d(TAG + "Loading interstitial video ad...");
        this.setReloadInterCallback(callback);

        this.updatePrivacyConsent(activity);

        if (!interstitialAdvertIsLoaded(activity)) {
            mMtgInterstitalVideoHandler.load();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return mMtgInterstitalVideoHandler != null && mMtgInterstitalVideoHandler.isReady();
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isVideoInitialized()) {
            return;
        }

        String videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_MINTEGRAL_REWARD_UNIT_ID);
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoUnitId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoUnitId is null", getAdvertCode());
            return;
        }

        mMvRewardVideoHandler = new MTGRewardVideoHandler(activity, videoUnitId);
        mMvRewardVideoHandler.setRewardVideoListener(rewardVideoListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, " + "videoUnitId: " + videoUnitId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");
        if (videoAdvertIsLoaded(activity)) {
            mMvRewardVideoHandler.show("1");
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");
        this.updatePrivacyConsent(activity);
        if (!videoAdvertIsLoaded(activity)) {
            mMvRewardVideoHandler.load();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return mMvRewardVideoHandler != null && mMvRewardVideoHandler.isReady();
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        super.setPrivacy(privacy, context);
        YLog.d(TAG + "Set privacy, consent: " + privacy.isHasUserConsent() + ", is child: " + privacy.isAgeRestrictedUser());
    }

    private void updatePrivacyConsent(Activity activity) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            YLog.d(TAG + "GDPR: " + privacy.isHasUserConsent() + ", COPPA: " + privacy.isAgeRestrictedUser() + ", CCPA: " + privacy.isDoNotSell());

            MIntegralSDK sdk = MIntegralSDKFactory.getMIntegralSDK();
            sdk.setUserPrivateInfoType(activity, "authority_all_info", 1);
            sdk.setConsentStatus(activity, 1);
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
